package com.xforceplus.ultramanflows.controller;


/**
 * 流历史对象feign客户端
 *
 * @author ultraman
 * @date 2023-12-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultramanflows.entity.FlowHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-flows")
public interface FlowHistoryFeignApi {

  /**
   * 通过id查询流历史对象
   * @param  id
   * @return R
   */
  @GetMapping("/flowHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增流历史对象
   * @param flowHistory 流历史对象
   * @return R
   */
  @PostMapping("/flowHistory/add")
  public R save(@RequestBody FlowHistory flowHistory);

  /**
   * 修改流历史对象
   * @param flowHistory 流历史对象
   * @return R
   */
  @PostMapping("/flowHistory/update")
  public R updateById(@RequestBody FlowHistory flowHistory);

  /**
   * 通过id删除流历史对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/flowHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}