package com.xforceplus.ultramanflows.controller;


/**
 * 逻辑流历史feign客户端
 *
 * @author ultraman
 * @date 2023-12-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultramanflows.entity.LogicFlowHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-flows")
public interface LogicFlowHistoryFeignApi {

  /**
   * 通过id查询逻辑流历史
   * @param  id
   * @return R
   */
  @GetMapping("/logicFlowHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增逻辑流历史
   * @param logicFlowHistory 逻辑流历史
   * @return R
   */
  @PostMapping("/logicFlowHistory/add")
  public R save(@RequestBody LogicFlowHistory logicFlowHistory);

  /**
   * 修改逻辑流历史
   * @param logicFlowHistory 逻辑流历史
   * @return R
   */
  @PostMapping("/logicFlowHistory/update")
  public R updateById(@RequestBody LogicFlowHistory logicFlowHistory);

  /**
   * 通过id删除逻辑流历史
   * @param  id
   * @return R
   */
  @DeleteMapping("/logicFlowHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}