package com.xforceplus.ultramanflows.controller;


/**
 * 状态流历史feign客户端
 *
 * @author ultraman
 * @date 2023-12-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultramanflows.entity.StateFlowHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-flows")
public interface StateFlowHistoryFeignApi {

  /**
   * 通过id查询状态流历史
   * @param  id
   * @return R
   */
  @GetMapping("/stateFlowHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增状态流历史
   * @param stateFlowHistory 状态流历史
   * @return R
   */
  @PostMapping("/stateFlowHistory/add")
  public R save(@RequestBody StateFlowHistory stateFlowHistory);

  /**
   * 修改状态流历史
   * @param stateFlowHistory 状态流历史
   * @return R
   */
  @PostMapping("/stateFlowHistory/update")
  public R updateById(@RequestBody StateFlowHistory stateFlowHistory);

  /**
   * 通过id删除状态流历史
   * @param  id
   * @return R
   */
  @DeleteMapping("/stateFlowHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}