package com.xforceplus.ultramanflows.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-12-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultramanflows.entity.UserTask;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-flows")
public interface UserTaskFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/userTask/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param userTask ${table.comment}
   * @return R
   */
  @PostMapping("/userTask/add")
  public R save(@RequestBody UserTask userTask);

  /**
   * 修改${table.comment}
   * @param userTask ${table.comment}
   * @return R
   */
  @PostMapping("/userTask/update")
  public R updateById(@RequestBody UserTask userTask);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/userTask/del/{id}" )
  public R removeById(@PathVariable Long id);

}