/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.core.impl.LocalDataQueryProvider;
import com.xforceplus.ultraman.adapter.core.impl.LocalEntityFacadeImpl;
import com.xforceplus.ultraman.adapter.graphql.LocalMutationProvider;
import com.xforceplus.ultraman.adapter.graphql.LocalQueryProvider;
import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.impl.EntityQueryServiceImpl;
import com.xforceplus.ultraman.core.impl.EntityWriteServiceImpl;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.SQLMasterStorage;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.MutationProvider;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.base.id.IdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.StaticNodeIdGenerator;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.local.enabled"}, matchIfMissing=true)
public class LocalOqsengineAutoConfiguration {
    @Bean
    public MasterStorage masterStorage(DataSource ds, ObjectMapper mapper, @Qualifier(value="commonPool") ExecutorService executorService, EntityClassEngine engine, ExecutionConfig executionConfig, PlatformTransactionManager manager, @Value(value="${xplat.oqsengine.sdk.schema.schedule.init:300}") long initTime, @Value(value="${xplat.oqsengine.sdk.schema.schedule.period:60}") long periodTime) {
        return new SQLMasterStorage(manager, ds, mapper, executorService, engine, (long)executionConfig.getQueryTimeout(), periodTime, initTime);
    }

    @Bean
    public EntityWriteService entityWriteService(MasterStorage masterStorage, EntityClassEngine engine) {
        return new EntityWriteServiceImpl(masterStorage, engine);
    }

    @Bean
    public EntityQueryService entityQueryService(MasterStorage masterStorage, EntityClassEngine engine) {
        return new EntityQueryServiceImpl(masterStorage, engine);
    }

    @Bean
    public IdGenerator snowFlakeIdGenerator() {
        return new SnowflakeLongIdGenerator((NodeIdGenerator)new StaticNodeIdGenerator(0));
    }

    @Bean
    public MutationProvider localMutationProvider(EntityFacade entityFacade) {
        return new LocalMutationProvider(entityFacade);
    }

    @Lazy
    @Bean
    public EntityFacade entityFacade() {
        return new LocalEntityFacadeImpl();
    }

    @Bean
    public DataQueryProvider dataQueryProvider(EntityQueryService entityQueryService, ContextService contextService) {
        return new LocalDataQueryProvider(entityQueryService, contextService);
    }

    @Lazy
    @Bean
    public QueryProvider localQueryProvider(EntityFacade entityFacade, ContextService contextService) {
        return new LocalQueryProvider(entityFacade, contextService);
    }
}

