/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.xforceplus.ultraman.oqsengine.plus.common.datasource.log.LoggerDataSource;
import com.xforceplus.ultraman.sdk.infra.base.thread.ExecutorHelper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.Metrics;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
public class OqsDatasourceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OqsDatasourceAutoConfiguration.class);
    private String DATA_SOURCES = "dataSources";

    @ConditionalOnMissingBean(value={DataSource.class})
    @Primary
    @Bean
    public DataSource staticConfigDatasource(Environment environment) {
        List configList;
        String activeProfile;
        String[] activeProfiles = environment.getActiveProfiles();
        String baseName = "oqs-datasource";
        Config baseConfig = ConfigFactory.load((String)baseName);
        Config config = null;
        if (activeProfiles.length > 0 && !(activeProfile = activeProfiles[0]).equalsIgnoreCase("DEFAULT") && !StringUtils.isEmpty((CharSequence)activeProfile)) {
            try {
                Config extend = ConfigFactory.load((String)"oqs-datasource-".concat(activeProfile));
                config = extend.withFallback((ConfigMergeable)baseConfig).resolve();
            }
            catch (Throwable throwable) {
                log.warn("Cannot find related {}", (Object)activeProfile);
            }
        }
        if (config == null) {
            config = baseConfig;
        }
        if ((configList = config.getConfigList(this.DATA_SOURCES)).isEmpty()) {
            throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        DataSource main = OqsDatasourceAutoConfiguration.buildDataSource("main", (Config)configList.get(0), true);
        return main;
    }

    private static DataSource buildDataSource(String name, Config config, boolean showSql) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        hikariConfig.setPoolName(name);
        hikariConfig.setMetricRegistry((Object)Metrics.globalRegistry);
        config.entrySet().stream().forEach(e -> {
            try {
                OqsDatasourceAutoConfiguration.invokeMethod(hikariConfig, (String)e.getKey(), (ConfigValue)e.getValue());
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Configuration error, wrong property '%s' '%s'.", e.getKey(), e.getValue()));
            }
        });
        hikariConfig.setThreadFactory(ExecutorHelper.buildNameThreadFactory((String)"jdbc-pool", (boolean)false));
        if (showSql) {
            return new LoggerDataSource((DataSource)new HikariDataSource(hikariConfig));
        }
        return new HikariDataSource(hikariConfig);
    }

    private static void invokeMethod(HikariConfig hikariConfig, String attrName, ConfigValue value) throws Exception {
        Class<?> clazz = hikariConfig.getClass();
        String methodName = "set" + attrName.toUpperCase(Locale.US).substring(0, 1) + attrName.substring(1);
        Method method = null;
        switch (value.valueType()) {
            case NUMBER: {
                try {
                    method = clazz.getMethod(methodName, Long.TYPE);
                }
                catch (NoSuchMethodException ex) {
                    method = clazz.getMethod(methodName, Integer.TYPE);
                }
                break;
            }
            case STRING: {
                method = clazz.getMethod(methodName, String.class);
                break;
            }
            case BOOLEAN: {
                method = clazz.getMethod(methodName, Boolean.TYPE);
                break;
            }
            default: {
                throw new NoSuchMethodException(String.format("The '%s' property setting could not be found.", attrName));
            }
        }
        method.invoke((Object)hikariConfig, value.unwrapped());
    }
}

