/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.graphql;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.MutationProvider;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateOneResult;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMutationProvider
implements MutationProvider {
    private static final Logger log = LoggerFactory.getLogger(LocalMutationProvider.class);
    private EntityFacade entityFacade;

    public LocalMutationProvider(EntityFacade entityFacade) {
        this.entityFacade = entityFacade;
    }

    public boolean accept(IEntityClass entityClass) {
        return entityClass.getType() != 1;
    }

    public String create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.create(entityClass, body, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Long)join.get()).toString();
        }
        throw new RuntimeException(((CreateOneResult)join.getLeft()).getMessage());
    }

    public String batchCreate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.createMulti(entityClass, inputBodies.stream(), context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((CreateMultiResult)join.getLeft()).getMessage());
    }

    public String update(IEntityClass entityClass, long id, Map<String, Object> body, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.updateById(entityClass, Long.valueOf(id), body, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((UpdateOneResult)join.getLeft()).getMessage());
    }

    public String batchUpdate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.updateMulti(entityClass, inputBodies, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((UpdateMultiResult)join.getLeft()).getMessage());
    }

    public String delete(IEntityClass entityClass, long id, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.deleteOne(entityClass, Long.valueOf(id), context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((DeleteOneResult)join.getLeft()).getMessage());
    }

    public String batchDelete(IEntityClass entityClass, List<Long> ids, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.deleteMulti(entityClass, ids, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((DeleteMultiResult)join.getLeft()).getMessage());
    }

    public String custom(IEntityClass entityClass, String actionName, Map<String, Object> argument, Map<String, Object> all) {
        throw new RuntimeException("not support");
    }
}

