/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.config;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.plus.common.datasource.MasterResolver;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourceFactory;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourcePackage;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicDataSource;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicRouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.RouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import java.util.Collections;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class OqsDatasourceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OqsDatasourceAutoConfiguration.class);
    private String DATA_SOURCES = "dataSources";

    @Bean(value={"master"})
    public DataSource dynamicDataSource(ProfileFetcher fetcher, ContextService contextService, DynamicConfig dynamicConfig, Environment environment) {
        MasterResolver resolver = new MasterResolver();
        DataSourcePackage dataSourcePackage = DataSourceFactory.build((boolean)false, (boolean)false, Collections.singletonList(resolver), (String[])environment.getActiveProfiles());
        DynamicRouteMappingProvider routeMappingProvider = new DynamicRouteMappingProvider(dynamicConfig.getMasterRouting());
        return new DynamicDataSource(dataSourcePackage, (RouteMappingProvider)routeMappingProvider, fetcher, contextService);
    }

    @ConditionalOnMissingBean(value={JdbcTemplate.class})
    @Bean
    public JdbcTemplate jdbcTemplate(@Qualifier(value="master") DataSource datasource) {
        return new JdbcTemplate(datasource);
    }

    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    @Bean(name={"springTransactionManager"})
    public PlatformTransactionManager transactionManager(@Autowired DynamicDataSource dataSource) {
        return new DataSourceTransactionManager((DataSource)dataSource);
    }
}

