package com.xforceplus.ultraman.adapter.config;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.plus.common.datasource.MasterResolver;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourceFactory;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourcePackage;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicDataSource;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicRouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.RouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

import javax.sql.DataSource;
import java.util.Collections;

@Slf4j
@Configuration
public class OqsDatasourceAutoConfiguration {

    private String DATA_SOURCES = "dataSources";

    @Bean("master")
    public DataSource dynamicDataSource(ProfileFetcher fetcher, ContextService contextService,
                                        DynamicConfig dynamicConfig, Environment environment) {
        MasterResolver resolver = new MasterResolver();
        DataSourcePackage dataSourcePackage = DataSourceFactory.build(false, false, Collections.singletonList(resolver), environment.getActiveProfiles());
        RouteMappingProvider routeMappingProvider = new DynamicRouteMappingProvider(dynamicConfig.getMasterRouting());

        return new DynamicDataSource(dataSourcePackage, routeMappingProvider, fetcher, contextService);
    }
    
    @ConditionalOnMissingBean(JdbcTemplate.class)
    @Bean
    public JdbcTemplate jdbcTemplate(@Qualifier("master") DataSource datasource) {
        return new JdbcTemplate(datasource);
    }

    @ConditionalOnMissingBean(PlatformTransactionManager.class)
    @Bean(name = "springTransactionManager")
    public PlatformTransactionManager transactionManager(@Autowired DynamicDataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}
