package com.xforceplus.ultraman.adapter.local;

import com.xforceplus.ultraman.adapter.local.dto.OperationResult;
import com.xforceplus.ultraman.core.pojo.Hint;
import com.xforceplus.ultraman.core.pojo.OqsEngineReusltAction;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;

import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class QueryResultHandler extends OqsEngineReusltAction<OperationResult<Collection<IEntity>>, Collection<IEntity>> {

    private List<Pair<RexNode, String>> projects;

    public QueryResultHandler(List<Pair<RexNode, String>> projects) {
        this.projects = projects;
    }

    @Override
    public Optional<OperationResult<Collection<IEntity>>> success(Optional<Collection<IEntity>> value
            , Collection<Hint> hints) {
        if(value.isPresent()) {
            OperationResult<Collection<IEntity>> operationResult = new OperationResult<>();
            operationResult.setResult(value.get());
            return Optional.ofNullable(operationResult);
        }

        return Optional.empty();
    }

    @Override
    public Optional<OperationResult<Collection<IEntity>>> notExistMeta(Optional<String> message, Collection<Hint> hints) {
        return Optional.empty();
    }

//    private Collection<IEntity> simplify(boolean isSimplify,
//                                         Collection<IEntity> rawEntities,
//                                         List<QueryFieldsUp> projects) {
//        if (!isSimplify) {
//            return rawEntities;
//        } else {
//            //do simplify
//            Set<Long> idSet = projects.stream().map(QueryFieldsUp::getId).collect(Collectors.toSet());
//            return rawEntities.stream().map(x -> {
//                Collection<IValue> values = x.entityValue().values();
//                values.removeIf(item -> !idSet.contains(item.getField().id()));
//                return x;
//            }).collect(Collectors.toList());
//        }
//    }
}
