package com.xforceplus.ultraman.adapter.utils;

import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.helper.ConvertHelper;
import com.xforceplus.ultraman.metadata.values.EmptyTypedValue;
import com.xforceplus.ultraman.metadata.values.IValue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class CommonHelper {

    public static List<IValue> getValuesFromMap(EntityClassGroup entityClass, Map<String, Object> body) {
        return body.entrySet().stream().map(entry -> {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value != null) {
                Optional<IEntityField> fieldOp = entityClass.field(key);
                if (fieldOp.isPresent()) {
                    IEntityField field = fieldOp.get();
                    if (EmptyValue.isEmpty(value.toString())) {
                        return new EmptyTypedValue(field);
                    } else {
                        Optional<IValue> iValue = field.type().toTypedValue(field, ConvertHelper.convert(value));
                        if (iValue.isPresent()) {
                            return iValue.get();
                        }
                    }
                }

            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}
