package com.xforceplus.ultraman.adapter.core.impl;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.infra.metrics.MetricsDefine;
import io.micrometer.core.annotation.Timed;
import io.vavr.Tuple2;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;

import java.util.*;
import java.util.stream.Collectors;

/**
 * query for local connection
 */
public class LocalDataQueryProvider implements DataQueryProvider {

    private EntityQueryService queryService;

    private ContextService contextService;

    public LocalDataQueryProvider(EntityQueryService queryService, ContextService contextService) {
        this.queryService = queryService;
        this.contextService = contextService;
    }

    @Override
    public QueryProviderType type() {
        return QueryProviderType.MASTER;
    }


    @Timed(
            value = MetricsDefine.PROCESS_DELAY_LATENCY_SECONDS,
            percentiles = {0.5, 0.9, 0.99},
            extraTags = {"initiator", "master", "action", "master-query"}
    )
    @Override
    public List<Object> query(String app, IEntityClass entityClass, String profile
            , RelDataType type
            , List<RexNode> ops
            , List<Map.Entry<String, Tuple2<StructKind, Class>>> fields
            , List<Pair<RexNode, String>> projects
            , List<Map.Entry<String, RelFieldCollation.Direction>> sort
            , Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode relNode, DataContext dataContext) {

        contextService.getAll().put("invocation", "master");

        Map<String, Object> context = new HashMap<>();
        SelectConfig selectConfig = new SelectConfig();
        selectConfig.setRexNodes(ops);
        selectConfig.setFields(fields);
        selectConfig.setRelDataType(type);
        selectConfig.setSorts(sort);
        selectConfig.setOffset(Optional.ofNullable(offset).map(Long::intValue).orElse(0));
        selectConfig.setFetch(Optional.ofNullable(fetch).map(Long::intValue).orElse(20));
        selectConfig.setProjects(projects);
        selectConfig.setAggs(aggs);
        selectConfig.setGroupBy(groupBy);
        selectConfig.setHints(hints);
        selectConfig.setContext(context);
        selectConfig.setRawTree(relNode);
        selectConfig.setProfile(profile);
        selectConfig.setDataContext(dataContext);

        /**
         * TODO
         */
        OqsEngineResult<Collection<QueryResult>> result = queryService
                .selectByConditions(selectConfig, entityClass.ref());

        if (result.isSuccess()) {
            Optional<Collection<QueryResult>> value = result.getValue();
            if (value.isPresent()) {
                Collection<QueryResult> queryResults = value.get();
                //get current current
                Map<String, Object> current = contextService.getAll();
                current.putAll(context);
                // 暂时没用,先去掉,自动化流发序列化当前context时候会有问题
                // current.put("rawResult", queryResults);
                return queryResults.stream().map(x -> toArrayObject(x)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        } else {
            String message = result.getMessage();
            throw new RuntimeException(message);
        }
    }

    /**
     * to array
     *
     * @param queryResult
     * @return
     */
    private Object toArrayObject(QueryResult queryResult) {
        List<QueryResult.SelectItem> selectItems = queryResult.getSelectItems();
        Object[] record = selectItems.stream().map(x -> x.getValue()).toArray(Object[]::new);
        if (record.length == 1) {
            return record[0];
        }

        return record;
    }
}
