package com.xforceplus.ultraman.adapter.graphql;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.MutationProvider;
import com.xforceplus.ultraman.sdk.core.facade.result.*;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import com.xforceplus.ultraman.sdk.infra.exceptions.OperationNotSupportedException;
import io.vavr.control.Either;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

/**
 * TODO validator
 */
@Slf4j
public class LocalMutationProvider implements MutationProvider {

    private EntityFacade entityFacade;

    public LocalMutationProvider(EntityFacade entityFacade) {
        this.entityFacade = entityFacade;
    }

    @Override
    public boolean accept(IEntityClass entityClass) {
        return entityClass.getType() != 1;
    }

    /**
     * TODO
     *
     * @param entityClass
     * @param body
     * @param context
     * @return
     */
    @Override
    public String create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {

        Either<CreateOneResult, Long> join = entityFacade.create(entityClass, body, context)
                .toCompletableFuture()
                .join();
        if (join.isRight()) {
            return join.get().toString();
        } else {
            throw new RuntimeException(join.getLeft().getMessage());
        }
    }

    @Override
    public String batchCreate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        Either<CreateMultiResult, Integer> join = entityFacade.createMulti(entityClass, inputBodies, context)
                .toCompletableFuture()
                .join();
        if (join.isRight()) {
            return join.get().toString();
        } else {
            throw new RuntimeException(join.getLeft().getMessage());
        }
    }

    @Override
    public String update(IEntityClass entityClass, long id, Map<String, Object> body, Map<String, Object> context) {
        Either<UpdateOneResult, Integer> join = this.entityFacade.updateById(entityClass, id, body, context)
                .toCompletableFuture()
                .join();
        if (join.isRight()) {
            return join.get().toString();
        } else {
            throw new RuntimeException(join.getLeft().getMessage());
        }
    }

    @Override
    public String batchUpdate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        Either<UpdateMultiResult, Integer> join = this.entityFacade.updateMulti(entityClass, inputBodies, context)
                .toCompletableFuture()
                .join();
        if (join.isRight()) {
            return join.get().toString();
        } else {
            throw new RuntimeException(join.getLeft().getMessage());
        }
    }

    @Transactional
    @Override
    public String delete(IEntityClass entityClass, long id, Map<String, Object> context) {
        Either<DeleteOneResult, Integer> join = this.entityFacade.deleteOne(entityClass, id, context)
                .toCompletableFuture()
                .join();
        Object relations = context.get("relations");
        if(relations != null) {
            EntityClassGroup group = entityFacade.getEntityClassEngine().describe(entityClass, entityFacade.getFetcher().getProfile(context));
            String[] relationArray = relations.toString().split(",");
            Arrays.stream(relationArray).forEach(x -> {
                Optional<IEntityClass> relatedEntity = group.relatedEntityClass(x);
                if(relatedEntity.isPresent()) {
                    ExpQuery query = new ExpQuery()
                            .filters(ExpCondition.call(ExpOperator.EQUALS, ExpField.field(x.concat(".id")), ExpValue.from(id)))
                            .range(1, 10000);
                    try {
                        entityFacade.deleteByCondition(relatedEntity.get(), query, context).toCompletableFuture().get();
                    } catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        
        
        if (join.isRight()) {
            return join.get().toString();
        } else {
            throw new RuntimeException(join.getLeft().getMessage());
        }
    }

    @Override
    public String batchDelete(IEntityClass entityClass, List<Long> ids, Map<String, Object> context) {
        Either<DeleteMultiResult, Integer> join = this.entityFacade.deleteMulti(entityClass, ids, context)
                .toCompletableFuture()
                .join();
        if (join.isRight()) {
            return join.get().toString();
        } else {
            throw new RuntimeException(join.getLeft().getMessage());
        }
    }

    @Override
    public String custom(IEntityClass entityClass, String actionName, Map<String, Object> argument, Map<String, Object> all) {
        throw new OperationNotSupportedException(OperationNotSupportedException.getMsg("custom"));
    }
}
