package com.xforceplus.ultraman.adapter.graphql;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import com.xforceplus.ultraman.sdk.core.facade.option.QueryOption;
import com.xforceplus.ultraman.sdk.core.facade.result.QueryResult;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import io.vavr.control.Either;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class LocalQueryProvider implements QueryProvider {

    private final EntityFacade entityFacade;

    private final ContextService contextService;

    public LocalQueryProvider(EntityFacade entityFacade, ContextService contextService) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
    }

    @Override
    public boolean accept(IEntityClass entityClass) {
        return entityClass.getType() != 1;
    }

    @Override
    public CompletableFuture<List<Object>> batchQuery(IEntityClass entityClass, List<String> ids) {
        ExpRel batchSearch = new ExpQuery().filters(ExpCondition.call(ExpOperator.IN, ExpField.ID, ExpValue.from(ids))).range(1, ids.size());
        CompletableFuture<Either<QueryResult, DataCollection<Record>>> eitherCompletableFuture = entityFacade
                .query(entityClass
                        , batchSearch
                        , Optional.ofNullable(contextService).map(ContextService::getAll)
                                .orElse(Collections.emptyMap())).toCompletableFuture();
        CompletableFuture<List<Object>> futureResult = eitherCompletableFuture.thenApply(either -> either.map(x -> x.getRows().stream().map(record -> {
                            Map<String, Object> retMap = record.toMap(null);
                            //recreateMap to normalize
                            retMap = normalize(retMap);
                            retMap.put("_entityClassId", Optional.ofNullable(record.getTypeId()).orElse(entityClass.id()));
                            return (Object) retMap;
                        }).collect(Collectors.toList()))
                        .getOrElseThrow(x -> new RuntimeException(x.getMessage())))
                .thenApply(list -> {
                    List<Object> newList = new ArrayList<>();
                    for (String id : ids) {
                        //insert new
                        //TODO id is string now
                        Object idRelatedObject = list.stream().filter(x -> {
                                    Object targetId = ((Map<String, Object>) x).get("id");
                                    if(targetId != null) {
                                        return x instanceof Map && id.equals(targetId.toString());
                                    }
                                    return false;
                                } )
                                .findFirst().orElse(null);
                        newList.add(idRelatedObject);
                    }
                    return newList;
                });
        return futureResult;
    }

    @Override
    public Object query(IEntityClass entityClass, ExpRel expRel, QueryOption... queryOptions) {
        Either<QueryResult, DataCollection<Record>> result = entityFacade
                .query(entityClass
                        , expRel
                        , Optional.ofNullable(contextService).map(ContextService::getAll)
                                .orElse(Collections.emptyMap())).toCompletableFuture()
                .join();

        List<Map<String, Object>> retListMap;
        retListMap = result.map(x -> x.getRows().stream().map(record -> {
            Map<String, Object> retMap = record.toMap(null);
            //recreateMap to normalize
            retMap = normalize(retMap);
            //TODO make this into one class
            retMap.put("_entityClassId", Optional.ofNullable(record.getTypeId()).orElse(entityClass.id()));
            return retMap;
        }).collect(Collectors.toList())).getOrElseThrow(x -> new RuntimeException(x.getMessage()));

        if (result.isRight()) {
            if (!hasOption(queryOptions, QueryOption.UNBOX)) {
                Map<String, Object> retLastMap = new HashMap<>();
                retLastMap.put("row", retListMap);
                retLastMap.put("totalCount", result.get().getRowNum());
                return retLastMap;
            } else {
                return retListMap;
            }
        } else {
            throw new RuntimeException(result.getLeft().getMessage());
        }
    }
}
