package com.xforceplus.ultraman.adapter.query.strategy;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import io.vavr.Tuple2;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultSelectStrategy implements QueryProviderSelectStrategy {
    @Override
    public String name() {
        return "default-master";
    }

    @Override
    public Map<DataQueryProvider, Double> score(String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext, List<DataQueryProvider> dataQueryProviderList) {
        Map<DataQueryProvider, Double> scored = new HashMap<>();
        dataQueryProviderList.forEach(x -> {
            if(x.type() == DataQueryProvider.QueryProviderType.MASTER) {
                scored.put(x, 0.5);
            } else {
                scored.put(x, 0d);
            }
        });
        return scored;
    }
}
