package com.xforceplus.ultraman.adapter.utils;

import com.xforceplus.ultraman.metadata.domain.func.FuncValue;
import com.xforceplus.ultraman.metadata.domain.func.OnDuplicateFuncValue;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.helper.ConvertHelper;
import com.xforceplus.ultraman.metadata.values.EmptyTypedValue;
import com.xforceplus.ultraman.metadata.values.ExpressionValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.metadata.values.OnDuplicateValue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class CommonHelper {

    public static List<IValue> getValuesFromMap(EntityClassGroup entityClass, Map<String, Object> body) {
        return body.entrySet().stream().map(entry -> {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value != null) {
                Optional<IEntityField> fieldOp = entityClass.field(key);
                if (fieldOp.isPresent()) {
                    IEntityField field = fieldOp.get();
                    if (EmptyValue.isEmpty(value.toString())) {
                        return new EmptyTypedValue(field);
                    } else if (value instanceof FuncValue) {
                        return new ExpressionValue(field, (FuncValue) value);
                    } else if (value instanceof OnDuplicateFuncValue) {
                        Optional<IValue> iValueOp = field.type()
                                .toTypedValue(field, ConvertHelper.convert(((OnDuplicateFuncValue) value).getRawObject()));
                        if(iValueOp.isPresent()) {
                            IValue target = null;
                            if(((OnDuplicateFuncValue) value).getOnDuplicateObject() instanceof FuncValue) {
                                target = new ExpressionValue(field, (FuncValue) ((OnDuplicateFuncValue) value).getOnDuplicateObject());
                            } else {
                                Object rawObject = ((OnDuplicateFuncValue) value).getOnDuplicateObject();
                                Optional<IValue> typedValueOp = field.type()
                                        .toTypedValue(field, ConvertHelper.convert(rawObject));
                                if(typedValueOp.isPresent()) {
                                    target = typedValueOp.get();
                                }
                            }
                            return new OnDuplicateValue(field, iValueOp.get(), target); 
                        }
                      
                    } else {
                        Optional<IValue> iValue = field.type().toTypedValue(field, ConvertHelper.convert(value));
                        if (iValue.isPresent()) {
                            return iValue.get();
                        }
                    }
                }

            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}
