/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.core.impl.AdaptiveDataQueryProvider;
import com.xforceplus.ultraman.adapter.core.impl.LocalDataQueryProvider;
import com.xforceplus.ultraman.adapter.core.impl.LocalEntityFacadeImpl;
import com.xforceplus.ultraman.adapter.graphql.LocalMutationProvider;
import com.xforceplus.ultraman.adapter.graphql.LocalQueryProvider;
import com.xforceplus.ultraman.adapter.query.strategy.DefaultQueryStrategy;
import com.xforceplus.ultraman.adapter.query.strategy.DefaultSelectStrategy;
import com.xforceplus.ultraman.adapter.query.strategy.MasterStickQueryStrategy;
import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.impl.EntityQueryServiceImpl;
import com.xforceplus.ultraman.core.impl.EntityWriteServiceImpl;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.SQLMasterStorage;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryStrategy;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.MutationProvider;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.base.id.IdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.TimeRandomNodeIdGenerator;
import com.xforceplus.ultraman.sdk.invocation.invoke.config.InvocationConfig;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfigureAfter(name={"com.xforceplus.ultraman.starter.autoconfigure.SdkAutoConfiguration"})
@ConditionalOnProperty(value={"xplat.oqsengine.sdk.local.enabled"}, matchIfMissing=true)
@DependsOn(value={"agentApi"})
public class LocalOqsengineAutoConfiguration {
    @Bean
    @DependsOn(value={"master"})
    public MasterStorage masterStorage(@Qualifier(value="master") DataSource ds, ObjectMapper mapper, EntityClassEngine engine, ExecutionConfig executionConfig, PlatformTransactionManager manager, CdcConfig cdcConfig, DictService dictService, ContextService contextService, @Value(value="${xplat.oqsengine.sdk.schema.schedule.init:300}") long initTime, @Value(value="${xplat.oqsengine.sdk.schema.schedule.period:60}") long periodTime) {
        return new SQLMasterStorage(manager, ds, mapper, engine, dictService, cdcConfig, executionConfig, (long)executionConfig.getQueryTimeout(), periodTime, initTime, contextService);
    }

    @Bean
    public EntityWriteService entityWriteService(MasterStorage masterStorage, EntityClassEngine engine, CdcConfig cdcConfig) {
        return new EntityWriteServiceImpl(masterStorage, engine, cdcConfig.getRecordUser().booleanValue());
    }

    @Bean
    public EntityQueryService entityQueryService(MasterStorage masterStorage, EntityClassEngine engine) {
        return new EntityQueryServiceImpl(masterStorage, engine);
    }

    @ConditionalOnMissingBean(value={NodeIdGenerator.class})
    @Bean
    public NodeIdGenerator nodeIdGenerator() {
        return new TimeRandomNodeIdGenerator();
    }

    @ConditionalOnMissingBean(value={IdGenerator.class})
    @Bean
    public IdGenerator snowFlakeIdGenerator(NodeIdGenerator nodeIdGenerator, AuthConfig authConfig) {
        return new SnowflakeLongIdGenerator(nodeIdGenerator);
    }

    @Bean
    public MutationProvider localMutationProvider(EntityFacade entityFacade) {
        return new LocalMutationProvider(entityFacade);
    }

    @Lazy
    @Bean
    public EntityFacade entityFacade() {
        return new LocalEntityFacadeImpl();
    }

    @Bean
    public DataQueryProvider dataQueryProvider(EntityQueryService entityQueryService, ContextService contextService) {
        return new LocalDataQueryProvider(entityQueryService, contextService);
    }

    @Lazy
    @Bean
    public QueryProvider localQueryProvider(EntityFacade entityFacade, ContextService contextService) {
        return new LocalQueryProvider(entityFacade, contextService);
    }

    @Primary
    @Bean
    public DataQueryProvider adaptiveDataQueryProvider(List<DataQueryProvider> queryProviderList, List<QueryProviderSelectStrategy> queryProviderStrategies, List<QueryStrategy> queryStrategies) {
        return new AdaptiveDataQueryProvider(queryProviderList, queryProviderStrategies, queryStrategies);
    }

    @Bean
    public QueryProviderSelectStrategy defaultMasterStrategy() {
        return new DefaultSelectStrategy();
    }

    @Bean
    public QueryProviderSelectStrategy masterStickStrategy(EntityClassEngine engine, ProfileFetcher fetcher, ContextService contextService, InvocationConfig invocationConfig) {
        return new MasterStickQueryStrategy(engine, fetcher, contextService, invocationConfig);
    }

    @Bean
    public QueryStrategy defaultStrategy() {
        return new DefaultQueryStrategy();
    }
}

