/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.core.impl;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryStrategy;
import com.xforceplus.ultraman.sdk.infra.exceptions.InvalidInputsException;
import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import io.micrometer.core.annotation.Timed;
import io.vavr.Tuple2;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveDataQueryProvider
implements DataQueryProvider {
    private static final Logger log = LoggerFactory.getLogger(AdaptiveDataQueryProvider.class);
    private List<DataQueryProvider> dataQueryProviders;
    private List<QueryProviderSelectStrategy> queryProviderStrategies;
    private List<QueryStrategy> queryStrategies;

    public AdaptiveDataQueryProvider(List<DataQueryProvider> dataQueryProviders, List<QueryProviderSelectStrategy> queryProviderStrategies, List<QueryStrategy> queryStrategies) {
        this.dataQueryProviders = dataQueryProviders;
        this.queryProviderStrategies = queryProviderStrategies;
        this.queryStrategies = queryStrategies;
    }

    public DataQueryProvider.QueryProviderType type() {
        return DataQueryProvider.QueryProviderType.PROXY;
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "system", "action", "adaptive-query"})
    public List<Object> query(String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext) {
        Map dataQueryProviderDoubleMap;
        Optional<Map.Entry> max;
        Optional<Map> reduce;
        if (this.dataQueryProviders.size() == 1) {
            return this.doWithStrategy(this.dataQueryProviders.get(0), app, entityClass, profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext);
        }
        if (!hints.isEmpty()) {
            Optional<DataQueryProvider> indexOp;
            Optional<DataQueryProvider> masterOp;
            Optional<RelHint> fallBackHint = hints.stream().filter(x -> x.hintName.equalsIgnoreCase(InvocationManager.InvocationType.FALLBACK.name().toLowerCase())).findAny();
            if (fallBackHint.isPresent() && (masterOp = this.dataQueryProviders.stream().filter(x -> x.type() == DataQueryProvider.QueryProviderType.MASTER).findAny()).isPresent()) {
                log.debug("Call with Fallback code:{}, profile:{}", (Object)entityClass.code(), (Object)profile);
                return this.doWithStrategy(masterOp.get(), app, entityClass, profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext);
            }
            Optional<RelHint> indexQueryHint = hints.stream().filter(x -> x.hintName.equalsIgnoreCase("index_search")).findAny();
            if (indexQueryHint.isPresent() && (indexOp = this.dataQueryProviders.stream().filter(x -> x.type() == DataQueryProvider.QueryProviderType.INDEX).findAny()).isPresent()) {
                log.debug("Call with Index code:{}, profile:{}", (Object)entityClass.code(), (Object)profile);
                return this.doWithStrategy(indexOp.get(), app, entityClass, profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext);
            }
        }
        if ((reduce = this.queryProviderStrategies.stream().sorted().map(x -> x.score(app, entityClass, profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext, this.dataQueryProviders)).reduce((a, b) -> {
            HashMap dataQueryProviderDoubleHashMap = new HashMap(a);
            b.forEach((k, v) -> dataQueryProviderDoubleHashMap.merge(k, v, Double::sum));
            return dataQueryProviderDoubleHashMap;
        })).isPresent() && (max = (dataQueryProviderDoubleMap = reduce.get()).entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue))).isPresent()) {
            return this.doWithStrategy((DataQueryProvider)max.get().getKey(), app, entityClass, profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext);
        }
        throw new InvalidInputsException(InvalidInputsException.getMsg((String[])new String[]{"No Suitable Query Provider"}));
    }

    public List<Object> doWithStrategy(DataQueryProvider dataQueryProvider, String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext) {
        this.queryStrategies.stream().sorted().filter(x -> x.accept(dataQueryProvider.type())).forEach(x -> x.doWithInput(dataQueryProvider, app, entityClass, profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext));
        return dataQueryProvider.query(app, entityClass, profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext);
    }
}

