/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.core.impl;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.QueryResult;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import io.micrometer.core.annotation.Timed;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;

public class LocalDataQueryProvider
implements DataQueryProvider {
    private EntityQueryService queryService;
    private ContextService contextService;

    public LocalDataQueryProvider(EntityQueryService queryService, ContextService contextService) {
        this.queryService = queryService;
        this.contextService = contextService;
    }

    public DataQueryProvider.QueryProviderType type() {
        return DataQueryProvider.QueryProviderType.MASTER;
    }

    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"initiator", "master", "action", "master-query"})
    public List<Object> query(String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode relNode, DataContext dataContext) {
        this.contextService.getAll().put("invocation", "master");
        HashMap context = new HashMap();
        SelectConfig selectConfig = new SelectConfig();
        selectConfig.setRexNodes(ops);
        selectConfig.setFields(fields);
        selectConfig.setRelDataType(type);
        selectConfig.setSorts(sort);
        selectConfig.setOffset(Optional.ofNullable(offset).map(Long::intValue).orElse(0).intValue());
        selectConfig.setFetch(Optional.ofNullable(fetch).map(Long::intValue).orElse(20).intValue());
        selectConfig.setProjects(projects);
        selectConfig.setAggs(aggs);
        selectConfig.setGroupBy(groupBy);
        selectConfig.setHints(hints);
        selectConfig.setContext(context);
        selectConfig.setRawTree(relNode);
        selectConfig.setProfile(profile);
        selectConfig.setDataContext(dataContext);
        OqsEngineResult result = this.queryService.selectByConditions(selectConfig, entityClass.ref());
        if (result.isSuccess()) {
            Optional value = result.getValue();
            if (value.isPresent()) {
                Collection queryResults = (Collection)value.get();
                Map current = this.contextService.getAll();
                current.putAll(context);
                return queryResults.stream().map(x -> this.toArrayObject((QueryResult)x)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        String message = result.getMessage();
        throw new RuntimeException(message);
    }

    private Object toArrayObject(QueryResult queryResult) {
        List selectItems = queryResult.getSelectItems();
        A[] record = selectItems.stream().map(x -> x.getValue()).toArray(Object[]::new);
        if (record.length == 1) {
            return record[0];
        }
        return record;
    }
}

