/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.core.impl;

import com.google.common.annotations.VisibleForTesting;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.utils.CommonHelper;
import com.xforceplus.ultraman.billing.client.aspect.BillingScope;
import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.calculation.AbstractCalculation;
import com.xforceplus.ultraman.metadata.entity.calculation.Lookup;
import com.xforceplus.ultraman.metadata.entity.impl.Entity;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.QueryOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.QueryResult;
import com.xforceplus.ultraman.sdk.core.facade.result.ResultStatus;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateOneResult;
import com.xforceplus.ultraman.sdk.core.pipeline.OperationType;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.pojo.UpdateConfig;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpBi;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFunc;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRange;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpSort;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpVisitor;
import com.xforceplus.ultraman.sdk.infra.base.id.IdGenerator;
import com.xforceplus.ultraman.sdk.infra.exceptions.RecordMissingException;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import com.xforceplus.ultraman.sdk.infra.query.LazyFetchIterator;
import com.xforceplus.ultraman.sdk.infra.utils.CompletableFutureUtils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.control.Either;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.calcite.tools.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;

@BillingScope(value="oqssdk")
public class LocalEntityFacadeImpl
implements EntityFacade {
    private static final Logger log = LoggerFactory.getLogger(LocalEntityFacadeImpl.class);
    private static final int QUERY_STEP = 1000;
    @Qualifier(value="CalciteDS")
    @Lazy
    @Autowired
    private DataSource dataSource;
    @Lazy
    @Autowired
    private FrameworkConfig config;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private ContextService contextService;
    @Autowired
    private EntityWriteService writeService;
    @Autowired
    private IdGenerator<Long> idGenerator;
    @Autowired
    private TransformerPipeline transformerPipeline;
    private final Counter queryCountTotal = Metrics.counter((String)"oqs.operation.count.total", (String[])new String[]{"action", "query"});
    private final Counter insertCountTotal = Metrics.counter((String)"oqs.operation.count.total", (String[])new String[]{"action", "build"});
    private final Counter insertMultiCountTotal = Metrics.counter((String)"oqs.operation.count.total", (String[])new String[]{"action", "buildMulti"});
    private final Counter replaceOneCountTotal = Metrics.counter((String)"oqs.operation.count.total", (String[])new String[]{"action", "replaceOne"});
    private final Counter replaceMultiCountTotal = Metrics.counter((String)"oqs.operation.count.total", (String[])new String[]{"action", "replaceMulti"});
    private final Counter deleteOneCountTotal = Metrics.counter((String)"oqs.operation.count.total", (String[])new String[]{"action", "deleteOne"});
    private final Counter deleteMultiCountTotal = Metrics.counter((String)"oqs.operation.count.total", (String[])new String[]{"action", "deleteMulti"});
    @Autowired
    private ExecutionConfig executeConfig;
    @Autowired(required=false)
    private AuthBuilder authBuilder;
    private ForkJoinPool forkJoinPool = new ForkJoinPool(50);

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConfig(FrameworkConfig config) {
        this.config = config;
    }

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    public void setWriteService(EntityWriteService writeService) {
        this.writeService = writeService;
    }

    public void setIdGenerator(IdGenerator<Long> idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setTransformerPipeline(TransformerPipeline transformerPipeline) {
        this.transformerPipeline = transformerPipeline;
    }

    public void setExecuteConfig(ExecutionConfig executeConfig) {
        this.executeConfig = executeConfig;
    }

    public void setAuthBuilder(AuthBuilder authBuilder) {
        this.authBuilder = authBuilder;
    }

    public Optional<IEntityClass> load(String boId, String profile) {
        return this.engine.load(boId, profile);
    }

    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return this.engine.load(boId, profile, version);
    }

    public Optional<IEntityClass> loadByCode(String bocode, String profile) {
        return this.engine.loadByCode(bocode, profile);
    }

    public Optional<IEntityClass> loadByCode(String bocode, String profile, String version) {
        return this.engine.loadByCode(bocode, profile, version);
    }

    @VisibleForTesting
    private IEntity toIEntity(IEntityClass entityClass, long id) {
        return Entity.Builder.anEntity().withEntityClassRef(entityClass.ref()).withId(id).build();
    }

    @VisibleForTesting
    private IEntity toIEntity(EntityClassGroup entityClass, Map<String, Object> body) {
        long id = Optional.ofNullable(body.get("id")).map(Object::toString).map(Long::parseLong).orElse(0L);
        long operationTime = System.currentTimeMillis();
        Object o = Optional.ofNullable(body.get("update_time")).orElse(body.get("create_time"));
        if (o != null) {
            try {
                operationTime = Long.parseLong(o.toString());
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
        return Entity.Builder.anEntity().withEntityClassRef(entityClass.getEntityClass().ref()).withId(id).withValues(CommonHelper.getValuesFromMap(entityClass, body)).withTime(operationTime).build();
    }

    public Map<IEntityClass, Map<String, Object>> split(EntityClassGroup group, Map<String, Object> body, Map<String, Object> context, OperationType operationType) {
        HashMap<IEntityClass, Map<String, Object>> mapping = new HashMap<IEntityClass, Map<String, Object>>();
        body.forEach((k, v) -> {
            Optional column = group.column(k);
            if (column.isPresent()) {
                AbstractCalculation calculation = ((ColumnField)column.get()).getOriginObject().config().getCalculation();
                if (calculation instanceof Lookup) {
                    if (operationType == OperationType.UPDATE || operationType == OperationType.REPLACE) {
                        long classId = ((Lookup)calculation).getClassId();
                        long fieldId = ((Lookup)calculation).getFieldId();
                        long refId = ((Lookup)calculation).getRelationId();
                        Optional relatedEntityClass = group.classEngine().load(Long.toString(classId), group.realProfile());
                        if (relatedEntityClass.isPresent()) {
                            String name;
                            Object refIdValue;
                            IRelation iRelation;
                            IEntityClass entityClass = (IEntityClass)relatedEntityClass.get();
                            Optional field = entityClass.field(fieldId);
                            Optional relation = group.relation(refId);
                            if (relation.isPresent() && (iRelation = (IRelation)relation.get()).getRelationType().equalsIgnoreCase("TO_ONE") && (refIdValue = body.get((name = iRelation.getName()).concat(".id"))) != null) {
                                if (field.isPresent()) {
                                    mapping.compute(entityClass, (a, b) -> {
                                        if (b == null) {
                                            b = new HashMap<String, Object>();
                                        }
                                        b.put(((IEntityField)field.get()).name(), v);
                                        return b;
                                    });
                                }
                                mapping.compute(entityClass, (a, b) -> {
                                    if (b.get("id") == null) {
                                        b.put("id", refIdValue);
                                    }
                                    return b;
                                });
                            }
                        }
                    }
                } else {
                    mapping.compute(group.getEntityClass(), (a, b) -> {
                        if (b == null) {
                            b = new HashMap<String, Object>();
                        }
                        b.put(k, v);
                        return b;
                    });
                }
            }
        });
        return mapping;
    }

    private CompletionStage<Either<CreateOneResult, Long>> createInner(EntityClassGroup group, Map<String, Object> body, Map<String, Object> context) {
        try {
            OqsEngineResult build;
            List pipelinedBody = this.transformerPipeline.valueSideHandleValue(group, body, OperationType.CREATE);
            HashMap<String, Object> newBody = new HashMap<String, Object>();
            pipelinedBody.forEach(x -> newBody.put(((IEntityField)x._1).name(), x._2));
            IEntity entity = this.toIEntity(group, newBody);
            if (entity.id() == 0L) {
                Long next = (Long)this.idGenerator.next();
                entity.resetId(next.longValue());
                body.put("id", next);
            }
            if ((build = this.writeService.build(entity, context)).isSuccess()) {
                this.insertCountTotal.increment();
                Long retLong = (Long)build.getValue().get();
                return CompletableFuture.completedFuture(Either.right((Object)retLong));
            }
            return CompletableFuture.completedFuture(Either.left((Object)CreateOneResult.failFrom((ResultStatus.OriginStatus)build.getResultStatus(), (String)build.getMessage())));
        }
        catch (Throwable ex) {
            return this.exceptional(ex);
        }
    }

    @Transactional
    public CompletionStage<Either<CreateOneResult, Long>> create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {
        Object o;
        boolean setProfile = false;
        String profile = this.fetcher.getProfile(context);
        if (StringUtils.isEmpty((String)profile) && (o = body.get("tenant_code")) != null) {
            profile = o.toString();
            setProfile = true;
            context.put("profile", profile);
            this.contextService.getAll().put("tenant_code", profile);
        }
        EntityClassGroup group = this.engine.describe(entityClass, profile);
        if (entityClass.getType() == 2) {
            Map<IEntityClass, Map<String, Object>> split = this.split(group, body, context, OperationType.CREATE);
            if (split.isEmpty()) {
                return this.createInner(group, body, context);
            }
            List collect = split.entrySet().stream().map(entry -> {
                IEntityClass key = (IEntityClass)entry.getKey();
                EntityClassGroup targetGroup = this.getEntityClassEngine().describe(key, group.realProfile());
                Map value = (Map)entry.getValue();
                return this.createInner(targetGroup, value, context);
            }).map(x -> (CompletableFuture)x).collect(Collectors.toList());
            if (setProfile) {
                context.remove("profile");
                this.contextService.getAll().remove("tenant_code");
            }
            return CompletableFutureUtils.sequence(collect).thenApply(x -> (Either)x.get(0));
        }
        CompletionStage<Either<CreateOneResult, Long>> inner = this.createInner(group, body, context);
        if (setProfile) {
            context.remove("profile");
            this.contextService.getAll().remove("tenant_code");
        }
        return inner;
    }

    private CompletionStage<Either<CreateMultiResult, Integer>> createMultiInner(IEntityClass entityClass, List<Map<String, Object>> body, String profile, boolean isSetProfile, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, profile);
        IEntity[] entities = (IEntity[])body.stream().map(x -> {
            List pipelinedBody = this.transformerPipeline.valueSideHandleValue(group, x, OperationType.CREATE);
            HashMap<String, Object> newBody = new HashMap<String, Object>();
            pipelinedBody.forEach(piped -> newBody.put(((IEntityField)piped._1).name(), piped._2));
            IEntity iEntity = this.toIEntity(group, newBody);
            return iEntity;
        }).peek(x -> {
            if (x.id() == 0L) {
                x.resetId(((Long)this.idGenerator.next()).longValue());
            }
        }).toArray(IEntity[]::new);
        context.put("profile", profile);
        this.contextService.getAll().put("tenant_code", profile);
        OqsEngineResult build = this.writeService.build(entities, context);
        if (isSetProfile) {
            context.remove("profile");
            this.contextService.getAll().remove("tenant_code");
        }
        if (build.isSuccess()) {
            Long retLong = build.getValue().orElse(0L);
            this.insertMultiCountTotal.increment((double)entities.length);
            return CompletableFuture.completedFuture(Either.right((Object)retLong.intValue()));
        }
        return CompletableFuture.completedFuture(Either.left((Object)CreateMultiResult.from((Throwable)new RuntimeException(build.getMessage()))));
    }

    public CompletionStage<Either<CreateMultiResult, Integer>> createMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        try {
            String profile = this.fetcher.getProfile(context);
            if (!StringUtils.isEmpty((String)profile)) {
                return this.createMultiInner(entityClass, body, profile, false, context);
            }
            Map<String, List<Map>> tenantCodeMapping = body.stream().collect(Collectors.groupingBy(x -> Optional.ofNullable(x.get("tenant_code")).map(Object::toString).orElse("")));
            List futures = tenantCodeMapping.entrySet().stream().map(entry -> this.createMultiInner(entityClass, (List)entry.getValue(), (String)entry.getKey(), true, context)).map(x -> (CompletableFuture)x).collect(Collectors.toList());
            return CompletableFutureUtils.sequence(futures).thenApply(x -> (Either)x.get(0));
        }
        catch (Throwable ex) {
            return this.exceptional(ex);
        }
    }

    private <T> CompletionStage<T> exceptional(Throwable ex) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(ex);
        return result;
    }

    public CompletionStage<Either<DeleteOneResult, Integer>> deleteOne(IEntityClass entityClass, Long id, Map<String, Object> context) {
        try {
            String profile = this.fetcher.getProfile(context);
            EntityClassGroup group = this.engine.describe(entityClass, profile);
            OqsEngineResult build = null;
            if (this.authBuilder != null && this.executeConfig.getUsePermission().booleanValue()) {
                ExpQuery idRelatedQuery = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.ID, (List)ExpValue.from((Object)id))).range(Integer.valueOf(1), Integer.valueOf(1));
                ExpContext expContext = new ExpContext();
                expContext.withContext(context);
                expContext.setSchema(group);
                Map<Long, Set<String>> mapping = this.collectEntityClassIdMapping((ExpRel)idRelatedQuery, group);
                ExpRel permissionExpRel = this.authBuilder.getPermissionTreeCondition(mapping, expContext, profile, OperationType.DELETE);
                if (permissionExpRel != null) {
                    idRelatedQuery = idRelatedQuery.mergeAnd(permissionExpRel);
                }
                build = this.writeService.deleteByCondition(entityClass, (ExpRel)idRelatedQuery, context);
            } else {
                build = this.writeService.delete(this.toIEntity(entityClass, id), context);
            }
            if (build.isSuccess()) {
                this.deleteOneCountTotal.increment();
                return CompletableFuture.completedFuture(Either.right((Object)1));
            }
            return CompletableFuture.completedFuture(Either.left((Object)DeleteOneResult.from((Throwable)new RuntimeException(build.getMessage()))));
        }
        catch (Throwable ex) {
            return this.exceptional(ex);
        }
    }

    public CompletionStage<Either<DeleteMultiResult, Integer>> deleteMulti(IEntityClass entityClass, List<Long> ids, Map<String, Object> context) {
        try {
            IEntity[] entities = (IEntity[])ids.stream().map(x -> this.toIEntity(entityClass, (long)x)).toArray(IEntity[]::new);
            String profile = entityClass.realProfile();
            EntityClassGroup group = this.engine.describe(entityClass, profile);
            OqsEngineResult build = null;
            if (this.authBuilder != null && this.executeConfig.getUsePermission().booleanValue()) {
                ExpQuery idRelatedQuery = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.IN, (ExpNode)ExpField.ID, (List)ExpValue.from(ids))).range(Integer.valueOf(1), Integer.valueOf(10000));
                ExpContext expContext = new ExpContext();
                expContext.withContext(context);
                expContext.setSchema(group);
                Map<Long, Set<String>> mapping = this.collectEntityClassIdMapping((ExpRel)idRelatedQuery, group);
                ExpRel permissionExpRel = this.authBuilder.getPermissionTreeCondition(mapping, expContext, profile, OperationType.DELETE);
                if (permissionExpRel != null) {
                    idRelatedQuery = idRelatedQuery.mergeAnd(permissionExpRel);
                }
                build = this.writeService.deleteByCondition(entityClass, (ExpRel)idRelatedQuery, context);
            } else {
                build = this.writeService.delete(entities, context);
            }
            if (build.isSuccess()) {
                Long retLong = (Long)build.getValue().get();
                this.deleteMultiCountTotal.increment((double)retLong.longValue());
                return CompletableFuture.completedFuture(Either.right((Object)retLong.intValue()));
            }
            return CompletableFuture.completedFuture(Either.left((Object)DeleteMultiResult.from((Throwable)new RuntimeException(build.getMessage()))));
        }
        catch (Throwable ex) {
            return this.exceptional(ex);
        }
    }

    public static Map<IEntityClass, List<Map<String, Object>>> convertListMapToMapList(List<Map<IEntityClass, Map<String, Object>>> listMap) {
        return listMap.stream().flatMap(map -> map.entrySet().stream()).collect(HashMap::new, (resultMap, entry) -> resultMap.computeIfAbsent(entry.getKey(), key -> new ArrayList()).add(entry.getValue()), HashMap::putAll);
    }

    @Transactional
    public CompletionStage<Either<UpdateMultiResult, Integer>> updateMulti(IEntityClass entityClass, List<Map<String, Object>> bodies, Map<String, Object> context) {
        String profile = entityClass.realProfile();
        EntityClassGroup group = this.engine.describe(entityClass, profile);
        List<Map<IEntityClass, Map<String, Object>>> split = bodies.stream().map(body -> this.split(group, (Map<String, Object>)body, context, OperationType.UPDATE)).collect(Collectors.toList());
        Map<IEntityClass, List<Map<String, Object>>> groupedMapping = LocalEntityFacadeImpl.convertListMapToMapList(split);
        if (groupedMapping.isEmpty()) {
            return this.updateMultiInner(group, bodies, null, context, OperationType.UPDATE);
        }
        List collect = groupedMapping.entrySet().stream().map(entry -> {
            IEntityClass key = (IEntityClass)entry.getKey();
            EntityClassGroup targetGroup = this.getEntityClassEngine().describe(key, group.realProfile());
            List bodyOne = (List)entry.getValue();
            return this.updateMultiInner(targetGroup, bodyOne, null, context, OperationType.UPDATE);
        }).map(x -> (CompletableFuture)x).collect(Collectors.toList());
        return CompletableFutureUtils.sequence(collect).thenApply(x -> (Either)x.get(0));
    }

    public CompletionStage<Either<UpdateMultiResult, Integer>> replaceMulti(IEntityClass entityClass, List<Map<String, Object>> bodies, Map<String, Object> context) {
        String profile = entityClass.realProfile();
        EntityClassGroup group = this.engine.describe(entityClass, profile);
        List<Map<IEntityClass, Map<String, Object>>> split = bodies.stream().map(body -> this.split(group, (Map<String, Object>)body, context, OperationType.REPLACE)).collect(Collectors.toList());
        Map<IEntityClass, List<Map<String, Object>>> groupedMapping = LocalEntityFacadeImpl.convertListMapToMapList(split);
        if (groupedMapping.isEmpty()) {
            return this.updateMultiInner(group, bodies, null, context, OperationType.REPLACE);
        }
        List collect = groupedMapping.entrySet().stream().map(entry -> {
            IEntityClass key = (IEntityClass)entry.getKey();
            EntityClassGroup targetGroup = this.getEntityClassEngine().describe(key, group.realProfile());
            List bodyOne = (List)entry.getValue();
            return this.updateMultiInner(targetGroup, bodyOne, null, context, OperationType.REPLACE);
        }).map(x -> (CompletableFuture)x).collect(Collectors.toList());
        return CompletableFutureUtils.sequence(collect).thenApply(x -> (Either)x.get(0));
    }

    public CompletionStage<Either<UpdateMultiResult, Integer>> updateMultiWithConfig(IEntityClass entityClass, List<Map<String, Object>> bodies, UpdateConfig updateConfig, Map<String, Object> context) {
        String profile = entityClass.realProfile();
        EntityClassGroup group = this.engine.describe(entityClass, profile);
        List<Map<IEntityClass, Map<String, Object>>> split = bodies.stream().map(body -> this.split(group, (Map<String, Object>)body, context, OperationType.UPDATE)).collect(Collectors.toList());
        Map<IEntityClass, List<Map<String, Object>>> groupedMapping = LocalEntityFacadeImpl.convertListMapToMapList(split);
        if (groupedMapping.isEmpty()) {
            return this.updateMultiInner(group, bodies, updateConfig, context, OperationType.UPDATE);
        }
        List collect = groupedMapping.entrySet().stream().map(entry -> {
            IEntityClass key = (IEntityClass)entry.getKey();
            EntityClassGroup targetGroup = this.getEntityClassEngine().describe(key, group.realProfile());
            List bodyOne = (List)entry.getValue();
            if (targetGroup.getEntityClass().id() == group.getEntityClass().id()) {
                return this.updateMultiInner(targetGroup, bodyOne, updateConfig, context, OperationType.UPDATE);
            }
            return this.updateMultiInner(targetGroup, bodyOne, null, context, OperationType.UPDATE);
        }).map(x -> (CompletableFuture)x).collect(Collectors.toList());
        return CompletableFutureUtils.sequence(collect).thenApply(x -> (Either)x.get(0));
    }

    public CompletionStage<Either<UpdateMultiResult, Integer>> replaceMultiWithConfig(IEntityClass entityClass, List<Map<String, Object>> bodies, UpdateConfig updateConfig, Map<String, Object> context) {
        String profile = entityClass.realProfile();
        EntityClassGroup group = this.engine.describe(entityClass, profile);
        List<Map<IEntityClass, Map<String, Object>>> split = bodies.stream().map(body -> this.split(group, (Map<String, Object>)body, context, OperationType.REPLACE)).collect(Collectors.toList());
        Map<IEntityClass, List<Map<String, Object>>> groupedMapping = LocalEntityFacadeImpl.convertListMapToMapList(split);
        if (groupedMapping.isEmpty()) {
            return this.updateMultiInner(group, bodies, updateConfig, context, OperationType.REPLACE);
        }
        List collect = groupedMapping.entrySet().stream().map(entry -> {
            IEntityClass key = (IEntityClass)entry.getKey();
            EntityClassGroup targetGroup = this.getEntityClassEngine().describe(key, group.realProfile());
            List bodyOne = (List)entry.getValue();
            if (targetGroup.getEntityClass().id() == group.getEntityClass().id()) {
                return this.updateMultiInner(targetGroup, bodyOne, updateConfig, context, OperationType.REPLACE);
            }
            return this.updateMultiInner(targetGroup, bodyOne, null, context, OperationType.REPLACE);
        }).map(x -> (CompletableFuture)x).collect(Collectors.toList());
        return CompletableFutureUtils.sequence(collect).thenApply(x -> (Either)x.get(0));
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, UpdateConfig.builder().build(), context, OperationType.UPDATE);
        }
        return this.updateOneInner(group, id, body, UpdateConfig.builder().build(), context, OperationType.UPDATE);
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> updateByIdOptimizeLock(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, UpdateConfig.builder().useOptimisticLock(Boolean.valueOf(true)).build(), context, OperationType.UPDATE);
        }
        return this.updateOneInner(group, id, body, UpdateConfig.builder().useOptimisticLock(Boolean.valueOf(true)).build(), context, OperationType.UPDATE);
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> updateByIdWithConfig(IEntityClass entityClass, Long id, Map<String, Object> body, UpdateConfig updateConfig, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, updateConfig, context, OperationType.UPDATE);
        }
        return this.updateOneInner(group, id, body, updateConfig, context, OperationType.UPDATE);
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> replaceByIdWithConfig(IEntityClass entityClass, Long id, Map<String, Object> body, UpdateConfig updateConfig, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, updateConfig, context, OperationType.REPLACE);
        }
        return this.updateOneInner(group, id, body, updateConfig, context, OperationType.REPLACE);
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, UpdateConfig.builder().version(Integer.valueOf(version)).build(), context, OperationType.UPDATE);
        }
        return this.updateOneInner(group, id, body, UpdateConfig.builder().version(Integer.valueOf(version)).build(), context, OperationType.UPDATE);
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, UpdateConfig.builder().build(), context, OperationType.REPLACE);
        }
        return this.updateOneInner(group, id, body, UpdateConfig.builder().build(), context, OperationType.REPLACE);
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> replaceByIdOptimizeLock(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, UpdateConfig.builder().useOptimisticLock(Boolean.valueOf(true)).build(), context, OperationType.REPLACE);
        }
        return this.updateOneInner(group, id, body, UpdateConfig.builder().useOptimisticLock(Boolean.valueOf(true)).build(), context, OperationType.REPLACE);
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        if (entityClass.getType() == 2) {
            return this.updateOneInnerWithView(group, id, body, UpdateConfig.builder().version(Integer.valueOf(version)).build(), context, OperationType.REPLACE);
        }
        return this.updateOneInner(group, id, body, UpdateConfig.builder().version(Integer.valueOf(version)).build(), context, OperationType.REPLACE);
    }

    private CompletionStage<Either<UpdateOneResult, Integer>> updateOneInnerWithView(EntityClassGroup group, Long id, Map<String, Object> body, UpdateConfig updateConfig, Map<String, Object> context, OperationType operationType) {
        HashMap<String, Object> newBody = new HashMap<String, Object>(body);
        newBody.put("id", id);
        Map<IEntityClass, Map<String, Object>> split = this.split(group, newBody, context, operationType);
        List collect = split.entrySet().stream().map(entry -> {
            Map value = (Map)entry.getValue();
            if (value.get("id") != null && value.get("id") != EmptyValue.emptyValue) {
                IEntityClass key = (IEntityClass)entry.getKey();
                EntityClassGroup targetGroup = this.getEntityClassEngine().describe(key, group.realProfile());
                return this.updateOneInner(targetGroup, Long.parseLong(value.get("id").toString()), value, updateConfig, context, operationType);
            }
            return null;
        }).filter(Objects::nonNull).map(x -> (CompletableFuture)x).collect(Collectors.toList());
        return CompletableFutureUtils.sequence(collect).thenApply(x -> (Either)x.get(0));
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> updateOneInner(EntityClassGroup group, Long id, Map<String, Object> body, UpdateConfig updateConfig, Map<String, Object> context, OperationType operationType) {
        try {
            String profile = this.fetcher.getProfile(context);
            List pipelinedBody = this.transformerPipeline.valueSideHandleValue(group, body, operationType);
            HashMap<String, Object> newBody = new HashMap<String, Object>();
            pipelinedBody.forEach(x -> newBody.put(((IEntityField)x._1).name(), x._2));
            IEntity entity = this.toIEntity(group, newBody);
            entity.resetId(id.longValue());
            OqsEngineResult build = null;
            if (this.authBuilder != null && this.executeConfig.getUsePermission().booleanValue()) {
                ExpQuery idRelatedQuery = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.ID, (List)ExpValue.from((Object)id))).range(Integer.valueOf(1), Integer.valueOf(1));
                ExpContext expContext = new ExpContext();
                expContext.withContext(context);
                expContext.setSchema(group);
                Map<Long, Set<String>> mapping = this.collectEntityClassIdMapping((ExpRel)idRelatedQuery, group);
                ExpRel permissionExpRel = this.authBuilder.getPermissionTreeCondition(mapping, expContext, profile, OperationType.UPDATE);
                if (permissionExpRel != null) {
                    idRelatedQuery = idRelatedQuery.mergeAnd(permissionExpRel);
                }
                build = this.writeService.replaceConditional(entity, updateConfig, (ExpRel)idRelatedQuery, context);
            } else {
                build = this.writeService.replace(entity, updateConfig, context);
            }
            if (build.isSuccess()) {
                this.replaceOneCountTotal.increment();
                return CompletableFuture.completedFuture(Either.right((Object)1));
            }
            return CompletableFuture.completedFuture(Either.left((Object)UpdateOneResult.failFrom((ResultStatus.OriginStatus)build.getResultStatus(), (String)build.getMessage())));
        }
        catch (Throwable ex) {
            return this.exceptional(ex);
        }
    }

    private CompletionStage<Either<UpdateMultiResult, Integer>> updateMultiInner(EntityClassGroup group, List<Map<String, Object>> inputBodies, UpdateConfig updateConfig, Map<String, Object> context, OperationType operationType) {
        try {
            String profile = this.fetcher.getProfile(context);
            boolean usingOptimize = Optional.ofNullable(updateConfig).map(UpdateConfig::getUseOptimisticLock).orElse(false);
            ArrayList ids = new ArrayList();
            IEntity[] entities = (IEntity[])inputBodies.stream().map(x -> {
                List pipelinedBody = this.transformerPipeline.valueSideHandleValue(group, x, operationType);
                HashMap<String, Object> newBody = new HashMap<String, Object>();
                pipelinedBody.forEach(piped -> newBody.put(((IEntityField)piped._1).name(), piped._2));
                IEntity iEntity = this.toIEntity(group, newBody);
                Optional.ofNullable(x.get("id")).map(Object::toString).map(Long::parseLong).ifPresent(arg_0 -> ((IEntity)iEntity).resetId(arg_0));
                iEntity.resetVersion(-1);
                Optional.ofNullable(x.get("_sys_ver")).map(Object::toString).map(Integer::parseInt).ifPresent(arg_0 -> ((IEntity)iEntity).resetVersion(arg_0));
                ids.add(iEntity.id());
                iEntity.resetOptimizeLock(usingOptimize);
                return iEntity;
            }).toArray(IEntity[]::new);
            OqsEngineResult build = null;
            if (this.authBuilder != null && this.executeConfig.getUsePermission().booleanValue()) {
                ExpQuery dummy = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.IN, (ExpNode)ExpField.ID, (List)ExpValue.from(ids))).range(Integer.valueOf(1), Integer.valueOf(10000));
                ExpContext expContext = new ExpContext();
                expContext.withContext(context);
                expContext.setSchema(group);
                Map<Long, Set<String>> mapping = this.collectEntityClassIdMapping((ExpRel)dummy, group);
                ExpRel permissionExpRel = this.authBuilder.getPermissionTreeCondition(mapping, expContext, profile, OperationType.UPDATE);
                if (permissionExpRel != null) {
                    HashMap<String, ExpRel> expRelMapping = new HashMap<String, ExpRel>();
                    expRelMapping.put(group.getEntityClass().code(), permissionExpRel);
                    build = this.writeService.replaceConditional(entities, expRelMapping, context);
                } else {
                    HashMap<String, ExpQuery> expRelMapping = new HashMap<String, ExpQuery>();
                    expRelMapping.put(group.getEntityClass().code(), dummy);
                    build = this.writeService.replaceConditional(entities, expRelMapping, context);
                }
            } else {
                build = this.writeService.replace(entities, context);
            }
            if (build.isSuccess()) {
                if (build.getValue().isPresent()) {
                    this.replaceMultiCountTotal.increment((double)((Long)build.getValue().get()).longValue());
                    return CompletableFuture.completedFuture(Either.right((Object)((Long)build.getValue().get()).intValue()));
                }
                return CompletableFuture.completedFuture(Either.right((Object)1));
            }
            return CompletableFuture.completedFuture(Either.left((Object)UpdateMultiResult.failFrom((ResultStatus.OriginStatus)build.getResultStatus(), (String)build.getMessage())));
        }
        catch (Throwable ex) {
            return this.exceptional(ex);
        }
    }

    public CompletionStage<Either<UpdateMultiResult, Integer>> updateByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return this.updateByConditionInner(entityClass, rel, body, context, OperationType.UPDATE);
    }

    public CompletionStage<Either<UpdateMultiResult, Integer>> replaceByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return this.updateByConditionInner(entityClass, rel, body, context, OperationType.REPLACE);
    }

    public CompletionStage<Either<DeleteMultiResult, Integer>> deleteByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        OqsEngineResult updateResult;
        Map<Long, Set<String>> mapping;
        ExpRel permissionExpRel;
        EntityClassGroup group = this.getReader(entityClass, context);
        ExpContext expContext = new ExpContext().withContext(context).setSchema(group);
        ExpRel expRel = this.transformerPipeline.querySideHandleValue(rel, expContext);
        if (this.authBuilder != null && this.executeConfig.getUsePermission().booleanValue() && (permissionExpRel = this.authBuilder.getPermissionTreeCondition(mapping = this.collectEntityClassIdMapping(expRel, group), expContext, group.realProfile(), OperationType.DELETE)) != null) {
            expRel = expRel.mergeAnd(permissionExpRel);
        }
        if ((updateResult = this.writeService.deleteByCondition(entityClass, expRel, context)).isSuccess()) {
            if (updateResult.getValue().isPresent()) {
                this.deleteMultiCountTotal.increment((double)((Long)updateResult.getValue().get()).longValue());
                return CompletableFuture.completedFuture(Either.right((Object)((Long)updateResult.getValue().get()).intValue()));
            }
            return CompletableFuture.completedFuture(Either.right((Object)1));
        }
        return CompletableFuture.completedFuture(Either.left((Object)DeleteMultiResult.from((Throwable)new RuntimeException(updateResult.getMessage()))));
    }

    private CompletionStage<Either<UpdateMultiResult, Integer>> updateByConditionInner(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context, OperationType operationType) {
        OqsEngineResult updateResult;
        Map<Long, Set<String>> mapping;
        ExpRel permissionExpRel;
        EntityClassGroup group = this.getReader(entityClass, context);
        ExpContext expContext = new ExpContext().withContext(context).setSchema(group);
        ExpRel expRel = this.transformerPipeline.querySideHandleValue(rel, expContext);
        List pipelinedBody = this.transformerPipeline.valueSideHandleValue(group, body, operationType);
        HashMap<String, Object> newBody = new HashMap<String, Object>();
        pipelinedBody.forEach(x -> newBody.put(((IEntityField)x._1).name(), x._2));
        IEntity example = this.toIEntity(group, newBody);
        example.markTime();
        if (this.authBuilder != null && this.executeConfig.getUsePermission().booleanValue() && (permissionExpRel = this.authBuilder.getPermissionTreeCondition(mapping = this.collectEntityClassIdMapping(expRel, group), expContext, group.realProfile(), operationType)) != null) {
            expRel = expRel.mergeAnd(permissionExpRel);
        }
        if ((updateResult = this.writeService.updateByCondition(entityClass, expRel, example, context)).isSuccess()) {
            if (updateResult.getValue().isPresent()) {
                this.replaceMultiCountTotal.increment((double)((Long)updateResult.getValue().get()).longValue());
                return CompletableFuture.completedFuture(Either.right((Object)((Long)updateResult.getValue().get()).intValue()));
            }
            return CompletableFuture.completedFuture(Either.right((Object)1));
        }
        return CompletableFuture.completedFuture(Either.left((Object)UpdateMultiResult.from((Throwable)new RuntimeException(updateResult.getMessage()))));
    }

    private Map<Long, Set<String>> collectEntityClassIdMapping(ExpRel rawQuery, EntityClassGroup group) {
        if (rawQuery == null) {
            return Collections.emptyMap();
        }
        Long mainId = group.getEntityClass().id();
        HashMap<Long, String> idSet = new HashMap<Long, String>();
        idSet.put(mainId, "");
        FieldCollectors fieldCollectors = new FieldCollectors();
        List filters = Optional.ofNullable(rawQuery.getFilters()).orElseGet(Collections::emptyList);
        List projects = Optional.ofNullable(rawQuery.getProjects()).orElseGet(Collections::emptyList);
        filters.forEach(x -> {
            if (x != null) {
                x.accept((ExpVisitor)fieldCollectors);
            }
        });
        projects.forEach(x -> {
            if (x != null) {
                x.accept((ExpVisitor)fieldCollectors);
            }
        });
        Set fields = fieldCollectors.fields;
        List collect = fields.stream().map(x -> group.column(x)).filter(x -> x.isPresent()).map(x -> (ColumnField)x.get()).collect(Collectors.toList());
        Map<Long, List<ColumnField>> mapping = collect.stream().collect(Collectors.groupingBy(x -> x.originEntityClass().id()));
        HashMap<Long, Set<String>> retMapping = new HashMap<Long, Set<String>>();
        mapping.forEach((k, v) -> retMapping.compute((Long)k, (k1, v1) -> {
            if (v1 == null) {
                v1 = new HashSet();
            }
            v1.addAll(v.stream().map(c -> {
                if (c.name().startsWith("_") && c.name().contains(".")) {
                    int i = c.name().lastIndexOf(".");
                    return c.name().substring(1, i);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet()));
            return v1;
        }));
        retMapping.put(group.getEntityClass().id(), Collections.emptySet());
        return retMapping;
    }

    /*
     * Exception decompiling
     */
    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(ExpContext expContext, ExpRel rel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Object> getMapFromTuple(List<Tuple2<IEntityField, Object>> tupleList) {
        Map newBody = tupleList.stream().filter(Objects::nonNull).collect(HashMap::new, (m, v) -> m.put(((IEntityField)v._1()).name(), v._2()), HashMap::putAll);
        return newBody;
    }

    private List<Record> mergeRecord(EntityClassGroup entityClassGroup, List<Record> records, Map<String, Map<Long, Record>> valueMap, String profile) {
        Set<String> rels = valueMap.keySet();
        return records.stream().map(x -> {
            LinkedList newFields = new LinkedList();
            LinkedList values = new LinkedList();
            newFields.addAll(x.fields(entityClassGroup.getEntityClass()));
            values.addAll(x.values());
            for (String rel : rels) {
                Map mapping;
                Optional idOp = x.get(rel.concat(".id"));
                Optional relatedEntityClassOp = entityClassGroup.relatedEntityClass(rel);
                if (!idOp.isPresent() || !relatedEntityClassOp.isPresent() || (mapping = (Map)valueMap.get(rel)) == null) continue;
                Record record = (Record)mapping.get(Long.parseLong(idOp.get().toString()));
                if (record != null) {
                    newFields.addAll(record.fields(rel, (IEntityClass)relatedEntityClassOp.get()));
                    values.addAll(record.values());
                    continue;
                }
                log.warn("record is null ");
            }
            GeneralRecord generalRecord = new GeneralRecord(newFields);
            generalRecord.setValues(values);
            generalRecord.setId(x.getId());
            generalRecord.setTypeId(x.getTypeId());
            return generalRecord;
        }).collect(Collectors.toList());
    }

    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        EntityClassGroup group = this.engine.describe(entityClass, this.fetcher.getProfile(context));
        ExpContext expContext = new ExpContext();
        expContext.setSchema(group);
        expContext.withContext(context);
        return this.query(expContext, rel);
    }

    public <T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel initRel, BiFunction<ExpRel, Record, ExpRel> conditionTransformer, Function<Record, T> transformer, Map<String, Object> context) {
        int step = 1000;
        return () -> new LazyFetchIterator((Object)initRel, expRel -> {
            log.debug("Current expRel {}", expRel);
            Either<QueryResult, DataCollection<Record>> queryResult = this.query(entityClass, (ExpRel)expRel, context).toCompletableFuture().join();
            if (queryResult.isRight()) {
                return ((DataCollection)queryResult.get()).getRows();
            }
            return Collections.emptyList();
        }, (expRel, last) -> (ExpRel)conditionTransformer.apply((ExpRel)expRel, (Record)last), request -> true, response -> response.isEmpty() || response.size() < step, transformer);
    }

    public <T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel rel, Function<Record, T> transformer, boolean isLegacy, Map<String, Object> context) {
        AtomicInteger startIndex = new AtomicInteger(1);
        return this.queryIterate(entityClass, rel, (ExpRel expRel, Record last) -> ExpFactory.withRange((ExpRel)expRel, (ExpRange)new ExpRange(Integer.valueOf(startIndex.incrementAndGet()), Integer.valueOf(1000))), transformer, context);
    }

    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass, Long id, Map<String, Object> context) {
        ExpQuery expQuery = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.ID, (List)ExpValue.from((Object)id))).range(Integer.valueOf(1), Integer.valueOf(1));
        return this.query(entityClass, (ExpRel)expQuery, context).thenApply(x -> {
            boolean right = x.isRight();
            if (right) {
                DataCollection retCollection = (DataCollection)x.get();
                if (retCollection.getRowNum() > 0) {
                    Record record = (Record)retCollection.getRows().get(0);
                    Either rightRet = Either.right((Object)record);
                    return rightRet;
                }
                Either notFound = Either.left((Object)QueryOneResult.from((Throwable)new RecordMissingException(RecordMissingException.getMsg((String[])new String[]{entityClass.code(), id.toString()}))));
                return notFound;
            }
            QueryResult leftReason = (QueryResult)x.getLeft();
            Either dataCollections = Either.left((Object)QueryOneResult.from((Throwable)new RuntimeException(leftReason.getMessage())));
            return dataCollections;
        });
    }

    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass, IEntityClass subEntityClass, Long id, Map<String, Object> context) {
        return this.findOneById(entityClass, id, context);
    }

    public CompletionStage<Integer> count(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        ExpQuery query = (ExpQuery)rel;
        query.range(Integer.valueOf(1), Integer.valueOf(1));
        return this.query(entityClass, rel, context).thenApply(x -> (Integer)x.map(DataCollection::getRowNum).getOrElseThrow(str -> {
            QueryResult queryResult = str;
            throw new RuntimeException(queryResult.getMessage());
        }));
    }

    public EntityClassGroup getReader(IEntityClass entityClass, Map<String, Object> context) {
        return this.engine.describe(entityClass, this.fetcher.getProfile(context));
    }

    public EntityClassEngine getEntityClassEngine() {
        return this.engine;
    }

    public ProfileFetcher getFetcher() {
        return this.fetcher;
    }

    public void setFetcher(ProfileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public void validate(IEntityClass entityClass, Map<String, Object> body) {
        this.transformerPipeline.validate(entityClass, (List)entityClass.fields(), body);
    }

    private static /* synthetic */ void lambda$query$72(Object verMapping, Record x) {
        Long id = x.getId();
        Integer ver = (Integer)((Map)verMapping).get(id);
        if (ver != null) {
            x.setVersion(ver);
        }
    }

    private static /* synthetic */ Object lambda$query$71(Map.Entry x) {
        return x.getValue();
    }

    private static /* synthetic */ boolean lambda$query$70(Map.Entry entry) {
        return ((String)((Tuple2)entry.getKey())._1).equalsIgnoreCase("id");
    }

    private static /* synthetic */ void lambda$query$69(GeneralRecord record, Map.Entry v) {
        record.set((String)((Tuple2)v.getKey())._1, v.getValue());
    }

    private static /* synthetic */ IEntityField lambda$query$68(Map.Entry x) {
        EntityField field = new EntityField(0L, (String)((Tuple2)x.getKey())._1, FieldType.STRING);
        return field;
    }

    private static /* synthetic */ void lambda$query$67(Collection polyFields, ResultSet polyResult, Map polyFieldsMapping, Map values, EntityClassGroup polyGroup, String key) {
        try {
            if (key.equalsIgnoreCase("*")) {
                polyFields.forEach(x -> {
                    try {
                        String polyValue = polyResult.getString(x.name());
                        IEntityField targetField = (IEntityField)polyFieldsMapping.get(x.name());
                        Tuple2 keyTuple = Tuple.of((Object)x.name(), (Object)targetField.id());
                        values.put(keyTuple, polyValue);
                    }
                    catch (SQLException e) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.CONDITION_QUERY_ERROR, (String)"DealWithStar", (Throwable)e);
                    }
                });
            } else {
                String polyValue = polyResult.getString(key);
                IEntityField targetField = key.startsWith("_") ? (IEntityField)polyGroup.column(key).orElse(null) : (IEntityField)polyFieldsMapping.get(key);
                Tuple2 keyTuple = Tuple.of((Object)key, (Object)targetField.id());
                values.put(keyTuple, polyValue);
            }
        }
        catch (SQLException e) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.CONDITION_QUERY_ERROR, (String)"DealWithPloy", (Throwable)e);
        }
    }

    private static /* synthetic */ IEntityField lambda$query$65(IEntityField a, IEntityField b) {
        return a;
    }

    private static /* synthetic */ IEntityField lambda$query$64(IEntityField y) {
        return y;
    }

    private static /* synthetic */ String lambda$query$63(IEntityField x) {
        return x.name();
    }

    private static /* synthetic */ Stream lambda$query$62(Tuple3 x) {
        return ExpValue.from((Object)x._1).stream();
    }

    private static /* synthetic */ void lambda$query$61(Collection fields, ResultSet resultSet, Map mapping, Map values, EntityClassGroup group, AtomicBoolean hasAggField, String key) {
        try {
            if (key.equalsIgnoreCase("*")) {
                fields.forEach(x -> {
                    try {
                        String value = resultSet.getString(x.name());
                        IEntityField targetField = (IEntityField)mapping.get(x.name());
                        Tuple2 keyTuple = Tuple.of((Object)x.name(), (Object)targetField.id());
                        values.put(keyTuple, value);
                    }
                    catch (SQLException e) {
                        LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.CONDITION_QUERY_ERROR, (Throwable)e);
                    }
                });
            } else {
                String value = resultSet.getString(key);
                IEntityField targetField = key.startsWith("_") ? (IEntityField)group.column(key).orElse(null) : (IEntityField)mapping.get(key);
                Tuple2 keyTuple = null;
                if (targetField != null) {
                    keyTuple = Tuple.of((Object)key, (Object)targetField.id());
                } else {
                    hasAggField.set(true);
                    keyTuple = Tuple.of((Object)key, (Object)-1L);
                }
                values.put(keyTuple, value);
            }
        }
        catch (SQLException e) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.CONDITION_QUERY_ERROR, (Throwable)e);
        }
    }

    private static /* synthetic */ IEntityField lambda$query$59(IEntityField a, IEntityField b) {
        return a;
    }

    private static /* synthetic */ IEntityField lambda$query$58(IEntityField y) {
        return y;
    }

    private static /* synthetic */ String lambda$query$57(IEntityField x) {
        return x.name();
    }

    private static /* synthetic */ String lambda$query$56(ExpField x) {
        return Optional.ofNullable(x.getAlise()).orElse(x.getName());
    }

    private static /* synthetic */ ExpField lambda$query$55(ExpNode x) {
        return (ExpField)x;
    }

    private static /* synthetic */ boolean lambda$query$54(ExpNode x) {
        return x instanceof ExpFunc;
    }

    class FieldCollectors
    implements ExpVisitor<Void> {
        private Set<String> fields = new HashSet<String>();

        FieldCollectors() {
        }

        public Void visit(ExpField field) {
            this.fields.add(field.getName());
            return null;
        }

        public Void visit(ExpCondition rel) {
            rel.getExpNodes().forEach(x -> {
                Void cfr_ignored_0 = (Void)x.accept((ExpVisitor)this);
            });
            return null;
        }

        public Void visit(ExpValue value) {
            return null;
        }

        public Void visit(ExpBi bi) {
            return null;
        }

        public Void visit(ExpSort expSort) {
            return null;
        }

        public Void visit(ExpRange range) {
            return null;
        }
    }
}

