/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.graphql;

import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.MutationProvider;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateOneResult;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.infra.exceptions.OperationNotSupportedException;
import io.vavr.control.Either;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class LocalMutationProvider
implements MutationProvider {
    private static final Logger log = LoggerFactory.getLogger(LocalMutationProvider.class);
    private EntityFacade entityFacade;

    public LocalMutationProvider(EntityFacade entityFacade) {
        this.entityFacade = entityFacade;
    }

    public boolean accept(IEntityClass entityClass) {
        return entityClass.getType() != 1;
    }

    public String create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.create(entityClass, body, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Long)join.get()).toString();
        }
        throw new RuntimeException(((CreateOneResult)join.getLeft()).getMessage());
    }

    public String batchCreate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.createMulti(entityClass, inputBodies, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((CreateMultiResult)join.getLeft()).getMessage());
    }

    public String update(IEntityClass entityClass, long id, Map<String, Object> body, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.updateById(entityClass, Long.valueOf(id), body, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((UpdateOneResult)join.getLeft()).getMessage());
    }

    public String batchUpdate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.updateMulti(entityClass, inputBodies, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((UpdateMultiResult)join.getLeft()).getMessage());
    }

    @Transactional
    public String delete(IEntityClass entityClass, long id, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.deleteOne(entityClass, Long.valueOf(id), context).toCompletableFuture().join();
        Object relations = context.get("relations");
        if (relations != null) {
            EntityClassGroup group = this.entityFacade.getEntityClassEngine().describe(entityClass, this.entityFacade.getFetcher().getProfile(context));
            String[] relationArray = relations.toString().split(",");
            Arrays.stream(relationArray).forEach(x -> {
                Optional relatedEntity = group.relatedEntityClass(x);
                if (relatedEntity.isPresent()) {
                    ExpQuery query = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)x.concat(".id")), (List)ExpValue.from((Object)id))).range(Integer.valueOf(1), Integer.valueOf(10000));
                    try {
                        this.entityFacade.deleteByCondition((IEntityClass)relatedEntity.get(), (ExpRel)query, context).toCompletableFuture().get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((DeleteOneResult)join.getLeft()).getMessage());
    }

    public String batchDelete(IEntityClass entityClass, List<Long> ids, Map<String, Object> context) {
        Either join = (Either)this.entityFacade.deleteMulti(entityClass, ids, context).toCompletableFuture().join();
        if (join.isRight()) {
            return ((Integer)join.get()).toString();
        }
        throw new RuntimeException(((DeleteMultiResult)join.getLeft()).getMessage());
    }

    public String custom(IEntityClass entityClass, String actionName, Map<String, Object> argument, Map<String, Object> all) {
        throw new OperationNotSupportedException(OperationNotSupportedException.getMsg((String[])new String[]{"custom"}));
    }
}

