/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.query.strategy;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanSearchTable;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanTableScan;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.OqsengineFilter;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.infra.exceptions.EntityClassMissingException;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import com.xforceplus.ultraman.sdk.invocation.invoke.config.InvocationConfig;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sarg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterStickQueryStrategy
implements QueryProviderSelectStrategy {
    private static final Logger log = LoggerFactory.getLogger(MasterStickQueryStrategy.class);
    private EntityClassEngine engine;
    private InvocationConfig invocationConfig;
    private ProfileFetcher fetcher;
    private ContextService contextService;

    public MasterStickQueryStrategy(EntityClassEngine engine, ProfileFetcher fetcher, ContextService contextService, InvocationConfig invocationConfig) {
        this.invocationConfig = invocationConfig;
        this.engine = engine;
        this.fetcher = fetcher;
        this.contextService = contextService;
    }

    public String name() {
        return "master-stick";
    }

    public Map<DataQueryProvider, Double> score(String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext, List<DataQueryProvider> dataQueryProviderList) {
        HashMap<DataQueryProvider, Double> master = new HashMap<DataQueryProvider, Double>();
        try {
            Optional<DataQueryProvider> first;
            boolean suitable;
            if (dataQueryProviderList.size() > 1 && (suitable = this.isSuitable(rawTree)) && (first = dataQueryProviderList.stream().filter(x -> x.type() == DataQueryProvider.QueryProviderType.MASTER).findFirst()).isPresent()) {
                master.put(first.get(), (Double)Double.MAX_VALUE);
            }
        }
        catch (Throwable throwable) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.GENERAL_UTILS_ERROR, (Throwable)throwable);
        }
        return master;
    }

    private boolean isSuitable(RelNode rawTree) {
        boolean containsUnique = this.invocationConfig.isSearchMasterWithUniqueIndex();
        CheckCondition checkCondition = new CheckCondition(containsUnique);
        rawTree.accept((RelShuttle)checkCondition);
        return checkCondition.suitable();
    }

    class ConditionFinderVisitor
    extends RexVisitorImpl<Void> {
        private boolean suitable;
        private RelNode currentNode;
        private EntityClassEngine engine;
        private IEntityClass currentEntityClass;
        private Set<String> names;
        private Set<Sarg> args;

        protected ConditionFinderVisitor(EntityClassEngine engine, RelNode currentNode, IEntityClass entityClass) {
            super(true);
            this.suitable = false;
            this.names = new HashSet<String>();
            this.args = new HashSet<Sarg>();
            this.currentNode = currentNode;
            this.engine = engine;
            this.currentEntityClass = entityClass;
        }

        public boolean isSuitable() {
            if (this.names.isEmpty()) {
                return this.suitable;
            }
            Collection boIndices = this.currentEntityClass.uniqueIndexes();
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            boIndices.forEach(in -> {
                String fieldIds = in.getFieldIds();
                String[] namesArray = fieldIds.split(",");
                HashSet set = new HashSet();
                for (String name : namesArray) {
                    this.currentEntityClass.field(name).ifPresent(entityField -> set.add(entityField.name()));
                }
                if (this.names.containsAll(set)) {
                    atomicBoolean.set(true);
                }
            });
            return atomicBoolean.get() || this.names.contains("id") && (this.args.isEmpty() || this.args.stream().allMatch(Sarg::isPoints));
        }

        public void setSuitable(boolean suitable) {
            this.suitable = suitable;
        }

        public Void visitCall(RexCall call) {
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.AND) {
                call.getOperands().stream().filter(x -> x instanceof RexCall).filter(x -> ((RexCall)x).getOperator() == SqlStdOperatorTable.EQUALS).forEach(x -> {
                    Void cfr_ignored_0 = (Void)x.accept((RexVisitor)this);
                });
            } else if (operator == SqlStdOperatorTable.OR) {
                this.suitable = false;
            } else if (operator == SqlStdOperatorTable.EQUALS || operator == SqlStdOperatorTable.IN || operator == SqlStdOperatorTable.SEARCH) {
                call.getOperands().stream().filter(x -> x instanceof RexInputRef).forEach(x -> {
                    int index = ((RexInputRef)x).getIndex();
                    RelDataTypeField relDataTypeField = (RelDataTypeField)this.currentNode.getRowType().getFieldList().get(index);
                    this.names.add(relDataTypeField.getName().toLowerCase(Locale.ROOT));
                });
                if (operator == SqlStdOperatorTable.SEARCH) {
                    call.getOperands().stream().filter(x -> x instanceof RexLiteral).map(x -> ((RexLiteral)x).getValue()).filter(x -> x instanceof Sarg).forEach(sarg -> this.args.add((Sarg)sarg));
                }
            } else {
                this.suitable = false;
            }
            return null;
        }

        private EntityClassGroup findRelatedEntityClass(RelNode relNode, List<EntityClassGroup> allRelatedEntityClasses) {
            Stack<RelNode> stack = new Stack<RelNode>();
            stack.push(relNode);
            while (!stack.isEmpty()) {
                RelNode input;
                RelNode next = (RelNode)stack.pop();
                if (next instanceof TableScan) {
                    RelOptTable table = ((TableScan)next).getTable();
                    String entityCode = (String)table.getQualifiedName().get(1);
                    Optional<EntityClassGroup> first = allRelatedEntityClasses.stream().filter(x -> x.getEntityClass().code().equalsIgnoreCase(entityCode)).findFirst();
                    if (!first.isPresent()) continue;
                    return first.get();
                }
                if (next instanceof BiRel) {
                    input = next.getInput(0);
                    stack.push(input);
                    continue;
                }
                input = next.getInput(0);
                stack.push(input);
            }
            throw new EntityClassMissingException(EntityClassMissingException.getMsg((String[])new String[0]));
        }
    }

    class CheckCondition
    implements RelShuttle {
        private boolean containsUnique;
        private boolean suitable = false;
        private IEntityClass entityClass;

        public CheckCondition(boolean containsUnique) {
            this.containsUnique = containsUnique;
        }

        public boolean suitable() {
            return this.suitable;
        }

        public RelNode visit(TableScan scan) {
            if (scan instanceof UltramanTableScan) {
                UltramanSearchTable table = ((UltramanTableScan)scan).getSearchTable();
                String code = table.getCode();
                String profile = MasterStickQueryStrategy.this.fetcher.getProfile(MasterStickQueryStrategy.this.contextService.getAll());
                Optional entityClassOp = MasterStickQueryStrategy.this.engine.loadByCode(code, profile);
                if (entityClassOp.isPresent()) {
                    this.entityClass = (IEntityClass)entityClassOp.get();
                } else {
                    throw new EntityClassMissingException(EntityClassMissingException.getMsg((String[])new String[]{code}));
                }
            }
            return null;
        }

        public RelNode visit(TableFunctionScan scan) {
            return null;
        }

        public RelNode visit(LogicalValues values) {
            return null;
        }

        public RelNode visit(LogicalFilter filter) {
            return null;
        }

        public RelNode visit(LogicalCalc calc) {
            return null;
        }

        public RelNode visit(LogicalProject project) {
            return null;
        }

        public RelNode visit(LogicalJoin join) {
            return null;
        }

        public RelNode visit(LogicalCorrelate correlate) {
            return null;
        }

        public RelNode visit(LogicalUnion union) {
            return null;
        }

        public RelNode visit(LogicalIntersect intersect) {
            return null;
        }

        public RelNode visit(LogicalMinus minus) {
            return null;
        }

        public RelNode visit(LogicalAggregate aggregate) {
            return null;
        }

        public RelNode visit(LogicalMatch match) {
            return null;
        }

        public RelNode visit(LogicalSort sort) {
            return null;
        }

        public RelNode visit(LogicalExchange exchange) {
            return null;
        }

        public RelNode visit(LogicalTableModify modify) {
            return null;
        }

        public RelNode visit(RelNode node) {
            node.getInputs().forEach(x -> x.accept((RelShuttle)this));
            if (node instanceof OqsengineFilter) {
                RexNode condition = ((OqsengineFilter)node).getCondition();
                ConditionFinderVisitor conditionFinderVisitor = new ConditionFinderVisitor(MasterStickQueryStrategy.this.engine, node, this.entityClass);
                condition.accept((RexVisitor)conditionFinderVisitor);
                this.suitable = conditionFinderVisitor.isSuitable();
            }
            return null;
        }
    }
}

