/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.utils;

import com.xforceplus.ultraman.metadata.domain.func.FuncValue;
import com.xforceplus.ultraman.metadata.domain.func.OnDuplicateFuncValue;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.helper.ConvertHelper;
import com.xforceplus.ultraman.metadata.values.EmptyTypedValue;
import com.xforceplus.ultraman.metadata.values.ExpressionValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.metadata.values.OnDuplicateValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class CommonHelper {
    public static List<IValue> getValuesFromMap(EntityClassGroup entityClass, Map<String, Object> body) {
        return body.entrySet().stream().map(entry -> {
            Optional fieldOp;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value != null && (fieldOp = entityClass.field(key)).isPresent()) {
                IEntityField field = (IEntityField)fieldOp.get();
                if (EmptyValue.isEmpty((String)value.toString())) {
                    return new EmptyTypedValue(field);
                }
                if (value instanceof FuncValue) {
                    return new ExpressionValue(field, (FuncValue)value);
                }
                if (value instanceof OnDuplicateFuncValue) {
                    Optional iValueOp = field.type().toTypedValue(field, ConvertHelper.convert((Object)((OnDuplicateFuncValue)value).getRawObject()));
                    if (iValueOp.isPresent()) {
                        ExpressionValue target = null;
                        if (((OnDuplicateFuncValue)value).getOnDuplicateObject() instanceof FuncValue) {
                            target = new ExpressionValue(field, (FuncValue)((OnDuplicateFuncValue)value).getOnDuplicateObject());
                        } else {
                            Object rawObject = ((OnDuplicateFuncValue)value).getOnDuplicateObject();
                            Optional typedValueOp = field.type().toTypedValue(field, ConvertHelper.convert((Object)rawObject));
                            if (typedValueOp.isPresent()) {
                                target = (IValue)typedValueOp.get();
                            }
                        }
                        return new OnDuplicateValue(field, (IValue)iValueOp.get(), (IValue)target);
                    }
                } else {
                    Optional iValue = field.type().toTypedValue(field, ConvertHelper.convert(value));
                    if (iValue.isPresent()) {
                        return (IValue)iValue.get();
                    }
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

