package com.xforceplus.ultraman.adapter.core.impl;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.pojo.OqsEngineResult;
import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.impl.Entity;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.result.*;
import com.xforceplus.ultraman.sdk.core.pipeline.OperationType;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import com.xforceplus.ultraman.sdk.core.rel.utils.ExpTreeToRel;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.base.id.IdGenerator;
import com.xforceplus.ultraman.sdk.infra.metrics.MetricsDefine;
import com.xforceplus.ultraman.sdk.infra.query.LazyFetchIterator;
import io.micrometer.core.annotation.Timed;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.control.Either;
import lombok.extern.slf4j.Slf4j;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.xforceplus.ultraman.adapter.utils.CommonHelper.getValuesFromMap;

/**
 * TODO
 * local entity facade
 */
@Slf4j
public class LocalEntityFacadeImpl implements EntityFacade {

    private final static int QUERY_STEP = 1000;

    @Qualifier("CalciteDS")
    @Lazy
    @Autowired
    private DataSource dataSource;

    @Lazy
    @Autowired
    private FrameworkConfig config;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private ContextService contextService;
    @Autowired
    private EntityWriteService writeService;
    @Autowired
    private IdGenerator<Long> idGenerator;
    @Autowired
    private TransformerPipeline transformerPipeline;
    @Qualifier("commonPool")
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private ExecutionConfig executeConfig;
    @Autowired(required = false)
    private AuthBuilder authBuilder;

    public LocalEntityFacadeImpl() {
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConfig(FrameworkConfig config) {
        this.config = config;
    }

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    public void setWriteService(EntityWriteService writeService) {
        this.writeService = writeService;
    }

    public void setIdGenerator(IdGenerator<Long> idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setTransformerPipeline(TransformerPipeline transformerPipeline) {
        this.transformerPipeline = transformerPipeline;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setExecuteConfig(ExecutionConfig executeConfig) {
        this.executeConfig = executeConfig;
    }

    public void setAuthBuilder(AuthBuilder authBuilder) {
        this.authBuilder = authBuilder;
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile) {
        return engine.load(boId, profile);
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return engine.load(boId, profile, version);
    }

    @Override
    public Optional<IEntityClass> loadByCode(String bocode, String profile) {
        return engine.loadByCode(bocode, profile);
    }

    @Override
    public Optional<IEntityClass> loadByCode(String bocode, String profile, String version) {
        return engine.loadByCode(bocode, profile, version);
    }

    private IEntity toIEntity(IEntityClass entityClass, long id) {
        return Entity.Builder.anEntity().withEntityClassRef(entityClass.ref()).withId(id).build();
    }

    private IEntity toIEntity(EntityClassGroup entityClass, Map<String, Object> body) {
        long id = Optional.ofNullable(body.get("id")).map(Object::toString).map(Long::parseLong).orElse(0L);
        return Entity.Builder.anEntity()
                .withEntityClassRef(entityClass
                        .getEntityClass()
                        .ref()).withId(id)
                .withValues(getValuesFromMap(entityClass, body)).build();
    }

    @Override
    public CompletionStage<Either<CreateOneResult, Long>> create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {
        try {
            EntityClassGroup group = engine.describe(entityClass, fetcher.getProfile(context));
            List<Tuple2<IEntityField, Object>> pipelinedBody = transformerPipeline.valueSideHandleValue(group, body, OperationType.CREATE);
            Map<String, Object> newBody = new HashMap<>();
            pipelinedBody.forEach(x -> {
                newBody.put(x._1.name(), x._2);
            });

            IEntity entity = toIEntity(group, newBody);
            if (entity.id() == 0) {
                Long next = idGenerator.next();
                entity.resetId(next);
                body.put("id", next);
            }

            OqsEngineResult<Long> build = writeService.build(entity, context);
            if (build.isSuccess()) {
                Long retLong = build.getValue().get();
                return CompletableFuture.completedFuture(Either.right(retLong));
            } else {
                return CompletableFuture.completedFuture(Either.left(CreateOneResult.from(new RuntimeException(build.getMessage()))));
            }
        } catch (Throwable ex) {
            return exceptional(ex);
        }
    }

    @Override
    public CompletionStage<Either<CreateMultiResult, Integer>> createMulti(IEntityClass entityClass, Stream<Map<String, Object>> body, Map<String, Object> context) {
        try {
            EntityClassGroup group = engine.describe(entityClass, fetcher.getProfile(context));
            IEntity[] entities = body
                    .map(x -> {
//                        long start = System.currentTimeMillis();
                        long start = System.currentTimeMillis();
                        List<Tuple2<IEntityField, Object>> pipelinedBody = transformerPipeline
                                .valueSideHandleValue(group, x, OperationType.CREATE);
                        System.out.println(System.currentTimeMillis() - start);
                        Map<String, Object> newBody = new HashMap<>();
                        pipelinedBody.forEach(piped -> {
                            newBody.put(piped._1.name(), piped._2);
                        });

                        IEntity iEntity = toIEntity(group, newBody);

                        return iEntity;
                    })
                    .peek(x -> {
                        if (x.id() == 0) {
                            x.resetId(idGenerator.next());
                        }
                    }).toArray(IEntity[]::new);
            OqsEngineResult<Long> build = writeService.build(entities, context);
            if (build.isSuccess()) {
                Long retLong = build.getValue().get();
                return CompletableFuture.completedFuture(Either.right(retLong.intValue()));
            } else {
                return CompletableFuture.completedFuture(Either.left(CreateMultiResult.from(new RuntimeException(build.getMessage()))));
            }
        } catch (Throwable ex) {
            return exceptional(ex);
        }
    }

    private <T> CompletionStage<T> exceptional(Throwable ex) {
        CompletableFuture result = new CompletableFuture<>();
        result.completeExceptionally(ex);
        return result;
    }

    @Override
    public CompletionStage<Either<CreateMultiResult, Integer>> createMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return this.createMulti(entityClass, body.stream(), context);
    }

    @Override
    public CompletionStage<Either<DeleteOneResult, Integer>> deleteOne(IEntityClass entityClass, Long id, Map<String, Object> context) {
        try {
            OqsEngineResult<Long> build = writeService.delete(toIEntity(entityClass, id), context);
            if (build.isSuccess()) {
                //Long retLong = build.getValue().get();
                return CompletableFuture.completedFuture(Either.right(1));
            } else {
                return CompletableFuture.completedFuture(Either.left(DeleteOneResult.from(new RuntimeException(build.getMessage()))));
            }
        } catch (Throwable ex) {
            return exceptional(ex);
        }
    }

    @Override
    public CompletionStage<Either<DeleteMultiResult, Integer>> deleteMulti(IEntityClass entityClass, List<Long> ids, Map<String, Object> context) {
        try {
            IEntity[] entities = ids.stream().map(x -> toIEntity(entityClass, x)).toArray(IEntity[]::new);
            OqsEngineResult<Long> build = writeService.delete(entities, context);
            if (build.isSuccess()) {
                Long retLong = build.getValue().get();
                return CompletableFuture.completedFuture(Either.right(retLong.intValue()));
            } else {
                return CompletableFuture.completedFuture(Either.left(DeleteMultiResult.from(new RuntimeException(build.getMessage()))));
            }
        } catch (Throwable ex) {
            return exceptional(ex);
        }
    }

    @Override
    public CompletionStage<Either<UpdateMultiResult, Integer>> updateMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return this.replaceMulti(entityClass, body, context);
    }

    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        try {
            EntityClassGroup group = engine.describe(entityClass, fetcher.getProfile(context));
            List<Tuple2<IEntityField, Object>> pipelinedBody = transformerPipeline.valueSideHandleValue(group, body, OperationType.UPDATE);
            Map<String, Object> newBody = new HashMap<>();
            pipelinedBody.forEach(x -> {
                newBody.put(x._1.name(), x._2);
            });
            IEntity entity = toIEntity(group, newBody);
            entity.resetId(id);
            OqsEngineResult<Long> build = writeService.replace(entity, context);
            if (build.isSuccess()) {
                //Long retLong = build.getValue().get();
                return CompletableFuture.completedFuture(Either.right(1));
            } else {
                return CompletableFuture.completedFuture(Either.left(UpdateOneResult.from(new RuntimeException(build.getMessage()))));
            }
        } catch (Throwable ex) {
            return exceptional(ex);
        }
    }

    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        return this.updateById(entityClass, id, body, context);
    }

    @Override
    public CompletionStage<Either<UpdateMultiResult, Integer>> replaceMulti(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        try {
            EntityClassGroup group = engine.describe(entityClass, fetcher.getProfile(context));
            IEntity[] entities = inputBodies.stream().map(x -> {
                List<Tuple2<IEntityField, Object>> pipelinedBody = transformerPipeline
                        .valueSideHandleValue(group, x, OperationType.REPLACE);
                Map<String, Object> newBody = new HashMap<>();
                pipelinedBody.forEach(piped -> {
                    newBody.put(piped._1.name(), piped._2);
                });
                IEntity iEntity = toIEntity(group, newBody);
                Optional.ofNullable(x.get("id")).map(Object::toString)
                        .map(Long::parseLong)
                        .ifPresent(iEntity::resetId);
                return iEntity;
            }).toArray(IEntity[]::new);
            OqsEngineResult<Long> build = writeService.replace(entities, context);
            if (build.isSuccess()) {
                //Long retLong = build.getValue().get();
                return CompletableFuture.completedFuture(Either.right(1));
            } else {
                return CompletableFuture.completedFuture(Either.left(UpdateMultiResult.from(new RuntimeException(build.getMessage()))));
            }
        } catch (Throwable ex) {
            return exceptional(ex);
        }
    }

    /**
     * TODO
     *
     * @param entityClass
     * @param id
     * @param body
     * @param context
     * @return
     */
    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        return this.updateById(entityClass, id, body, context);
    }

    /**
     * TOOD
     *
     * @param entityClass
     * @param id
     * @param body
     * @param version
     * @param context
     * @return
     */
    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        return this.updateById(entityClass, id, body, context);
    }

    /**
     * TODO
     *
     * @param entityClass
     * @param rel
     * @param body
     * @param context
     * @return
     */
    @Override
    public CompletionStage<Either<UpdateResult, Integer>> updateByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    /**
     * TODO
     *
     * @param entityClass
     * @param rel
     * @param body
     * @param context
     * @return
     */
    @Override
    public CompletionStage<Either<UpdateResult, Integer>> replaceByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    private Map<Long, Set<String>> collectEntityClassIdMapping(ExpRel rawQuery, EntityClassGroup group) {

        if (rawQuery == null) {
            return Collections.emptyMap();
        }

        Long mainId = group.getEntityClass().id();
        Map<Long, String> idSet = new HashMap<>();
        idSet.put(mainId, "");

        FieldCollectors fieldCollectors = new FieldCollectors();

        List<ExpNode> filters = rawQuery.getFilters();
        List<ExpNode> projects = rawQuery.getProjects();

        filters.forEach(x -> x.accept(fieldCollectors));
        projects.forEach(x -> x.accept(fieldCollectors));

        Set<String> fields = fieldCollectors.fields;

        List<ColumnField> collect = fields.stream().map(x -> group.column(x))
                .filter(x -> x.isPresent())
                .map(x -> x.get())
                .collect(Collectors.toList());

        Map<Long, List<ColumnField>> mapping = collect.stream()
                .collect(Collectors.groupingBy(x -> x.originEntityClass().id()));

        Map<Long, Set<String>> retMapping = new HashMap<>();
        mapping.forEach((k, v) -> {
            retMapping.compute(k, (k1, v1) -> {
                if (v1 == null) {
                    v1 = new HashSet<>();
                }

                v1.addAll(v.stream().map(c -> {
                    if (c.name().startsWith("_") && c.name().contains(".")) {
                        //related field
                        int i = c.name().lastIndexOf(".");
                        return c.name().substring(1, i);
                    } else {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet()));
                return v1;
            });
        });

        retMapping.put(group.getEntityClass().id(), Collections.emptySet());

        return retMapping;
    }

//    private ExpRel getPermissionTreeCondition(Map<Long, List<String>> involvedIdsMapping, ExpContext expContext, String profile) {
//        if (executeConfig.getUsePermission()) {
//            if (clientDataRuleProvider != null) {
//                //old
//                return getPermissionTreeConditionLegacy(involvedIdsMapping, expContext, profile);
//            } else if (dataRuleProvider != null) {
//                //new
//                return getPermissionTreeConditionNew(involvedIdsMapping, expContext, profile);
//            }
//        }
//
//        return null;
//    }

    /**
     * TODO
     *
     * @param expContext
     * @param rel
     * @return
     */
    @Override
    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(ExpContext expContext, ExpRel rel) {
        try {
            String profile = fetcher.getProfile(expContext.getContext());
            if (authBuilder != null && executeConfig.getUsePermission()) {

                /**
                 * TODO to many to one condition
                 */
                Map<Long, Set<String>> mapping = collectEntityClassIdMapping(rel, expContext.getSchema());
                ExpRel permissionExpRel = authBuilder.getPermissionTreeCondition(
                        mapping
                        , expContext
                        , profile);
                if (permissionExpRel != null) {
                    rel = rel.mergeAnd(permissionExpRel);
                }
            }

            /**
             * add query side pipeline
             */
            if (transformerPipeline != null) {
                //TODO event name
                rel = transformerPipeline.querySideHandleValue(rel, expContext);
            }

            /**
             * current transform will extact or related toMany and To one to and or not allowed in or
             */
            RelNode opTreeS = ExpTreeToRel.toRelTree(expContext, rel, config, executeConfig);
            long current = System.currentTimeMillis();
            try (Connection connection = dataSource.getConnection()) {
                RelRunner unwrap = connection.unwrap(RelRunner.class);
                log.debug("sql parse: {}", (System.currentTimeMillis() - current));
                try (PreparedStatement preparedStatement = unwrap.prepareStatement(opTreeS)) {
                    log.debug("prepare: {}", (System.currentTimeMillis() - current));
                    ResultSet resultSet = preparedStatement.executeQuery();
                    EntityClassGroup group = expContext.getSchema();

                    List<String> keys = rel.getProjects().stream()
                            .map(x -> (ExpField) x)
                            .map(ExpField::getName)
                            .collect(Collectors.toList());

                    if (keys.isEmpty()) {
                        keys = group.getAllFields().stream().map(x -> x.name()).collect(Collectors.toList());
                    }

                    Collection<IEntityField> fields = group.getAllFields();
                    //Caution toMap is dangerous
                    //yeh if the same relatedCode one2many and many2one will make the same field
                    Map<String, IEntityField> mapping = fields.stream().collect(Collectors.toMap(IEntityField::name, y -> y, (a, b) -> a));

                    List<Record> records = new ArrayList<>();
                    List<Map<Tuple2<String, Long>, Object>> valuesList = new ArrayList<>();
                    while (resultSet.next()) {
                        Map<Tuple2<String, Long>, Object> values = new HashMap<>();
                        keys.forEach(key -> {
                            try {
                                if (key.equalsIgnoreCase("*")) {
                                    fields.forEach(x -> {
                                        try {
                                            String value = resultSet.getString(x.name());
                                            IEntityField targetField;
                                            targetField = mapping.get(x.name());
                                            Tuple2<String, Long> keyTuple = Tuple.of(x.name(), targetField.id());
                                            values.put(keyTuple, value);
                                        } catch (SQLException e) {
                                            e.printStackTrace();
                                        }
                                    });
                                } else {
                                    String value = resultSet.getString(key);
                                    IEntityField targetField;
                                    if (key.startsWith("_")) {
                                        targetField = group.column(key).orElse(null);
                                    } else {
                                        targetField = mapping.get(key);
                                    }
                                    Tuple2<String, Long> keyTuple = Tuple.of(key, targetField.id());
                                    values.put(keyTuple, value);
                                }
                            } catch (SQLException e) {
                                e.printStackTrace();
                            }
                        });

                        valuesList.add(values);
                    }

                    /**
                     * poly is a Map<String, List<Tuple3<Long, String, Long>>>
                     */
                    Object poly = contextService.getAll().get("poly");
                    Map<Long, Object> valuesMapping = new HashMap();
                    Map<Long, EntityClassGroup> groupMapping = new HashMap<>();
                    if (poly instanceof Map) {
                        contextService.getAll().remove("poly");
                        //query poly
                        Map<String, List<Tuple3<Long, String, Long>>> polyMapping = (Map<String, List<Tuple3<Long, String, Long>>>) poly;
                        for (Map.Entry<String, List<Tuple3<Long, String, Long>>> entry : polyMapping.entrySet()) {
                            List<Tuple3<Long, String, Long>> value = entry.getValue();
                            if (!value.isEmpty()) {
                                // query with the whole
                                Tuple3<Long, String, Long> sample = value.get(0);
                                String profileStr = sample._2;
                                Long targetEntityClassId = sample._3;

                                ExpContext polyContext = new ExpContext();
                                Optional<IEntityClass> targetEntityClass = engine.load(targetEntityClassId.toString(), profileStr);
                                if (targetEntityClass.isPresent()) {
                                    EntityClassGroup polyGroup = engine.describe(targetEntityClass.get(), profileStr);
                                    polyContext.setSchema(polyGroup);
                                    contextService.getAll().put("profile", Optional.ofNullable(polyGroup.realProfile()).orElse(""));
                                    Map<String, Object> ctx = new HashMap<>();
                                    ctx.put("only_query", true);
                                    polyContext.withContext(ctx);
                                    List<ExpNode> ids = value.stream().flatMap(x -> ExpValue.from(x._1).stream()).collect(Collectors.toList());
                                    ExpRel query = new ExpQuery().filters(ExpCondition.call(ExpOperator.IN, ExpField.field("id"), ids)).range(1, ids.size());
                                    RelNode polyQuery = ExpTreeToRel.toRelTree(polyContext, query, config, executeConfig);

                                    //target entityclass
                                    List<String> polyKeys = polyGroup.getAllFields().stream().map(x -> x.name()).collect(Collectors.toList());
                                    Collection<IEntityField> polyFields = polyGroup.getAllFields();
                                    //Caution toMap is dangerous
                                    //yeh if the same relatedCode one2many and many2one will make the same field
                                    Map<String, IEntityField> polyFieldsMapping = polyFields.stream().collect(Collectors.toMap(IEntityField::name, y -> y, (a, b) -> a));

                                    /**
                                     * current still depend on contextService to pass profile
                                     */


                                    try (PreparedStatement preparedStatement2 = unwrap.prepareStatement(polyQuery)) {
                                        ResultSet polyResult = preparedStatement2.executeQuery();
                                        contextService.getAll().remove("profile");
                                        while (polyResult.next()) {
                                            long realId = polyResult.getLong("ID");
                                            Map<Tuple2<String, Long>, Object> values = new HashMap<>();
                                            //create values from rs
                                            polyKeys.forEach(key -> {
                                                try {
                                                    if (key.equalsIgnoreCase("*")) {
                                                        polyFields.forEach(x -> {
                                                            try {
                                                                String polyValue = polyResult.getString(x.name());
                                                                IEntityField targetField;
                                                                targetField = polyFieldsMapping.get(x.name());
                                                                Tuple2<String, Long> keyTuple = Tuple.of(x.name(), targetField.id());
                                                                values.put(keyTuple, polyValue);
                                                            } catch (SQLException e) {
                                                                e.printStackTrace();
                                                            }
                                                        });
                                                    } else {
                                                        String polyValue = polyResult.getString(key);
                                                        IEntityField targetField;
                                                        if (key.startsWith("_")) {
                                                            targetField = polyGroup.column(key).orElse(null);
                                                        } else {
                                                            targetField = polyFieldsMapping.get(key);
                                                        }
                                                        Tuple2<String, Long> keyTuple = Tuple.of(key, targetField.id());
                                                        values.put(keyTuple, polyValue);
                                                    }
                                                } catch (SQLException e) {
                                                    e.printStackTrace();
                                                }
                                            });

                                            valuesMapping.put(realId, values);
                                            groupMapping.put(realId, polyGroup);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    //generate New Mapping
                    for (Map<Tuple2<String, Long>, Object> tuple2ObjectMap : valuesList) {

                        Optional<Long> id = tuple2ObjectMap.entrySet().stream().filter(entry -> {
                                    return entry.getKey()._1.equalsIgnoreCase("id");
                                }).map(x -> x.getValue()).map(Object::toString).map(Long::parseLong)
                                .findFirst();
                        Record record = null;
                        if (id.isPresent()) {
                            //do replace
                            Object targetValue = valuesMapping.get(id.get());
                            EntityClassGroup targetGroup = groupMapping.get(id.get());
                            if (targetValue != null && targetGroup != null) {
                                record = targetGroup.toRecordNew((Map<Tuple2<String, Long>, Object>) targetValue, targetGroup.getEntityClass().id());
                                Map<String, Object> retBody = record.toMap(null);
                                List<Tuple2<IEntityField, Object>> tupleList = transformerPipeline
                                        .valueSideHandleValue(targetGroup, retBody, OperationType.RESULT);
                                record.fromMap(getMapFromTuple(tupleList));
                                records.add(record);
                            }
                        }

                        if (record == null) {
                            record = group.toRecordNew(tuple2ObjectMap, group.getEntityClass().id());
                            Map<String, Object> retBody = record.toMap(null);
                            List<Tuple2<IEntityField, Object>> tupleList = transformerPipeline
                                    .valueSideHandleValue(group, retBody, OperationType.RESULT);
                            record.fromMap(getMapFromTuple(tupleList));
                            records.add(record);
                        }
                    }

                    Object showCount = contextService.getAll().get("show_count");
                    Long rowNum = 0L;
                    if (showCount != null) {
                        rowNum = (long) showCount;
                    }

                    List<Record> recordList = mergeRecord(group, records, Collections.emptyMap(), fetcher.getProfile(expContext.getContext()));

                    //TODO
                    contextService.getAll().remove("show_count");
                    DataCollection<Record> retCollection = new DataCollection<>(rowNum.intValue(), recordList);
                    return CompletableFuture.completedFuture(Either.right(retCollection));
                }
            }
        } catch (Throwable e) {
            return exceptional(e);
        }
    }

    private Map<String, Object> getMapFromTuple(List<Tuple2<IEntityField, Object>> tupleList) {
        Map<String, Object> newBody = tupleList.stream()
                .filter(Objects::nonNull).collect(HashMap::new, (m, v) -> m.put(v._1().name(), v._2()), HashMap::putAll);
        return newBody;
    }

    private List<Record> mergeRecord(EntityClassGroup
                                             entityClassGroup, List<Record> records, Map<String, Map<Long, Record>> valueMap, String profile) {

        Set<String> rels = valueMap.keySet();
        return records.stream().map(x -> {
            List<IEntityField> newFields = new LinkedList<>();
            List<Object> values = new LinkedList<>();
            newFields.addAll(x.fields(entityClassGroup.getEntityClass()));
            values.addAll(x.values());
            for (String rel : rels) {
                Optional<Object> idOp = x.get(rel.concat(".id"));

                Optional<IEntityClass> relatedEntityClassOp = entityClassGroup.relatedEntityClass(rel);

                if (idOp.isPresent() && relatedEntityClassOp.isPresent()) {
                    Map<Long, Record> mapping = valueMap.get(rel);
                    if (mapping != null) {
                        Record record = mapping.get(Long.parseLong(idOp.get().toString()));

                        if (record != null) {
                            newFields.addAll(record.fields(rel, relatedEntityClassOp.get()));
                            values.addAll(record.values());
                        } else {
                            log.warn("record is null ");
                        }
                    }
                }
            }

            GeneralRecord generalRecord = new GeneralRecord(newFields);
            generalRecord.setValues(values);
            generalRecord.setId(x.getId());
            generalRecord.setTypeId(x.getTypeId());

            return generalRecord;
        }).collect(Collectors.toList());
    }

    /**
     * TODO
     *
     * @param entityClass
     * @param rel
     * @param context
     * @return
     */
    @Override
    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(IEntityClass entityClass, ExpRel
            rel, Map<String, Object> context) {
        EntityClassGroup group = engine.describe(entityClass, fetcher.getProfile(context));
        ExpContext expContext = new ExpContext();
        expContext.setSchema(group);
        expContext.withContext(context);
        return this.query(expContext, rel);
    }

    @Override
    public <T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel initRel
            , BiFunction<ExpRel, Record, ExpRel> conditionTransformer, Function<Record, T> transformer, Map<String, Object> context) {
        int step = QUERY_STEP;
        return () -> new LazyFetchIterator<>(
                initRel,
                expRel -> {
                    log.debug("Current expRel {}", expRel);
                    Either<QueryResult, DataCollection<Record>> queryResult
                            = query(entityClass, expRel, context)
                            .toCompletableFuture().join();

                    if (queryResult.isRight()) {
                        return queryResult.get().getRows();
                    } else {
                        //how to handle when query is error?
                        return Collections.emptyList();
                    }
                },
                (expRel, last) -> {
                    return conditionTransformer.apply(expRel, last);
                },
                request -> true,
                response -> response.isEmpty() || response.size() < step,
                transformer
        );
    }

    @Override
    public <
            T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel rel, Function<Record, T> transformer,
                                        boolean isLegacy, Map<String, Object> context) {
        AtomicInteger startIndex = new AtomicInteger(1);
        return this.queryIterate(
                entityClass,
                rel,
                (expRel, last) -> {
                    return ExpFactory.withRange(expRel, new ExpRange(startIndex.incrementAndGet(), QUERY_STEP));
                },
                transformer,
                context);
    }

    @Override
    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass, Long
            id, Map<String, Object> context) {
        ExpQuery expQuery = new ExpQuery().filters(ExpCondition.call(ExpOperator.EQUALS, ExpField.ID, ExpValue.from(id)))
                .range(1, 1);
        return this.query(entityClass, expQuery, context).thenApply(x -> {
            boolean right = x.isRight();
            if (right) {
                DataCollection<Record> retCollection = x.get();
                if (retCollection.getRowNum() > 0) {
                    Record record = retCollection.getRows().get(0);
                    Either<QueryOneResult, Record> rightRet = Either.right(record);
                    return rightRet;
                } else {
                    Either<QueryOneResult, Record> notFound = Either.left(QueryOneResult.from(new RuntimeException("Record not found")));
                    return notFound;
                }
            } else {
                QueryResult leftReason = x.getLeft();
                Either<QueryOneResult, Record> dataCollections = Either.left(QueryOneResult.from(new RuntimeException(leftReason.getMessage())));
                return dataCollections;
            }
        });
    }

    /**
     * TODO
     *
     * @param entityClass
     * @param subEntityClass
     * @param id
     * @param context
     * @return
     */
    @Override
    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass
            , IEntityClass subEntityClass, Long id, Map<String, Object> context) {
        return this.findOneById(entityClass, id, context);
    }

    @Override
    public CompletionStage<Integer> count(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        ExpQuery query = (ExpQuery) rel;
        query.range(1, 1);
        return query(entityClass, rel, context).thenApplyAsync(x -> {
            return x.map(DataCollection::getRowNum).getOrElseThrow(str -> {
                QueryResult queryResult = str;
                throw new RuntimeException(queryResult.getMessage());
            });
        }, executorService);
    }

    @Override
    public EntityClassGroup getReader(IEntityClass entityClass, Map<String, Object> context) {
        return engine.describe(entityClass, fetcher.getProfile(context));
    }

    @Override
    public EntityClassEngine getEntityClassEngine() {
        return engine;
    }

    @Override
    public ProfileFetcher getFetcher() {
        return fetcher;
    }

    public void setFetcher(ProfileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public void validate(IEntityClass entityClass, Map<String, Object> body) {

    }

    class FieldCollectors implements ExpVisitor<Void> {

        private Set<String> fields = new HashSet<>();

        @Override
        public Void visit(ExpField field) {
            fields.add(field.getName());
            return null;
        }

        @Override
        public Void visit(ExpCondition rel) {
            rel.getExpNodes().forEach(x -> x.accept(this));
            return null;
        }

        @Override
        public Void visit(ExpValue value) {
            return null;
        }

        @Override
        public Void visit(ExpBi bi) {
            return null;
        }

        @Override
        public Void visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Void visit(ExpRange range) {
            return null;
        }
    }
}
