/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.config;

import com.xforceplus.ultraman.sdk.infra.base.thread.ExecutorHelper;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommonAutoConfiguration {
    @Bean(value={"commonPool"})
    public ExecutorService oqsThreadPool(@Value(value="${xplat.oqsengine.common.pool:20}") int worker, @Value(value="${xplat.oqsengine.common.queue:500}") int queue) {
        int useWorker = worker;
        int useQueue = queue;
        if (useWorker == 0) {
            useWorker = Runtime.getRuntime().availableProcessors() + 1;
        }
        if (useQueue < 500) {
            useQueue = 500;
        }
        return this.buildThreadPool(useWorker, useQueue, "oqs-common", false);
    }

    private ExecutorService buildThreadPool(int worker, int queue, String namePrefix, boolean daemon) {
        return new ThreadPoolExecutor(worker, worker, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queue), ExecutorHelper.buildNameThreadFactory((String)namePrefix, (boolean)daemon), new ThreadPoolExecutor.AbortPolicy());
    }
}

