/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.core.impl;

import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.utils.ExpTreeToRel;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;

public class RemoteDataQueryProvider
implements DataQueryProvider {
    private EntityFacade facade;
    private EntityClassEngine engine;

    public RemoteDataQueryProvider(EntityFacade facade) {
        this.facade = facade;
        this.engine = facade.getEntityClassEngine();
    }

    public List<Object> query(String app, IEntityClass entityClass, String profile, RelDataType dataType, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext) {
        List collect = ops.stream().flatMap(x -> ((List)x.accept((RexVisitor)new ExpTreeToRel.ExpTreeVisitor(fields))).stream()).collect(Collectors.toList());
        List expFields = fields.stream().map(field -> ExpField.field((String)((String)field.getKey()).toLowerCase())).collect(Collectors.toList());
        Long checkedOffset = Optional.ofNullable(offset).orElse(0L);
        Long checkedFetch = Optional.ofNullable(fetch).orElse(20L);
        ExpQuery range = new ExpQuery().filters(collect).project(expFields).range(Integer.valueOf(checkedOffset.intValue()), Integer.valueOf(checkedFetch.intValue()));
        CompletionStage query = this.facade.query(entityClass, (ExpRel)range, Collections.emptyMap());
        Either join = (Either)query.toCompletableFuture().join();
        List<Object> rows = ((DataCollection)join.get()).getRows().stream().map(x -> {
            x.set("id", (Object)x.getId());
            return x.values().toArray();
        }).collect(Collectors.toList());
        return rows;
    }
}

