/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline;

import com.xforceplus.ultraman.adapter.pipeline.OperationType;
import com.xforceplus.ultraman.adapter.pipeline.operation.FieldOperationHandler;
import com.xforceplus.ultraman.adapter.pipeline.operation.TriFunction;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.FieldValidator;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.exception.FieldValidationException;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.transformer.ExpTreeTransformer;
import com.xforceplus.ultraman.sdk.core.rel.legacy.validate.ExpTreeValidator;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Validation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransformerPipeline {
    private final List<FieldOperationHandler> fieldOperationHandlers;
    private final List<FieldValidator<Object>> fieldValidators;
    private final List<ExpTreeTransformer> treeTransformers;
    private final List<ExpTreeValidator> treeValidators;

    public TransformerPipeline(List<FieldOperationHandler> fieldOperationHandlers, List<FieldValidator<Object>> fieldValidators, List<ExpTreeTransformer> treeTransformers, List<ExpTreeValidator> treeValidators) {
        this.fieldOperationHandlers = fieldOperationHandlers;
        this.fieldValidators = fieldValidators;
        this.treeTransformers = treeTransformers;
        this.treeValidators = treeValidators;
    }

    public List<Tuple2<IEntityField, Object>> valueSideHandleValue(EntityClassGroup reader, Map<String, Object> body, OperationType phase) {
        return this.valueSideHandleValue(reader, reader.getEntityClass().id(), body, phase, Collections.emptySet(), Collections.emptySet());
    }

    public List<Tuple2<IEntityField, Object>> valueSideHandleValue(EntityClassGroup reader, long targetId, Map<String, Object> body, OperationType phase) {
        return this.valueSideHandleValue(reader, targetId, body, phase, Collections.emptySet(), Collections.emptySet());
    }

    public List<Tuple2<IEntityField, Object>> valueSideHandleValue(EntityClassGroup reader, long id, Map<String, Object> body, OperationType phase, Set<String> skipOperation, Set<String> skipValidator) {
        return reader.zipValue(body, id).map(tuple -> {
            Object oldValue;
            Object newValue;
            IEntityField field = (IEntityField)tuple._1();
            List<Validation<String, Object>> validations = this.validate(field, newValue = this.pipeline(oldValue = tuple._2(), field, phase, skipOperation), phase, skipValidator);
            if (!validations.isEmpty()) {
                throw new RuntimeException(validations.stream().map(Validation::getError).collect(Collectors.joining(",")));
            }
            return Tuple.of((Object)field, (Object)newValue);
        }).collect(Collectors.toList());
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase, Set<String> skipOperation) {
        return this.fieldOperationHandlers.stream().filter(x -> !skipOperation.contains(x.name())).sorted().map(x -> x).reduce(TriFunction::andThen).map(x -> x.apply(field, value, phase)).orElse(null);
    }

    public void validate(List<IEntityField> fields, Map obj) {
        for (IEntityField field : fields) {
            List validations = this.fieldValidators.stream().map(x -> x.validate(field, obj.get(field.name()), OperationType.CREATE)).filter(Validation::isInvalid).collect(Collectors.toList());
            if (validations.isEmpty()) continue;
            throw new FieldValidationException(field.name(), validations.stream().map(Validation::getError).collect(Collectors.joining(",")));
        }
    }

    private List<Validation<String, Object>> validate(IEntityField field, Object obj, OperationType phase, Set<String> skipValidator) {
        return this.fieldValidators.stream().filter(x -> !skipValidator.contains(x.name())).map(x -> x.validate(field, obj, phase)).filter(Validation::isInvalid).collect(Collectors.toList());
    }

    public ExpRel querySideHandleValue(ExpRel queryTree, ExpContext context) {
        return this.querySideHandleValue(queryTree, context, Collections.emptySet(), Collections.emptySet());
    }

    public ExpRel querySideHandleValue(ExpRel queryTree, ExpContext context, Set<String> skipHandler, Set<String> skipTreeValidator) {
        List orderedTransformers = this.treeTransformers.stream().filter(x -> !skipHandler.contains(x.name())).sorted().collect(Collectors.toList());
        ExpRel tempTree = queryTree;
        for (ExpTreeTransformer treeTransformer : orderedTransformers) {
            tempTree = treeTransformer.transform(context, tempTree);
        }
        ExpRel newTree = tempTree;
        this.treeValidators.stream().filter(x -> !skipTreeValidator.contains(x.name())).forEach(x -> x.validate(context, newTree).getOrElseThrow(RuntimeException::new));
        return newTree;
    }
}

