/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation;

import com.xforceplus.ultraman.adapter.pipeline.operation.FieldOperationHandler;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFieldValueOperationHandler
implements FieldOperationHandler {
    private Logger logger = LoggerFactory.getLogger(DefaultFieldValueOperationHandler.class);

    @Override
    public String name() {
        return "defaultvalue";
    }

    @Override
    public boolean require(IEntityField field, Object obj) {
        String dictId = field.dictId();
        String defaultValue = field.defaultValue();
        boolean shouldUsingDefault = false;
        switch (field.type()) {
            case ENUM: {
                if (StringUtils.isEmpty((CharSequence)dictId) || StringUtils.isEmpty((CharSequence)defaultValue)) break;
                shouldUsingDefault = true;
                break;
            }
            case LONG: 
            case DATETIME: 
            case DECIMAL: 
            case BOOLEAN: 
            case STRING: 
            case STRINGS: {
                if (StringUtils.isEmpty((CharSequence)defaultValue)) break;
                shouldUsingDefault = true;
                break;
            }
        }
        return shouldUsingDefault;
    }

    @Override
    public Object onCreate(IEntityField field, Object o) {
        if (o == null) {
            return field.defaultValue();
        }
        return o;
    }

    @Override
    public Object onUpdate(IEntityField field, Object o) {
        return o;
    }

    @Override
    public Object onUnHandle(IEntityField field, Object o) {
        this.logger.error("unhandle {} on Default field stage", o);
        return null;
    }
}

