/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation;

import com.google.common.collect.Sets;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.pipeline.operation.FieldOperationHandler;
import com.xforceplus.ultraman.metadata.constants.SystemField;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class FixedDefaultSystemOperationHandler
implements FieldOperationHandler {
    private boolean isOverride = false;
    private Map<String, Supplier<Object>> fixed = new HashMap<String, Supplier<Object>>();
    private static final Set<String> UPDATE_FIELDS = Sets.newHashSet((Object[])new String[]{"update_time", "update_user_id", "update_user_name"});

    public FixedDefaultSystemOperationHandler(ContextService contextService, boolean isOverride) {
        this.fixed.put(SystemField.TENANT_ID.getName(), () -> (String)contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY));
        this.fixed.put(SystemField.CREATE_TIME.getName(), () -> LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
        this.fixed.put(SystemField.CREATE_USER_NAME.getName(), () -> (String)contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME));
        this.fixed.put(SystemField.CREATE_USER_ID.getName(), () -> (Long)contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ID));
        this.fixed.put(SystemField.UPDATE_TIME.getName(), () -> LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
        this.fixed.put(SystemField.UPDATE_USER_ID.getName(), () -> (Long)contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ID));
        this.fixed.put(SystemField.UPDATE_USER_NAME.getName(), () -> (String)contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME));
        this.fixed.put(SystemField.TENANT_CODE.getName(), () -> (String)contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY));
        this.isOverride = isOverride;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String name() {
        return "system";
    }

    @Override
    public boolean require(IEntityField field, Object obj) {
        return this.isSystemDefaultField(field);
    }

    @Override
    public Object onCreate(IEntityField field, Object o) {
        if (this.isOverride && o != null) {
            if (o instanceof String) {
                if (!StringUtils.isEmpty((CharSequence)((String)o))) {
                    return o;
                }
            } else {
                return o;
            }
        }
        return this.fixed.get(field.name()).get();
    }

    @Override
    public Object onUpdate(IEntityField field, Object o) {
        if (this.isOverride && o != null) {
            if (o instanceof String) {
                if (!StringUtils.isEmpty((CharSequence)((String)o))) {
                    return o;
                }
            } else {
                return o;
            }
        }
        if (UPDATE_FIELDS.contains(field.name())) {
            return this.fixed.get(field.name()).get();
        }
        return null;
    }

    @Override
    public Object onUnHandle(IEntityField field, Object o) {
        return null;
    }

    private boolean isSystemDefaultField(IEntityField field) {
        String fieldName = field.name();
        return this.fixed.containsKey(fieldName);
    }
}

