/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation;

import com.xforceplus.ultraman.adapter.pipeline.operation.FieldOperationHandler;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.values.DateTimeValue;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TypeConvertOperationHandler
implements FieldOperationHandler {
    private final DictService dictService;

    public TypeConvertOperationHandler(DictService dictService) {
        this.dictService = dictService;
    }

    @Override
    public boolean require(IEntityField field, Object obj) {
        return obj != null;
    }

    @Override
    public Object onCreate(IEntityField field, Object o) {
        return this.convertToString(field, o);
    }

    @Override
    public Object onUpdate(IEntityField field, Object o) {
        if (o != null && o == EmptyValue.emptyValue) {
            return o;
        }
        return this.convertToString(field, o);
    }

    private String convertToString(IEntityField field, Object o) {
        FieldType fieldType = field.type();
        if (o instanceof BigDecimal) {
            if (fieldType == FieldType.LONG) {
                return Long.toString(((BigDecimal)o).longValueExact());
            }
            return ((BigDecimal)o).toPlainString();
        }
        if (o instanceof LocalDateTime) {
            if (fieldType == FieldType.DATETIME) {
                return Long.toString(new DateTimeValue(null, (LocalDateTime)o).valueToLong());
            }
            return o.toString();
        }
        if (o instanceof String) {
            String dictId;
            if (fieldType == FieldType.ENUM && StringUtils.isNotEmpty((CharSequence)(dictId = field.dictId()))) {
                List dictItems = this.dictService.findDictItems(dictId, null);
                Optional<DictItem> first = dictItems.stream().filter(x -> x.getText().equals(o) || x.getValue().equals(o)).findFirst();
                return first.map(x -> x.getValue()).orElse((String)o);
            }
            return o.toString();
        }
        return o.toString();
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String name() {
        return "typedresult";
    }
}

