/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation.validator;

import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ConsistFieldValidator;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.service.DictService;
import io.vavr.control.Validation;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValueValidator
implements ConsistFieldValidator<Object> {
    private Logger logger = LoggerFactory.getLogger(EnumValueValidator.class);
    private ValidatorConfig config;
    private DictService dictService;

    @Deprecated
    public EnumValueValidator() {
        this.config = null;
    }

    public EnumValueValidator(ValidatorConfig config, DictService dictService) {
        this.config = config;
        this.dictService = dictService;
    }

    @Override
    public Validation<String, Object> validate(IEntityField field, Object obj) {
        if (obj != null && field.type().equals((Object)FieldType.ENUM)) {
            if (obj == EmptyValue.emptyValue || "null".equalsIgnoreCase(obj.toString()) || StringUtils.isEmpty((CharSequence)obj.toString())) {
                return Validation.valid((Object)obj);
            }
            List dictItems = this.dictService.findDictItems(field.dictId(), null);
            if (field.config().isSplittable() && !StringUtils.isEmpty((CharSequence)field.config().getDelimiter())) {
                String value = obj.toString();
                String[] terms = value.split(field.config().getDelimiter());
                return Stream.of(terms).allMatch(term -> dictItems.stream().anyMatch(dictItem -> dictItem.getValue().equals(term))) ? Validation.valid((Object)obj) : this.inValidate(obj, this.config, String.format("[Validation] %s contains invalid enum value on field [%s]", obj, field.name()));
            }
            return dictItems.stream().anyMatch(dictItem -> dictItem.getValue().equals(obj)) ? Validation.valid((Object)obj) : this.inValidate(obj, this.config, String.format("[Validation] %s is invalid enum value on field [%s]", obj, field.name()));
        }
        return Validation.valid((Object)obj);
    }

    @Override
    public String name() {
        return "enum";
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

