/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation.validator;

import com.xforceplus.ultraman.adapter.pipeline.OperationType;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.FieldValidator;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.helper.ConvertHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxLengthValidator
implements FieldValidator<Object> {
    private Logger logger = LoggerFactory.getLogger(MaxLengthValidator.class);
    private ValidatorConfig config;

    @Deprecated
    public MaxLengthValidator() {
        this.config = null;
    }

    public MaxLengthValidator(ValidatorConfig config) {
        this.config = config;
    }

    private Either<Tuple2<Long, Long>, Boolean> isExceed(IEntityField field, Object obj) {
        if (obj == null) {
            return Either.right((Object)false);
        }
        if (field.config() != null) {
            long max = field.config().getMax();
            if (max < 0L) {
                return Either.right((Object)false);
            }
            String convert = ConvertHelper.convert((Object)obj);
            return (long)convert.length() > max ? Either.left((Object)Tuple.of((Object)convert.length(), (Object)max)) : Either.right((Object)false);
        }
        return Either.right((Object)false);
    }

    @Override
    public String name() {
        return "maxlength";
    }

    @Override
    public Validation<String, Object> validate(IEntityField field, Object obj, OperationType phase) {
        if (phase == OperationType.REPLACE || phase == OperationType.CREATE) {
            return (Validation)this.isExceed(field, obj).map(x -> Validation.valid((Object)obj)).getOrElseGet(x -> {
                String errorMsg = String.format("[Validation] [%s] exceed max length , actual length %s , config length %s ", field.name(), x._1(), x._2());
                return this.inValidate(obj, this.config, errorMsg);
            });
        }
        return Validation.valid((Object)obj);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

