/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation.validator;

import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ConsistFieldValidator;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import io.vavr.control.Validation;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegxValidator
implements ConsistFieldValidator<Object> {
    private Logger logger = LoggerFactory.getLogger(RegxValidator.class);
    private ValidatorConfig config;

    @Deprecated
    public RegxValidator() {
        this.config = null;
    }

    public RegxValidator(ValidatorConfig config) {
        this.config = config;
    }

    @Override
    public Validation<String, Object> validate(IEntityField field, Object obj) {
        if (obj != null && !StringUtils.isEmpty((CharSequence)field.config().getValidateRegexString())) {
            Pattern pattern = Pattern.compile(field.config().getValidateRegexString());
            if (this.isSplittable(field)) {
                String[] term = obj.toString().split(field.config().getValidateRegexString());
                return Stream.of(term).allMatch(x -> this.checkRegex(pattern, (String)x)) ? Validation.valid((Object)obj) : this.inValidate(obj, this.config, String.format("[Validation] %s is not satisfied with regex %s on field [%s]", obj, field.config().getValidateRegexString(), field.name()));
            }
            return this.checkRegex(pattern, obj.toString()) ? Validation.valid((Object)obj) : this.inValidate(obj, this.config, String.format("[Validation] %s is not satisfied with regex %s on field [%s]", obj, field.config().getValidateRegexString(), field.name()));
        }
        return Validation.valid((Object)obj);
    }

    private boolean checkRegex(Pattern pattern, String obj) {
        return pattern.matcher(obj).matches();
    }

    @Override
    public String name() {
        return "regex";
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

