/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation.validator;

import com.xforceplus.ultraman.adapter.pipeline.OperationType;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.FieldValidator;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import io.vavr.control.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredValidator
implements FieldValidator<Object> {
    private Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private ValidatorConfig config;

    @Deprecated
    public RequiredValidator() {
        this.config = null;
    }

    public RequiredValidator(ValidatorConfig config) {
        this.config = config;
    }

    private boolean isRequired(IEntityField field) {
        return field.config() != null && field.config().isRequired() && !field.config().isSystem();
    }

    @Override
    public String name() {
        return "required";
    }

    @Override
    public Validation<String, Object> validate(IEntityField field, Object obj, OperationType phase) {
        if (phase == OperationType.REPLACE || phase == OperationType.CREATE) {
            return this.isRequired(field) && (obj == null || obj == EmptyValue.emptyValue) ? this.inValidate(obj, this.config, String.format("[Validation] Required field [%s] must be present", field.name())) : Validation.valid((Object)obj);
        }
        return Validation.valid((Object)obj);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

