/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.pipeline.operation.validator;

import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ConsistFieldValidator;
import com.xforceplus.ultraman.adapter.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import io.vavr.control.Validation;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCheckValidator
implements ConsistFieldValidator<Object> {
    private Logger logger = LoggerFactory.getLogger(TypeCheckValidator.class);
    private ValidatorConfig config;

    @Deprecated
    public TypeCheckValidator() {
        this.config = null;
    }

    public TypeCheckValidator(ValidatorConfig config) {
        this.config = config;
    }

    @Override
    public Validation<String, Object> validate(IEntityField field, Object obj) {
        if (obj != null) {
            if (obj == EmptyValue.emptyValue) {
                return Validation.valid((Object)obj);
            }
            if (field.config().isSplittable() && !StringUtils.isEmpty((CharSequence)field.config().getDelimiter())) {
                String value = obj.toString();
                String[] terms = value.split(field.config().getDelimiter());
                return Stream.of(terms).allMatch(arg_0 -> ((FieldType)field.type()).canParseFrom(arg_0)) ? Validation.valid((Object)obj) : this.inValidate(obj, this.config, String.format("[Validation] %s is not satisfied to type %s on field [%s]", obj, field.type(), field.name()));
            }
            return this.checkType(field.type(), obj) ? Validation.valid((Object)obj) : this.inValidate(obj, this.config, String.format("[Validation] %s is not satisfied to type %s on field [%s]", obj, field.type(), field.name()));
        }
        return Validation.valid((Object)obj);
    }

    private boolean checkType(FieldType type, Object obj) {
        return type.canParseFrom(obj.toString());
    }

    @Override
    public String name() {
        return "typed";
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

