/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.core.impl;

import com.google.common.collect.Sets;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tenant.data.auth.dto.Category;
import com.xforceplus.tenant.data.auth.dto.RuleDTO;
import com.xforceplus.tenant.data.auth.dto.Status;
import com.xforceplus.tenant.data.auth.exception.ClientRuleException;
import com.xforceplus.tenant.data.auth.store.ClientDataRuleProvider;
import com.xforceplus.ultraman.adapter.utils.EntityClassGroupEx;
import com.xforceplus.ultraman.adapter.utils.ExpFactoryEx;
import com.xforceplus.ultraman.adapter.utils.IEntityClassHelper;
import com.xforceplus.ultraman.adapter.utils.RelTreeHelper;
import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.extension.oqsengine.v1.EntityGrpcExecutor;
import com.xforceplus.ultraman.extension.oqsengine.v1.model.StickySession;
import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldConditionUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.QueryFieldsUp;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByCondition;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByTree;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.exception.PermissionFatalException;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.CreateOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.DeleteOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.QueryOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.QueryResult;
import com.xforceplus.ultraman.sdk.core.facade.result.ResultStatus;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateMultiResult;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateOneResult;
import com.xforceplus.ultraman.sdk.core.facade.result.UpdateResult;
import com.xforceplus.ultraman.sdk.core.pipeline.OperationType;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpVisitor;
import com.xforceplus.ultraman.sdk.core.rel.legacy.visitor.OrCheckVisitor;
import com.xforceplus.ultraman.sdk.core.rel.tree.BinaryTreeNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.builder.TreeBuilder;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.ConditionNode;
import com.xforceplus.ultraman.sdk.core.transaction.OqsTransactionManager;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import com.xforceplus.ultraman.sdk.infra.utils.CompletableFutureUtils;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class EntityFacadeImpl
implements EntityFacade {
    private static final Logger log = LoggerFactory.getLogger(EntityFacadeImpl.class);
    private EntityGrpcExecutor entityServiceExecutor;
    private ExecutionConfig executionConfig;
    private EntityClassEngine entityClassEngine;
    private TransformerPipeline transformerPipeline;
    private TreeBuilder treeBuilder;
    private RetryConfig permissionRetryConfig;
    private ExecutorService executorService;
    @Value(value="${xplat.oqsengine.sdk.tenant.retry:10}")
    private int maxAttempts = 10;
    @Value(value="${xplat.oqsengine.sdk.tenant.failOnEx:false}")
    private boolean failOnEx = false;
    @Value(value="${xplat.oqsengine.sdk.tenant.failOnIOEx:false}")
    private boolean failOnIOEx = false;
    @Autowired(required=false)
    private IDataRuleProvider dataRuleProvider;
    @Autowired(required=false)
    private ClientDataRuleProvider clientDataRuleProvider;

    public EntityFacadeImpl(EntityGrpcExecutor entityServiceExecutor, ExecutionConfig executionConfig, EntityClassEngine entityClassEngine, ExecutorService executorService, TransformerPipeline transformerPipeline) {
        this.entityServiceExecutor = entityServiceExecutor;
        this.executionConfig = executionConfig;
        this.entityClassEngine = entityClassEngine;
        this.executorService = executorService;
        this.transformerPipeline = transformerPipeline;
    }

    public Optional<IEntityClass> load(String boId, String profile) {
        return Optional.empty();
    }

    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return Optional.empty();
    }

    public Optional<IEntityClass> loadByCode(String bocode, String profile) {
        return Optional.empty();
    }

    public Optional<IEntityClass> loadByCode(String bocode, String profile, String version) {
        return Optional.empty();
    }

    public CompletionStage<Either<CreateOneResult, Long>> create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<CreateMultiResult, Integer>> createMulti(IEntityClass entityClass, Stream<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<CreateMultiResult, Integer>> createMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<DeleteOneResult, Integer>> deleteOne(IEntityClass entityClass, Long id, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<DeleteMultiResult, Integer>> deleteMulti(IEntityClass entityClass, List<Long> id, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateMultiResult, Integer>> updateMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateMultiResult, Integer>> replaceMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateResult, Integer>> updateByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<UpdateResult, Integer>> replaceByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    public String getTransId(Map<String, Object> context) {
        return (String)context.get(ContextKeys.StringKeys.TRANSACTION_KEY.name());
    }

    public StickySession getStickySession(Map<String, Object> context) {
        return Optional.ofNullable(context.get(OqsTransactionManager.StickySession.STICKY_SESSION.name())).map(x -> (String)x).map(StickySession::new).orElse(null);
    }

    public Boolean isSimplify(Map<String, Object> context) {
        return Optional.ofNullable(context.get("simplify")).map(x -> (Boolean)x).orElse(false);
    }

    private ExpRel dealProjects(ExpRel rel) {
        List projects = rel.getProjects();
        Set relatedCodes = projects.stream().filter(x -> x instanceof ExpField && ((ExpField)x).getName().startsWith("_")).map(x -> {
            String[] parts = ((ExpField)x).getName().split("\\.");
            if (parts.length > 1) {
                return parts[0].substring(1);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        Set existsCodes = projects.stream().filter(x -> x instanceof ExpField && ((ExpField)x).getName().endsWith(".id")).map(x -> ((ExpField)x).getName().split("\\.")[0]).collect(Collectors.toSet());
        List needToAdd = relatedCodes.stream().filter(x -> !existsCodes.contains(x)).map(x -> ExpField.field((String)(x + ".id"))).collect(Collectors.toList());
        return rel.mergeOrProjects(needToAdd);
    }

    private Map<String, List<Tuple2<String, String>>> dealExpRel(ExpRel expRel) {
        List projects = expRel.getProjects();
        if (projects != null) {
            Map<String, List<Tuple2<String, String>>> groupedList = projects.stream().filter(x -> x instanceof ExpField).map(x -> (ExpField)x).filter(x -> x.getName().startsWith("_")).map(x -> {
                String name = x.getName();
                String subName = name.substring(1);
                if (subName.contains(".")) {
                    String[] split = subName.split("\\.");
                    return Tuple.of((Object)split[0], (Object)split[1]);
                }
                return Tuple.of((Object)subName, (Object)"*");
            }).collect(Collectors.groupingBy(Tuple2::_1));
            return groupedList;
        }
        return Collections.emptyMap();
    }

    private Map<Long, String> collectEntityClassIdMapping(SelectByCondition selectByCondition, EntityClassGroup group) {
        if (selectByCondition == null) {
            return Collections.emptyMap();
        }
        ConditionsUp conditions = selectByCondition.getConditions();
        List fieldsConditionList = conditions.getFieldsList();
        Long mainId = group.getEntityClass().id();
        HashMap<Long, String> idSet = new HashMap<Long, String>();
        idSet.put(mainId, "");
        Map<Long, String> conditionIds = fieldsConditionList.stream().map(FieldConditionUp::getRelationId).map(x -> {
            if (x > 0L) {
                Optional relationOp = group.relation(x.longValue());
                if (relationOp.isPresent()) {
                    IRelation relation = (IRelation)relationOp.get();
                    return Tuple.of((Object)relation.getEntityClassId(), (Object)relation.getName());
                }
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.METADATA_SDK_CONFIG_ERROR, () -> String.format("Relation %s Missing in %s", x, group.getEntityClass().code()));
                return null;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(x -> (Long)x._1, y -> (String)y._2));
        idSet.putAll(conditionIds);
        return idSet;
    }

    private ExpRel getPermissionTreeConditionLegacy(Map<Long, String> involvedIdsMapping, ExpContext expContext, String profile) {
        try {
            List rules = Collections.emptyList();
            try {
                rules = Optional.ofNullable(this.clientDataRuleProvider.currentUserDataRules()).orElseGet(Collections::emptyList);
            }
            catch (Throwable throwable) {
                if (this.failOnEx) {
                    log.warn("fast fail on permission error");
                    throw new PermissionFatalException();
                }
                if (throwable instanceof ClientRuleException) {
                    if (throwable.getCause() != null) {
                        if (throwable.getCause() instanceof IOException) {
                            if (this.failOnIOEx) {
                                log.warn("fast fail on permission IO error");
                                throw new PermissionFatalException();
                            }
                            log.error("permission process error got IO exception try to retry");
                            Retry permission = Retry.of((String)"permission", (RetryConfig)this.permissionRetryConfig);
                            rules = (List)permission.executeSupplier(() -> this.clientDataRuleProvider.currentUserDataRules());
                        }
                        throw throwable;
                    }
                    throw throwable;
                }
                throw throwable;
            }
            Set filteredRules = rules.stream().map(x -> {
                if (x.getStatus() == Status.VALID && involvedIdsMapping.containsKey(x.getMetaDataId()) && x.getCategory() == Category.SQL) {
                    return Tuple.of((Object)Optional.ofNullable(involvedIdsMapping.get(x.getMetaDataId())).orElse(""), (Object)x);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            List conditions = filteredRules.stream().map(x -> {
                BinaryTreeNode nodeTree = this.treeBuilder.build(((RuleDTO)x._2).getRuleConditions(), (String)x._1());
                ExpCondition condition = ExpFactoryEx.createFrom((BinaryTreeNode<ConditionNode>)nodeTree);
                return condition;
            }).collect(Collectors.toList());
            ExpCondition condition = ExpCondition.call((ExpOperator)ExpOperator.AND, conditions);
            ExpQuery expQuery = new ExpQuery().filters((ExpNode)condition);
            ExpRel permissionExpRel = this.transformerPipeline.querySideHandleValue((ExpRel)expQuery, expContext, Collections.singleton("calcite"), Collections.singleton("range"));
            return permissionExpRel;
        }
        catch (Exception ex) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AcquirePermission", (Throwable)ex);
            if (ex instanceof PermissionFatalException) {
                throw ex;
            }
            return null;
        }
    }

    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(ExpContext expContext, ExpRel inputQuery) {
        ExpRel rel;
        EntityClassGroup group = expContext.getSchema();
        String transId = this.getTransId(expContext.getContext());
        StickySession stickySession = this.getStickySession(expContext.getContext());
        String profile = this.getProfile(expContext.getContext());
        Boolean isSimplify = this.isSimplify(expContext.getContext());
        ExpRel expRel = rel = this.dealProjects(inputQuery);
        if (this.transformerPipeline != null) {
            expRel = this.transformerPipeline.querySideHandleValue(rel, expContext);
        }
        Map<String, List<Tuple2<String, String>>> mappingSearch = this.dealExpRel(expRel);
        Map<String, IRelation> relationMapping = group.getAllRelations().stream().filter(x -> x.getRelationType().equalsIgnoreCase(MetadataRelationType.TO_ONE.name())).collect(Collectors.toMap(x -> x.getName(), x -> x, (a, b) -> a));
        OrCheckVisitor orCheckVisitor = new OrCheckVisitor();
        expRel.accept((ExpVisitor)orCheckVisitor);
        if (!orCheckVisitor.isHasOr()) {
            SelectByCondition selectByCondition = RelTreeHelper.relToCondition(expRel, expContext, profile);
            SelectByTree treeCondition = null;
            ExpRel permissionExpRel = this.getPermissionTreeCondition(this.collectEntityClassIdMapping(selectByCondition, group), expContext, profile);
            if (permissionExpRel != null) {
                OrCheckVisitor newOrCheckVisitor = new OrCheckVisitor();
                permissionExpRel.accept((ExpVisitor)newOrCheckVisitor);
                if (newOrCheckVisitor.isHasOr()) {
                    treeCondition = RelTreeHelper.relToTree(permissionExpRel, expContext, this.entityClassEngine, profile);
                } else {
                    selectByCondition = RelTreeHelper.relToCondition(expRel.mergeAnd(permissionExpRel), expContext, profile);
                }
            }
            if (selectByCondition == null) {
                DataCollection emptyResult = new DataCollection(Integer.valueOf(0), Collections.emptyList());
                Either eitherResult = Either.right((Object)emptyResult);
                return CompletableFuture.completedFuture(eitherResult);
            }
            SelectByCondition finalSelectByCondition = selectByCondition;
            return this.entityServiceExecutor.selectByConditions(selectByCondition, treeCondition, stickySession, transId, profile, isSimplify.booleanValue()).thenComposeAsync(queryResult -> this.handleSubQuery(group, (OperationResult)queryResult, mappingSearch, relationMapping, stickySession, profile, transId, isSimplify, finalSelectByCondition.getQueryFieldsList()), this.executorService);
        }
        SelectByTree selectByTree = RelTreeHelper.relToTree(expRel, expContext, this.entityClassEngine, profile);
        return this.entityServiceExecutor.selectByTree(RelTreeHelper.relToTree(expRel, expContext, this.entityClassEngine, profile), stickySession, transId, profile, isSimplify.booleanValue()).thenComposeAsync(queryResult -> this.handleSubQuery(group, (OperationResult)queryResult, mappingSearch, relationMapping, stickySession, profile, transId, isSimplify, selectByTree.getProjects().getQueryFieldsList()), this.executorService);
    }

    private ResultStatus.OriginStatus getOriginStatus(OperationResult operationResult) {
        ResultStatus.OriginStatus originStatus;
        String originStatusString = operationResult.getOriginStatus();
        try {
            originStatus = ResultStatus.OriginStatus.valueOf((String)originStatusString);
        }
        catch (Exception ex) {
            originStatus = operationResult.getCode() == OperationResult.Code.OK ? ResultStatus.OriginStatus.SUCCESS : ResultStatus.OriginStatus.UNKNOWN;
        }
        return originStatus;
    }

    private List<Record> toResult(EntityClassGroup group, List<EntityUp> entityUps, List<Long> ids) {
        return entityUps.stream().map(entityUp -> {
            Record record = EntityClassGroupEx.toRecord(group, entityUp);
            Map retBody = record.toMap(null);
            List tupleList = this.transformerPipeline.valueSideHandleValue(group, retBody, OperationType.RESULT);
            record.fromMap(this.getMapFromTuple(tupleList));
            return record;
        }).collect(Collectors.toList());
    }

    private Map<String, Object> getMapFromTuple(List<Tuple2<IEntityField, Object>> tupleList) {
        Map newBody = tupleList.stream().filter(Objects::nonNull).collect(HashMap::new, (m, v) -> m.put(((IEntityField)v._1()).name(), v._2()), HashMap::putAll);
        return newBody;
    }

    private Either<QueryResult, DataCollection<Record>> handleQueryResult(EntityClassGroup group, OperationResult queryResult) {
        ResultStatus.OriginStatus originStatus = this.getOriginStatus(queryResult);
        if (queryResult.getCode() == OperationResult.Code.OK) {
            try {
                List<Record> records = this.toResult(group, queryResult.getQueryResultList(), queryResult.getIdsList());
                return Either.right((Object)DataCollection.from((Tuple2)Tuple.of((Object)queryResult.getTotalRow(), records)));
            }
            catch (Exception ex) {
                throw new CompletionException(ex);
            }
        }
        return Either.left((Object)new QueryResult(originStatus, queryResult.getMessage()));
    }

    private CompletableFuture<Either<QueryResult, DataCollection<Record>>> handleSubQuery(EntityClassGroup group, OperationResult queryResult, Map<String, List<Tuple2<String, String>>> mappingSearch, Map<String, IRelation> relationMapping, StickySession stickySession, String profile, String transId, Boolean isSimplify, List<QueryFieldsUp> projects) {
        Either<QueryResult, DataCollection<Record>> mainResult = this.handleQueryResult(group, queryResult);
        if (mainResult.isRight() && ((DataCollection)mainResult.get()).getRowNum() > 0) {
            List records = ((DataCollection)mainResult.get()).getRows();
            List sequenceResult = Sets.intersection(mappingSearch.keySet(), relationMapping.keySet()).stream().map(x -> {
                IRelation relation = (IRelation)relationMapping.get(x);
                long entityClassId = relation.getEntityClassId();
                Optional<IEntityClass> entityClassOp = this.load(String.valueOf(entityClassId), profile);
                if (entityClassOp.isPresent()) {
                    EntityClassGroup subGroup = this.entityClassEngine.describe(entityClassOp.get(), profile);
                    CompletionStage<List<EntityUp>> futureEntityUps = this.queryLeftJoin(subGroup, records, x.concat(".id"), stickySession, transId, profile, isSimplify, projects);
                    CompletionStage mapCompletionStage = futureEntityUps.toCompletableFuture().thenApply(entityUps -> {
                        Map<Long, Record> recordsMapping = entityUps.stream().map(leftJoinOne -> EntityClassGroupEx.toRecord(group, leftJoinOne)).collect(Collectors.toMap(Record::getId, r -> r, (a, b) -> a));
                        return Tuple.of((Object)x, recordsMapping);
                    });
                    return mapCompletionStage;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            CompletableFuture sequence = CompletableFutureUtils.sequence(sequenceResult);
            return sequence.thenApply(seq -> {
                Map<String, Map<Long, Record>> valueMap = seq.stream().collect(Collectors.toMap(tuple -> (String)tuple._1, tuple -> (Map)tuple._2, (a1, a2) -> a1));
                return Either.right((Object)DataCollection.from((Tuple2)Tuple.of((Object)queryResult.getTotalRow(), this.mergeRecord(group, records, valueMap, profile))));
            });
        }
        return CompletableFuture.completedFuture(mainResult);
    }

    private List<Record> mergeRecord(EntityClassGroup entityClassGroup, List<Record> records, Map<String, Map<Long, Record>> valueMap, String profile) {
        Set<String> rels = valueMap.keySet();
        return records.stream().map(x -> {
            LinkedList newFields = new LinkedList();
            LinkedList values = new LinkedList();
            newFields.addAll(x.fields(entityClassGroup.getEntityClass()));
            values.addAll(x.values());
            for (String rel : rels) {
                Map mapping;
                Optional idOp = x.get(rel.concat(".id"));
                Optional relatedEntityClassOp = entityClassGroup.relatedEntityClass(rel);
                if (!idOp.isPresent() || !relatedEntityClassOp.isPresent() || (mapping = (Map)valueMap.get(rel)) == null) continue;
                Record record = (Record)mapping.get(Long.parseLong(idOp.get().toString()));
                if (record != null) {
                    newFields.addAll(record.fields(rel, (IEntityClass)relatedEntityClassOp.get()));
                    values.addAll(record.values());
                    continue;
                }
                log.warn("record is null ");
            }
            GeneralRecord generalRecord = new GeneralRecord(newFields);
            generalRecord.setValues(values);
            generalRecord.setId(x.getId());
            generalRecord.setTypeId(x.getTypeId());
            return generalRecord;
        }).collect(Collectors.toList());
    }

    private List<String> findRelatedIds(List<Record> result, String code) {
        List<String> idsStr = result.stream().map(record -> record.get(code)).filter(Optional::isPresent).map(x -> x.get().toString()).collect(Collectors.toList());
        return idsStr;
    }

    private CompletionStage<List<EntityUp>> queryLeftJoin(EntityClassGroup entityClassGroup, List<Record> result, String code, StickySession stickySession, String transId, String profile, boolean isSimplify, List<QueryFieldsUp> projects) {
        List relatedIds = this.findRelatedIds(result, code).stream().collect(Collectors.toList());
        Long id = entityClassGroup.field("id").map(IEntityField::id).orElse(1L);
        ConditionsUp conditionsUp = ConditionsUp.newBuilder().addFields(FieldConditionUp.newBuilder().setOperation(FieldConditionUp.Op.in).addAllValues(relatedIds).setField(FieldUp.newBuilder().setId(id.longValue()).setIdentifier(true).setFieldType(FieldType.LONG.getType()).build()).build()).build();
        SelectByCondition select = SelectByCondition.newBuilder().addAllQueryFields(projects).setEntity(IEntityClassHelper.toEntityUp(entityClassGroup.getEntityClass())).setConditions(conditionsUp).setPageSize(result.size()).setPageNo(1).build();
        CompletionStage leftJoin = this.entityServiceExecutor.selectByConditions(select, null, stickySession, transId, profile, isSimplify);
        try {
            CompletionStage<List<EntityUp>> finalResult = leftJoin.thenApplyAsync(x -> {
                if (x.getCode() == OperationResult.Code.OK) {
                    return x.getQueryResultList();
                }
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.CONDITION_QUERY_ERROR, (String)x.getMessage());
                return Collections.emptyList();
            }, this.executorService);
            return finalResult;
        }
        catch (Exception ex) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.CONDITION_QUERY_ERROR, (String)entityClassGroup.getEntityClass().code(), (Throwable)ex);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    private ExpRel getPermissionTreeCondition(Map<Long, String> involvedIdsMapping, ExpContext expContext, String profile) {
        if (this.executionConfig.getUsePermission().booleanValue()) {
            if (this.clientDataRuleProvider != null) {
                return this.getPermissionTreeConditionLegacy(involvedIdsMapping, expContext, profile);
            }
            if (this.dataRuleProvider != null) {
                return this.getPermissionTreeConditionNew(involvedIdsMapping, expContext, profile);
            }
        }
        return null;
    }

    private ExpRel getPermissionTreeConditionNew(Map<Long, String> involvedIdsMapping, ExpContext expContext, String profile) {
        try {
            Map<Long, List> rules = new HashMap();
            rules = Optional.ofNullable(this.dataRuleProvider.currentUserDataRules(new ArrayList<Long>(involvedIdsMapping.keySet()))).orElseGet(Collections::emptyMap);
            ArrayList conditions = new ArrayList();
            rules.forEach((k, v) -> {
                ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v, (String)involvedIdsMapping.get(k));
                conditions.add(condition);
            });
            ExpQuery expQuery = new ExpQuery().filters(conditions);
            ExpRel permissionExpRel = this.transformerPipeline.querySideHandleValue((ExpRel)expQuery, expContext, Collections.singleton("calcite"), Collections.singleton("range"));
            return permissionExpRel;
        }
        catch (Throwable throwable) {
            LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (String)"AcquirePermission", (Throwable)throwable);
            return null;
        }
    }

    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        EntityClassGroup group = this.getReader(entityClass, context);
        ExpContext expContext = new ExpContext().withContext(context).setSchema(group);
        return this.query(expContext, rel);
    }

    public <T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel initRel, BiFunction<ExpRel, Record, ExpRel> conditionTransformer, Function<Record, T> transformer, Map<String, Object> context) {
        return null;
    }

    public <T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel rel, Function<Record, T> transformer, boolean isLegacy, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass, Long id, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass, IEntityClass subEntityClass, Long id, Map<String, Object> context) {
        return null;
    }

    public CompletionStage<Integer> count(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        return null;
    }

    public EntityClassGroup getReader(IEntityClass entityClass, Map<String, Object> context) {
        String profile = this.getProfile(context);
        return this.entityClassEngine.describe(entityClass, profile);
    }

    private String getProfile(Map<String, Object> context) {
        return "";
    }

    public EntityClassEngine getEntityClassEngine() {
        return this.entityClassEngine;
    }

    public ProfileFetcher getFetcher() {
        return null;
    }

    public void validate(IEntityClass entityClass, Map<String, Object> body) {
        this.transformerPipeline.validate(entityClass, (List)entityClass.fields(), body);
    }
}

