/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.auth.tree;

import com.xforceplus.tenant.data.auth.dto.ConditionDTO;
import com.xforceplus.tenant.data.auth.dto.SqlFieldConditionDTO;
import com.xforceplus.tenant.data.auth.dto.Status;
import com.xforceplus.tenant.data.domain.rule.Relation;
import com.xforceplus.tenant.data.domain.rule.RelationType;
import com.xforceplus.tenant.data.domain.rule.RuleConditionRelationship;
import com.xforceplus.ultraman.adapter.auth.tree.ConditionDTONode;
import com.xforceplus.ultraman.adapter.auth.tree.ConditionSQLNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.BinaryTreeNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.LinkedBinaryTreeNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.builder.TreeBuilder;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.ConditionNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.OperationNode;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultTreeBuilder
implements TreeBuilder<ConditionDTO> {
    public BinaryTreeNode<ConditionNode> build(List<ConditionDTO> conditions, String relation) {
        LinkedBinaryTreeNode prev = null;
        for (ConditionDTO condition : conditions) {
            if (condition.getStatus() != Status.VALID) continue;
            ConditionDTONode node = new ConditionDTONode(condition);
            LinkedBinaryTreeNode nextMain = new LinkedBinaryTreeNode((Object)node);
            RelationType nextRelation = condition.getNextRelation();
            LinkedBinaryTreeNode nextOperation = null;
            if (nextRelation != null) {
                OperationNode operationNode = this.toOperationNode((Relation)nextRelation);
                nextOperation = new LinkedBinaryTreeNode((Object)operationNode);
            }
            if (prev == null) {
                if (nextOperation != null) {
                    prev = nextOperation;
                    nextOperation.setLeft(this.expandSqlField((BinaryTreeNode<ConditionNode>)nextMain, relation));
                    continue;
                }
                prev = nextMain;
                continue;
            }
            if (prev.getData() instanceof ConditionDTO) {
                throw new RuntimeException("Condition Tree has no link, TODO");
            }
            prev.setRight(this.expandSqlField((BinaryTreeNode<ConditionNode>)nextMain, relation));
            if (nextOperation == null) continue;
            nextOperation.setLeft((BinaryTreeNode)prev);
            prev = nextOperation;
        }
        return prev;
    }

    private BinaryTreeNode<ConditionNode> buildSubTree(List<Tuple2<String, List<SqlFieldConditionDTO>>> sqlConditions) {
        LinkedBinaryTreeNode prev = null;
        for (Tuple2<String, List<SqlFieldConditionDTO>> tuple : sqlConditions) {
            for (SqlFieldConditionDTO condition : (List)tuple._2()) {
                if (condition.getStatus() != Status.VALID && condition.getStatus() != null) continue;
                ConditionSQLNode node = new ConditionSQLNode((String)tuple._1(), condition);
                LinkedBinaryTreeNode nextMain = new LinkedBinaryTreeNode((Object)node);
                RuleConditionRelationship nextRelation = condition.getDataRelation();
                LinkedBinaryTreeNode nextOperation = null;
                if (nextRelation != null && nextRelation != RuleConditionRelationship.UN_KNOWN) {
                    OperationNode operationNode = this.toOperationNode(nextRelation);
                    nextOperation = new LinkedBinaryTreeNode((Object)operationNode);
                }
                if (prev == null) {
                    if (nextOperation != null) {
                        prev = nextOperation;
                        nextOperation.setLeft((BinaryTreeNode)nextMain);
                        continue;
                    }
                    prev = nextMain;
                    continue;
                }
                if (prev.getData() instanceof SqlFieldConditionDTO) {
                    throw new RuntimeException("Condition Tree has no link, TODO");
                }
                prev.setRight((BinaryTreeNode)nextMain);
                if (nextOperation == null) continue;
                nextOperation.setLeft((BinaryTreeNode)prev);
                prev = nextOperation;
            }
        }
        return prev;
    }

    private OperationNode toOperationNode(RuleConditionRelationship relationship) {
        if (relationship == RuleConditionRelationship.AND) {
            return new OperationNode(OperationNode.OP.AND);
        }
        if (relationship == RuleConditionRelationship.OR) {
            return new OperationNode(OperationNode.OP.OR);
        }
        return new OperationNode(OperationNode.OP.UNKNOWN);
    }

    private OperationNode toOperationNode(Relation relation) {
        if (relation.getCode().equals(RelationType.AND.getCode())) {
            return new OperationNode(OperationNode.OP.AND);
        }
        if (relation.getCode().equals(RelationType.OR.getCode())) {
            return new OperationNode(OperationNode.OP.OR);
        }
        return new OperationNode(OperationNode.OP.UNKNOWN);
    }

    private BinaryTreeNode<ConditionNode> expandSqlField(BinaryTreeNode<ConditionNode> nextMain, String relation) {
        ConditionNode data;
        BinaryTreeNode<ConditionNode> ptr = nextMain;
        if (ptr != null && (data = (ConditionNode)nextMain.getData()) != null && data.getNodeType() == ConditionNode.NodeType.RAW) {
            Object value = data.value();
            ConditionDTO dto = (ConditionDTO)value;
            List sqlFields = dto.getRuleSqlFields();
            List<Tuple2<String, List<SqlFieldConditionDTO>>> sqlConditions = Optional.ofNullable(sqlFields).orElseGet(Collections::emptyList).stream().filter(x -> x.getStatus() == Status.VALID).map(x -> {
                String fieldName = x.getFieldName();
                if (!StringUtils.isEmpty((CharSequence)relation)) {
                    fieldName = "_".concat(relation).concat(".").concat(fieldName);
                }
                List ruleSqlFieldConditions = x.getRuleSqlFieldConditions();
                return Tuple.of((Object)fieldName, (Object)Optional.ofNullable(ruleSqlFieldConditions).orElseGet(Collections::emptyList));
            }).collect(Collectors.toList());
            if (sqlConditions.isEmpty()) {
                return null;
            }
            return this.buildSubTree(sqlConditions);
        }
        return null;
    }
}

