package com.xforceplus.ultraman.adapter.core.impl;

import com.google.common.collect.Sets;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tenant.data.auth.dto.Category;
import com.xforceplus.tenant.data.auth.dto.RuleDTO;
import com.xforceplus.tenant.data.auth.dto.Status;
import com.xforceplus.tenant.data.auth.exception.ClientRuleException;
import com.xforceplus.tenant.data.auth.store.ClientDataRuleProvider;
import com.xforceplus.ultraman.adapter.utils.EntityClassGroupEx;
import com.xforceplus.ultraman.adapter.utils.ExpFactoryEx;
import com.xforceplus.ultraman.adapter.utils.RelTreeHelper;
import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.datarule.domain.dto.RuleNodeDTO;
import com.xforceplus.ultraman.extension.oqsengine.v1.EntityGrpcExecutor;
import com.xforceplus.ultraman.extension.oqsengine.v1.model.StickySession;
import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.*;
import com.xforceplus.ultraman.oqsengine.sdk.*;
import com.xforceplus.ultraman.sdk.core.exception.PermissionFatalException;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.result.*;
import com.xforceplus.ultraman.sdk.core.pipeline.OperationType;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import com.xforceplus.ultraman.sdk.core.rel.legacy.visitor.OrCheckVisitor;
import com.xforceplus.ultraman.sdk.core.rel.tree.BinaryTreeNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.builder.TreeBuilder;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.ConditionNode;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.utils.CompletableFutureUtils;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.xforceplus.metadata.schema.rels.MetadataRelationType.TO_ONE;
import static com.xforceplus.ultraman.adapter.utils.IEntityClassHelper.toEntityUp;
import static com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator.AND;
import static com.xforceplus.ultraman.sdk.core.transaction.OqsTransactionManager.StickySession.STICKY_SESSION;

/**
 * entity facade
 */
@Slf4j
public class EntityFacadeImpl implements EntityFacade {

    private EntityGrpcExecutor entityServiceExecutor;

    private ExecutionConfig executionConfig;

    private EntityClassEngine entityClassEngine;

    private TransformerPipeline transformerPipeline;

    private TreeBuilder treeBuilder;

    private RetryConfig permissionRetryConfig;

    private ExecutorService executorService;

    @Value("${xplat.oqsengine.sdk.tenant.retry:10}")
    private int maxAttempts = 10;

    @Value("${xplat.oqsengine.sdk.tenant.failOnEx:false}")
    private boolean failOnEx = false;

    @Value("${xplat.oqsengine.sdk.tenant.failOnIOEx:false}")
    private boolean failOnIOEx = false;

    @Autowired(required = false)
    private IDataRuleProvider dataRuleProvider;

    @Autowired(required = false)
    private ClientDataRuleProvider clientDataRuleProvider;

    public EntityFacadeImpl(EntityGrpcExecutor entityServiceExecutor, ExecutionConfig executionConfig, EntityClassEngine entityClassEngine, ExecutorService executorService, TransformerPipeline transformerPipeline) {
        this.entityServiceExecutor = entityServiceExecutor;
        this.executionConfig = executionConfig;
        this.entityClassEngine = entityClassEngine;
        this.executorService = executorService;
        this.transformerPipeline = transformerPipeline;
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile) {
        return Optional.empty();
    }

    @Override
    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return Optional.empty();
    }

    @Override
    public Optional<IEntityClass> loadByCode(String bocode, String profile) {
        return Optional.empty();
    }

    @Override
    public Optional<IEntityClass> loadByCode(String bocode, String profile, String version) {
        return Optional.empty();
    }

    @Override
    public CompletionStage<Either<CreateOneResult, Long>> create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<CreateMultiResult, Integer>> createMulti(IEntityClass entityClass, Stream<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<CreateMultiResult, Integer>> createMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<DeleteOneResult, Integer>> deleteOne(IEntityClass entityClass, Long id, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<DeleteMultiResult, Integer>> deleteMulti(IEntityClass entityClass, List<Long> id, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateMultiResult, Integer>> updateMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> updateById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateMultiResult, Integer>> replaceMulti(IEntityClass entityClass, List<Map<String, Object>> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateOneResult, Integer>> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body, int version, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateResult, Integer>> updateByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<UpdateResult, Integer>> replaceByCondition(IEntityClass entityClass, ExpRel rel, Map<String, Object> body, Map<String, Object> context) {
        return null;
    }

    public String getTransId(Map<String, Object> context) {
        return (String) context.get(ContextKeys.StringKeys.TRANSACTION_KEY.name());
    }

    public StickySession getStickySession(Map<String, Object> context) {
        return Optional.ofNullable(context.get(STICKY_SESSION.name())).map(x -> (String) x).map(StickySession::new).orElse(null);
    }

    public Boolean isSimplify(Map<String, Object> context) {
        return Optional.ofNullable(context.get(SIMPLIFY)).map(x -> (Boolean) x).orElse(false);
    }

    /**
     * make sure condition add query
     *
     * @param rel
     * @return
     */
    private ExpRel dealProjects(ExpRel rel) {
        List<ExpNode> projects = rel.getProjects();
        Set<String> relatedCodes = projects.stream().filter(x -> x instanceof ExpField && ((ExpField) x).getName().startsWith("_")).map(x -> {
            String[] parts = ((ExpField) x).getName().split("\\.");
            if (parts.length > 1) {
                return parts[0].substring(1);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());

        /**
         * find out current related
         */
        Set<String> existsCodes = projects.stream().filter(x -> {
            return x instanceof ExpField && ((ExpField) x).getName().endsWith(".id");
        }).map(x -> ((ExpField) x).getName().split("\\.")[0]).collect(Collectors.toSet());

        List<ExpNode> needToAdd = relatedCodes.stream().filter(x -> !existsCodes.contains(x)).map(x -> ExpField.field(x + ".id")).collect(Collectors.toList());

        return rel.mergeOrProjects(needToAdd);
    }

    /**
     * TODO use parse to do
     * know how to get the value
     */
    private Map<String, List<Tuple2<String, String>>> dealExpRel(ExpRel expRel) {

        List<ExpNode> projects = expRel.getProjects();

        if (projects != null) {
            Map<String, List<Tuple2<String, String>>> groupedList = projects.stream().filter(x -> x instanceof ExpField).map(x -> (ExpField) x).filter(x -> x.getName().startsWith("_")).map(x -> {
                String name = x.getName();
                String subName = name.substring(1);
                if (subName.contains(".")) {
                    String[] split = subName.split("\\.");
                    return Tuple.of(split[0], split[1]);
                } else {
                    return Tuple.of(subName, "*");
                }
            }).collect(Collectors.groupingBy(Tuple2::_1));
            return groupedList;
        }

        return Collections.emptyMap();
    }

    /**
     * get related ids
     *
     * @param selectByCondition
     * @param group
     * @return
     */
    private Map<Long, String> collectEntityClassIdMapping(SelectByCondition selectByCondition, EntityClassGroup group) {

        if (selectByCondition == null) {
            return Collections.emptyMap();
        }

        ConditionsUp conditions = selectByCondition.getConditions();
        List<FieldConditionUp> fieldsConditionList = conditions.getFieldsList();
        Long mainId = group.getEntityClass().id();
        Map<Long, String> idSet = new HashMap<>();
        idSet.put(mainId, "");
        Map<Long, String> conditionIds = fieldsConditionList.stream().map(FieldConditionUp::getRelationId).map(x -> {
            if (x > 0) {
                Optional<IRelation> relationOp = group.relation(x);
                if (relationOp.isPresent()) {
                    IRelation relation = relationOp.get();
                    return Tuple.of(relation.getEntityClassId(), relation.getName());
                } else {
                    log.error("Error Relation Id {} in {}", x, group.getEntityClass().code());
                    return null;
                }
            }

            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(x -> x._1, y -> y._2));

        idSet.putAll(conditionIds);

        return idSet;
    }

    /**
     * old
     *
     * @return
     */
    private ExpRel getPermissionTreeConditionLegacy(Map<Long, String> involvedIdsMapping, ExpContext expContext, String profile) {
        try {
            List<RuleDTO> rules = Collections.emptyList();
            try {
                rules = Optional.ofNullable(clientDataRuleProvider.currentUserDataRules()).orElseGet(Collections::emptyList);
            } catch (Throwable throwable) {
                if (failOnEx) {
                    log.warn("fast fail on permission error");
                    throw new PermissionFatalException();
                } else {
                    if (throwable instanceof ClientRuleException) {
                        if (throwable.getCause() != null) {
                            if (throwable.getCause() instanceof IOException) {
                                if (failOnIOEx) {
                                    log.warn("fast fail on permission IO error");
                                    throw new PermissionFatalException();
                                } else {
                                    log.error("permission process error got IO exception try to retry");
                                    Retry permission = Retry.of("permission", permissionRetryConfig);
                                    rules = permission.executeSupplier(() -> clientDataRuleProvider.currentUserDataRules());
                                }
                            } else {
                                //fast fail
                                throw throwable;
                            }
                        } else {
                            //fast fail
                            throw throwable;
                        }
                    } else {
                        //fast fail
                        throw throwable;
                    }
                }
            }

            //filter rules with current rel related
            Set<Tuple2<String, RuleDTO>> filteredRules = rules.stream().map(x -> {
                if (x.getStatus() == Status.VALID && involvedIdsMapping.containsKey(x.getMetaDataId()) && x.getCategory() == Category.SQL) {
                    return Tuple.of(Optional.ofNullable(involvedIdsMapping.get(x.getMetaDataId())).orElse(""), x);
                } else {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());

            List<ExpNode> conditions = filteredRules.stream().map(x -> {
                BinaryTreeNode<ConditionNode> nodeTree = treeBuilder.build(x._2.getRuleConditions(), x._1());
                ExpCondition condition = ExpFactoryEx.createFrom(nodeTree);
                return condition;
            }).collect(Collectors.toList());

            ExpCondition condition = ExpCondition.call(AND, conditions);
            ExpQuery expQuery = new ExpQuery().filters(condition);
            /**
             * will skip calcite and range restrict
             */
            ExpRel permissionExpRel = transformerPipeline.querySideHandleValue(expQuery, expContext, Collections.singleton("calcite"), Collections.singleton("range"));
//
            return permissionExpRel;
        } catch (Exception ex) {
            log.error("permission process error {}", ex);
            if (ex instanceof PermissionFatalException) {
                throw ex;
            }
        }

        return null;
    }

    @Override
    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(ExpContext expContext, ExpRel inputQuery) {

        EntityClassGroup group = expContext.getSchema();

        String transId = getTransId(expContext.getContext());
        StickySession stickySession = getStickySession(expContext.getContext());
        String profile = getProfile(expContext.getContext());
        Boolean isSimplify = isSimplify(expContext.getContext());

        ExpRel rel = dealProjects(inputQuery);
        ExpRel expRel = rel;
        if (transformerPipeline != null) {
            //TODO event name
            expRel = transformerPipeline.querySideHandleValue(rel, expContext);
        }

        Map<String, List<Tuple2<String, String>>> mappingSearch = dealExpRel(expRel);

        /**
         * relation mapping
         */
        Map<String, IRelation> relationMapping = group.getAllRelations().stream().filter(x -> x.getRelationType()
                .equalsIgnoreCase(TO_ONE.name())).collect(Collectors.toMap(x -> x.getName(), x -> x, (a, b) -> a));

        OrCheckVisitor orCheckVisitor = new OrCheckVisitor();
        expRel.accept(orCheckVisitor);

        if (!orCheckVisitor.isHasOr()) {
            SelectByCondition selectByCondition = RelTreeHelper.relToCondition(expRel, expContext, profile);
            SelectByTree treeCondition = null;
            ExpRel permissionExpRel = getPermissionTreeCondition(collectEntityClassIdMapping(selectByCondition, group), expContext, profile);
            if (permissionExpRel != null) {
                OrCheckVisitor newOrCheckVisitor = new OrCheckVisitor();
                permissionExpRel.accept(newOrCheckVisitor);
                if (newOrCheckVisitor.isHasOr()) {
                    treeCondition = RelTreeHelper.relToTree(permissionExpRel, expContext, entityClassEngine, profile);
                } else {
                    selectByCondition = RelTreeHelper.relToCondition(expRel.mergeAnd(permissionExpRel), expContext, profile);
                }
            }

            if (selectByCondition == null) {
                DataCollection<Record> emptyResult = new DataCollection<Record>(0, Collections.emptyList());
                Either<QueryResult, DataCollection<Record>> eitherResult = Either.right(emptyResult);
                return CompletableFuture.completedFuture(eitherResult);
            } else {
                SelectByCondition finalSelectByCondition = selectByCondition;
                return entityServiceExecutor.selectByConditions(selectByCondition
                        //TODO
                        , treeCondition, stickySession, transId, profile, isSimplify).thenComposeAsync(queryResult -> {
                    return handleSubQuery(group, queryResult, mappingSearch, relationMapping, stickySession, profile, transId, isSimplify, finalSelectByCondition.getQueryFieldsList());
                }, executorService);
            }
        } else {

            SelectByTree selectByTree = RelTreeHelper.relToTree(expRel, expContext, entityClassEngine, profile);

            //TODO join related
            return entityServiceExecutor.selectByTree(RelTreeHelper.relToTree(expRel, expContext, entityClassEngine, profile), stickySession, transId, profile, isSimplify).thenComposeAsync(queryResult -> {
                return handleSubQuery(group, queryResult, mappingSearch, relationMapping, stickySession, profile, transId, isSimplify, selectByTree.getProjects().getQueryFieldsList());
            }, executorService);
        }
    }

    /**
     * extract OriginStatus from OperationResult
     *
     * @param operationResult
     * @return
     */
    private ResultStatus.OriginStatus getOriginStatus(OperationResult operationResult) {
        String originStatusString = operationResult.getOriginStatus();
        ResultStatus.OriginStatus originStatus;
        try {
            originStatus = ResultStatus.OriginStatus.valueOf(originStatusString);
        } catch (Exception ex) {
            if (operationResult.getCode() == OperationResult.Code.OK) {
                originStatus = ResultStatus.OriginStatus.SUCCESS;
            } else {
                originStatus = ResultStatus.OriginStatus.UNKNOWN;
            }
        }

        return originStatus;
    }


    private List<Record> toResult(EntityClassGroup group, List<EntityUp> entityUps, List<Long> ids) {
        return entityUps.stream().map(entityUp -> {
            Record record = EntityClassGroupEx.toRecord(group, entityUp);
            //client side type determine
            //do transformer for result
            Map<String, Object> retBody = record.toMap(null);
            List<Tuple2<IEntityField, Object>> tupleList = transformerPipeline
                    .valueSideHandleValue(group, retBody, OperationType.RESULT);
            record.fromMap(getMapFromTuple(tupleList));
            return record;
        }).collect(Collectors.toList());
    }

    private Map<String, Object> getMapFromTuple(List<Tuple2<IEntityField, Object>> tupleList) {

        Map<String, Object> newBody = tupleList.stream()
                .filter(Objects::nonNull).collect(HashMap::new, (m, v) -> m.put(v._1().name(), v._2()), HashMap::putAll);
        return newBody;
    }

    /**
     * query result
     *
     * @param group
     * @param queryResult
     * @return
     */
    private Either<QueryResult, DataCollection<Record>> handleQueryResult(EntityClassGroup group, OperationResult queryResult) {

        ResultStatus.OriginStatus originStatus = getOriginStatus(queryResult);

        if (queryResult.getCode() == OperationResult.Code.OK) {
            List<Record> records;
            try {
                records = toResult(group, queryResult.getQueryResultList(), queryResult.getIdsList());
                return Either.right(DataCollection.from(Tuple.of(queryResult.getTotalRow(), records)));
            } catch (Exception ex) {
                /**
                 * throw exception
                 */
                throw new CompletionException(ex);
            }
        } else {
            return Either.left(new QueryResult(originStatus, queryResult.getMessage()));
        }
    }

    /**
     * handle left join search
     *
     * @param group
     * @param queryResult
     * @param mappingSearch
     * @param relationMapping
     * @param profile
     * @param transId
     * @return
     */
    private CompletableFuture<Either<QueryResult, DataCollection<Record>>> handleSubQuery(EntityClassGroup group, OperationResult queryResult
            , Map<String, List<Tuple2<String, String>>> mappingSearch
            , Map<String, IRelation> relationMapping
            , StickySession stickySession
            , String profile
            , String transId
            , Boolean isSimplify
            , List<QueryFieldsUp> projects
    ) {
        Either<QueryResult, DataCollection<Record>> mainResult = handleQueryResult(group, queryResult);

        if (mainResult.isRight() && mainResult.get().getRowNum() > 0) {
            //left search
            List<Record> records = mainResult.get().getRows();

            /**
             * left join mapping
             */
            List<CompletableFuture<Tuple2<String, Map<Long, Record>>>> sequenceResult = Sets.intersection(mappingSearch.keySet(), relationMapping.keySet()).stream().map(x -> {
                IRelation relation = relationMapping.get(x);
                long entityClassId = relation.getEntityClassId();
                Optional<IEntityClass> entityClassOp = this.load(String.valueOf(entityClassId), profile);

                if (entityClassOp.isPresent()) {
                    //query current entityClassId
                    EntityClassGroup subGroup = entityClassEngine.describe(entityClassOp.get(), profile);
                    /**
                     * get related projects
                     */
                    CompletionStage<List<EntityUp>> futureEntityUps = queryLeftJoin(subGroup, records, x.concat(".id"), stickySession, transId, profile, isSimplify, projects);
                    CompletableFuture<Tuple2<String, Map<Long, Record>>> mapCompletionStage = futureEntityUps.toCompletableFuture().thenApply(entityUps -> {
                        Map<Long, Record> recordsMapping = entityUps.stream()
                                .map(leftJoinOne -> EntityClassGroupEx.toRecord(group, leftJoinOne))
                                .collect(Collectors.toMap(Record::getId, r -> r, (a, b) -> a));
                        return Tuple.of(x, recordsMapping);
                    });
                    return mapCompletionStage;
                } else {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());

            /**
             * flatten the futursses
             */
            CompletableFuture<List<Tuple2<String, Map<Long, Record>>>> sequence = CompletableFutureUtils.sequence(sequenceResult);

            return sequence.thenApply(seq -> {
                Map<String, Map<Long, Record>> valueMap = seq.stream()
                        .collect(Collectors.toMap(tuple -> tuple._1, tuple -> tuple._2, (a1, a2) -> a1));
                return Either.right(DataCollection
                        .from(Tuple.of(queryResult.getTotalRow()
                                , mergeRecord(group, records, valueMap, profile))));
            });
        } else {
            return CompletableFuture.completedFuture(mainResult);
        }
    }


    /**
     * TODO
     *
     * @param records
     * @param valueMap
     * @return
     */
    private List<Record> mergeRecord(EntityClassGroup entityClassGroup, List<Record> records, Map<String, Map<Long, Record>> valueMap, String profile) {

        Set<String> rels = valueMap.keySet();
        return records.stream().map(x -> {
            List<IEntityField> newFields = new LinkedList<>();
            List<Object> values = new LinkedList<>();
            newFields.addAll(x.fields(entityClassGroup.getEntityClass()));
            values.addAll(x.values());
            for (String rel : rels) {
                Optional<Object> idOp = x.get(rel.concat(".id"));

                Optional<IEntityClass> relatedEntityClassOp = entityClassGroup.relatedEntityClass(rel);

                if (idOp.isPresent() && relatedEntityClassOp.isPresent()) {
                    Map<Long, Record> mapping = valueMap.get(rel);
                    if (mapping != null) {
                        Record record = mapping.get(Long.parseLong(idOp.get().toString()));

                        if (record != null) {
                            newFields.addAll(record.fields(rel, relatedEntityClassOp.get()));
                            values.addAll(record.values());
                        } else {
                            log.warn("record is null ");
                        }
                    }
                }
            }

            GeneralRecord generalRecord = new GeneralRecord(newFields);
            generalRecord.setValues(values);
            generalRecord.setId(x.getId());
            generalRecord.setTypeId(x.getTypeId());

            return generalRecord;
        }).collect(Collectors.toList());
    }


    private List<String> findRelatedIds(List<Record> result, String code) {
        List<String> idsStr = result.stream().map(record -> record.get(code))
                .filter(Optional::isPresent)
                .map(x -> x.get().toString())
                .collect(Collectors.toList());
        return idsStr;
    }

    private CompletionStage<List<EntityUp>> queryLeftJoin(EntityClassGroup entityClassGroup
            , List<Record> result, String code, StickySession stickySession, String transId, String profile, boolean isSimplify
            , List<QueryFieldsUp> projects) {

        List<String> relatedIds = findRelatedIds(result, code).stream().collect(Collectors.toList());

        Long id = entityClassGroup.field("id").map(IEntityField::id).orElse(1L);


        /**
         * dummy one is not ok in old version
         */
        ConditionsUp conditionsUp = ConditionsUp.newBuilder()
                .addFields(FieldConditionUp.newBuilder()
                        .setOperation(FieldConditionUp.Op.in)
                        .addAllValues(relatedIds)
                        .setField(FieldUp.newBuilder()
                                .setId(id)
                                .setIdentifier(true)
                                .setFieldType(FieldType.LONG.getType())
                                .build())
                        .build())
                .build();

        SelectByCondition select = SelectByCondition
                .newBuilder()
                //dummy
                .addAllQueryFields(projects)
                .setEntity(toEntityUp(entityClassGroup.getEntityClass()))
                .setConditions(conditionsUp)
                .setPageSize(result.size())
                .setPageNo(1)
                .build();

        /**
         * left join always is simplify
         */
        CompletionStage<OperationResult> leftJoin = entityServiceExecutor.selectByConditions(select, null, stickySession, transId, profile, isSimplify);

        try {
            CompletionStage<List<EntityUp>> finalResult = leftJoin.thenApplyAsync(x -> {
                if (x.getCode() == OperationResult.Code.OK) {
                    return x.getQueryResultList();
                } else {
                    log.error("Query {} failed", x.getMessage());
                    return Collections.emptyList();
                }
            }, executorService);
            return finalResult;
        } catch (Exception ex) {
            log.error("Query {} failed", entityClassGroup.getEntityClass().code());
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    /**
     * TODO involvedIds is currently not used
     * get permission condition
     *
     * @return
     */
    private ExpRel getPermissionTreeCondition(Map<Long, String> involvedIdsMapping, ExpContext expContext, String profile) {

        if (executionConfig.getUsePermission()) {

            if (clientDataRuleProvider != null) {
                //old
                return getPermissionTreeConditionLegacy(involvedIdsMapping, expContext, profile);
            } else if (dataRuleProvider != null) {
                //new
                return getPermissionTreeConditionNew(involvedIdsMapping, expContext, profile);
            }
        }

        return null;
    }

    /**
     * new permission
     *
     * @return
     */
    private ExpRel getPermissionTreeConditionNew(Map<Long, String> involvedIdsMapping, ExpContext expContext, String profile) {
        try {
            Map<Long, List<RuleNodeDTO>> rules = new HashMap<>();
            rules = Optional.ofNullable(dataRuleProvider.currentUserDataRules(new ArrayList<>(involvedIdsMapping.keySet()))).orElseGet(Collections::emptyMap);

            List<ExpNode> conditions = new ArrayList<>();
            //main query
            rules.forEach((k, v) -> {
                ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v, involvedIdsMapping.get(k));
                conditions.add(condition);
            });

            ExpQuery expQuery = new ExpQuery().filters(conditions);
            /**
             * will skip calcite and range restrict
             */
            ExpRel permissionExpRel = transformerPipeline.querySideHandleValue(expQuery, expContext, Collections.singleton("calcite"), Collections.singleton("range"));
//
            return permissionExpRel;
        } catch (Exception ex) {
            log.error("permission process error {}", ex);
            //throw ex;
            return null;
        }
    }


    @Override
    public CompletionStage<Either<QueryResult, DataCollection<Record>>> query(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        EntityClassGroup group = getReader(entityClass, context);
        ExpContext expContext = new ExpContext().withContext(context).setSchema(group);
        return query(expContext, rel);
    }

    @Override
    public <T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel initRel, BiFunction<ExpRel, Record, ExpRel> conditionTransformer, Function<Record, T> transformer, Map<String, Object> context) {
        return null;
    }

    @Override
    public <T> Iterable<T> queryIterate(IEntityClass entityClass, ExpRel rel, Function<Record, T> transformer, boolean isLegacy, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass, Long id, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Either<QueryOneResult, Record>> findOneById(IEntityClass entityClass, IEntityClass subEntityClass, Long id, Map<String, Object> context) {
        return null;
    }

    @Override
    public CompletionStage<Integer> count(IEntityClass entityClass, ExpRel rel, Map<String, Object> context) {
        return null;
    }

    @Override
    public EntityClassGroup getReader(IEntityClass entityClass, Map<String, Object> context) {
        String profile = this.getProfile(context);
        return this.entityClassEngine.describe(entityClass, profile);
    }

    private String getProfile(Map<String, Object> context) {
        return "";
    }

    @Override
    public EntityClassEngine getEntityClassEngine() {
        return this.entityClassEngine;
    }

    @Override
    public ProfileFetcher getFetcher() {
        return null;
    }

    @Override
    public void validate(IEntityClass entityClass, Map<String, Object> body) {

    }
}
