//package com.xforceplus.ultraman.adapter.trans;
//
//import akka.grpc.javadsl.SingleResponseRequestBuilder;
//import com.xforceplus.tech.base.core.context.ContextService;
//import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
//import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
//import com.xforceplus.ultraman.oqsengine.sdk.TransactionUp;
//import com.xforceplus.ultraman.sdk.core.transaction.*;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.util.*;
//import java.util.concurrent.Callable;
//import java.util.concurrent.CompletionStage;
//
//import static com.xforceplus.tech.base.core.context.ContextKeys.StringKeys.TRANSACTION_KEY;
//import static com.xforceplus.ultraman.sdk.core.transaction.OqsTransactionManager.StickySession.STICKY_SESSION;
//import static com.xforceplus.ultraman.sdk.core.transaction.OqsTransactionManager.TransactionKey.TRANSACTION_STACK;
//
///**
// *
// */
//@Slf4j
//public class DefaultTransactionManager implements OqsTransactionManager {
//
//    private Logger logger = LoggerFactory.getLogger(OqsTransactionManager.class);
//
//    //    @Autowired
//    private ContextService contextService;
//
//    //    @Autowired
//    private EntityServiceClient entityServiceClient;
//
//    private TransactionalEventPool transactionalEventPool;
//
//    private ThreadLocal<Map<String, Queue<TransactionCallback>>> callbacks = new ThreadLocal<>();
//
//    public DefaultTransactionManager(ContextService contextService, EntityServiceClient entityServiceClient, TransactionalEventPool transactionalEventPool) {
//        this.contextService = contextService;
//        this.entityServiceClient = entityServiceClient;
//        this.transactionalEventPool = transactionalEventPool;
//    }
//
//    @Override
//    public OqsTransaction getCurrent() {
//        Stack<OqsTransaction> oqsTransactions = contextService.get(TRANSACTION_STACK);
//
//        if (oqsTransactions == null) {
//            contextService.set(TRANSACTION_STACK, new Stack<>());
//            oqsTransactions = contextService.get(TRANSACTION_STACK);
//        }
//
//        return oqsTransactions.isEmpty() ? null : oqsTransactions.peek();
//    }
//
//    private void pushNewTransaction(OqsTransaction oqsTransaction) {
//        Stack<OqsTransaction> oqsTransactions = contextService.get(TRANSACTION_STACK);
//
//        if (oqsTransactions == null) {
//            contextService.set(TRANSACTION_STACK, new Stack<>());
//            oqsTransactions = contextService.get(TRANSACTION_STACK);
//        }
//        oqsTransactions.push(oqsTransaction);
//    }
//
//    private void popTransaction() {
//        Stack<OqsTransaction> oqsTransactions = contextService.get(TRANSACTION_STACK);
//
//        if (oqsTransactions != null) {
//            oqsTransactions.pop();
//        }
//    }
//
//    public OqsTransaction createNewTransaction(int timeout, String message) {
//        //create new
//        //maybe timeout
//
//        String sticky = contextService.get(STICKY_SESSION);
//
//        if (StringUtils.isEmpty(sticky)) {
//            sticky = UUID.randomUUID().toString();
//            contextService.set(STICKY_SESSION, sticky);
//        }
//
//        SingleResponseRequestBuilder<TransactionUp, OperationResult> builder = entityServiceClient
//                .begin()
//                .addHeader("sticky-session", sticky)
//                .addHeader("timeout", String.valueOf(timeout));
//
//        if (!StringUtils.isEmpty(message)) {
//            builder = builder.addHeader("comment", message);
//        }
//
//
//        OperationResult result =
//                builder.invoke(TransactionUp.newBuilder().build())
//                        .toCompletableFuture().join();
//        if (result.getCode() != OperationResult.Code.OK) {
//            throw new TransactionCreateErrorException(result.getMessage());
//        } else {
//            logger.info("Transaction create success with id:{}", result.getTransactionResult());
//            OqsTransaction transaction = new OqsTransaction();
//            transaction.setId(result.getTransactionResult());
//            return transaction;
//        }
//    }
//
////    protected void prepareSynchronization(DefaultTransactionStatus status, TransactionDefinition definition) {
////        if (status.isNewSynchronization()) {
////            TransactionSynchronizationManager.setActualTransactionActive(status.hasTransaction());
////            TransactionSynchronizationManager.setCurrentTransactionIsolationLevel(
////                    definition.getIsolationLevel() != TransactionDefinition.ISOLATION_DEFAULT ?
////                            definition.getIsolationLevel() : null);
////            TransactionSynchronizationManager.setCurrentTransactionReadOnly(definition.isReadOnly());
////            TransactionSynchronizationManager.setCurrentTransactionName(definition.getName());
////            TransactionSynchronizationManager.initSynchronization();
////        }
////    }
//
//    public void commit(String transactionalKey) {
//
//        String stickySession = contextService.get(STICKY_SESSION);
//
//        SingleResponseRequestBuilder<TransactionUp, OperationResult> commitOp = entityServiceClient.commit();
//        if (stickySession != null) {
//            commitOp = commitOp.addHeader("sticky-session", stickySession);
//        }
//
//        CompletionStage<OperationResult> commit = commitOp.invoke(TransactionUp.newBuilder()
//                .setId(transactionalKey)
//                .build());
//        OperationResult result = commit.toCompletableFuture().join();
//        if (result.getCode() != OperationResult.Code.OK) {
//            throw new TransactionCommitException(result.getMessage());
//        } else {
//
//            transactionalEventPool.publishLocal(Long.parseLong(transactionalKey));
//
//            //pull in a explict transaction
//            transactionalEventPool.queryWholeTransEvent(Long.parseLong(transactionalKey), contextService.getAll());
//            //do afterTrans
//            Map<String, Queue<TransactionCallback>> currentTasks = callbacks.get();
//            if (currentTasks != null) {
//                Queue<TransactionCallback> transactionCallbacks = currentTasks.get(transactionalKey);
//                logger.info("Do Task After Transaction");
//                while (!transactionCallbacks.isEmpty()) {
//                    transactionalEventPool.doCallback(transactionCallbacks.poll(), contextService.getAll());
//                }
//
//                /**
//                 * remove
//                 */
//                currentTasks.remove(transactionalKey);
//            }
//        }
//
//        logger.info("transaction {} committed", transactionalKey);
//    }
//
//    private Boolean isTriggerRollBack(Throwable throwable
//            , Class<? extends Throwable>[] noRollBackForClass
//            , Class<? extends Throwable>[] rollBackForClass) {
//        boolean noRollBack = false;
//        boolean rollBack = true;
//
//        if (noRollBackForClass != null && noRollBackForClass.length > 0) {
//            noRollBack = Arrays.stream(noRollBackForClass).anyMatch(x -> x == throwable.getClass());
//        }
//
//        if (rollBackForClass != null && rollBackForClass.length > 0) {
//            rollBack = Arrays.stream(rollBackForClass).anyMatch(x -> x == throwable.getClass());
//        }
//
//        return !noRollBack && rollBack;
//    }
//
//    /**
//     * rollback to clear the current tasks
//     * @param transactionalKey
//     */
//    private void clearCurrentTask(String transactionalKey) {
//        Map<String, Queue<TransactionCallback>> taskMapping = callbacks.get();
//        if (callbacks != null) {
//            taskMapping.remove(transactionalKey);
//        }
//    }
//
//    private void rollBack(String transactionalKey) {
//        logger.info("Roll back {}", transactionalKey);
//
//        String stickySession = contextService.get(STICKY_SESSION);
//
//        transactionalEventPool.cleanLocal(Long.parseLong(transactionalKey));
//
//        try {
//            SingleResponseRequestBuilder<TransactionUp, OperationResult> rollBackOp = entityServiceClient.rollBack();
//
//            if (stickySession != null) {
//                rollBackOp = rollBackOp.addHeader("sticky-session", stickySession);
//            }
//
//            rollBackOp.invoke(TransactionUp.newBuilder()
//                    .setId(transactionalKey)
//                    .build()).toCompletableFuture().join();
//        } catch (Throwable rollbackEx) {
//            logger.error("Rollback Transaction {} failed", rollbackEx.getMessage());
//        }
//    }
//
//    private void logCurrentTransaction() {
//        Stack<OqsTransaction> stack = contextService.get(TRANSACTION_STACK);
//        logger.info("Transaction stack {}", stack);
//    }
//
//    private <T> T doTransactional(Callable<T> callable
//            , OqsTransaction transaction
//            , OqsTransaction previewTransaction
//            , Class<? extends Throwable>[] noRollBackForClass
//            , Class<? extends Throwable>[] rollBackForClass
//            , boolean isOwner
//    ) throws Throwable {
//
//        try {
//            contextService.set(TRANSACTION_KEY, transaction.getId());
//            T output = callable.call();
//
//            boolean isRollBack = transaction.isRollBack();
//
//            if (isRollBack) {
//                if (isOwner) {
//                    rollBack(transaction.getId());
//                }
//                return output;
//            } else {
//                if (isOwner) {
//                    commit(transaction.getId());
//                    transaction.setCommit(true);
//                }
//            }
//
//            return output;
//        } catch (Throwable throwable) {
//            Throwable rootCause = throwable;
//            if (throwable instanceof TransactionWrapperException) {
//                rootCause = rootCause.getCause();
//            }
//            if (isTriggerRollBack(rootCause, noRollBackForClass, rollBackForClass)) {
//                logger.info("Trigger Transaction {} Rollback with ex {}", transaction.getId(), rootCause);
//                if (!isOwner) {
//                    transaction.setRollBack(true);
//                } else {
//                    rollBack(transaction.getId());
//                }
//            }
//
//            throw rootCause;
//        } finally {
//            //TODO
//            if (previewTransaction != null) {
//                contextService.set(TRANSACTION_KEY, previewTransaction.getId());
//            } else {
//                contextService.set(TRANSACTION_KEY, null);
//                contextService.set(STICKY_SESSION, null);
//            }
//        }
//    }
//
//    /**
//     * doTask After transaction
//     *
//     * @param callback
//     */
//    @Override
//    public void doAfterTrans(TransactionCallback callback) {
//        OqsTransaction current = getCurrent();
//
//        if (current != null) {
//            Map<String, Queue<TransactionCallback>> taskMap = callbacks.get();
//            if (taskMap == null) {
//                taskMap = new HashMap<>();
//                callbacks.set(taskMap);
//            }
//
//            taskMap.compute(current.getId(), (k, v) -> {
//                Queue<TransactionCallback> taskQueue;
//                if (v == null) {
//                    taskQueue = new LinkedList<>();
//                } else {
//                    taskQueue = v;
//                }
//
//                taskQueue.offer(callback);
//                return taskQueue;
//            });
//        }
//    }
//
//    @Override
//    public <T> T transactionExecution(Propagation propagation
//            , int timeout
//            , String message
//            , Class<? extends Throwable>[] noRollBackForClass
//            , Class<? extends Throwable>[] rollBackForClass
//            , Callable<T> callable) throws Throwable {
//
//        OqsTransaction currentTransaction = getCurrent();
//
//        T output = null;
//
//        switch (propagation) {
//            case REQUIRED:
//                if (currentTransaction == null) {
//                    OqsTransaction newTransaction = createNewTransaction(timeout, message);
//                    pushNewTransaction(newTransaction);
//                    try {
//                        output = doTransactional(callable, newTransaction, null, noRollBackForClass, rollBackForClass, true);
//                    } finally {
//                        popTransaction();
//                    }
//                } else {
//                    output = doTransactional(callable, currentTransaction, currentTransaction, noRollBackForClass, rollBackForClass, false);
//                }
//
//                break;
//            case REQUIRES_NEW:
//                OqsTransaction newTransaction = createNewTransaction(timeout, message);
//                pushNewTransaction(newTransaction);
//                try {
//                    output = doTransactional(callable, newTransaction, currentTransaction, noRollBackForClass, rollBackForClass, true);
//                } finally {
//                    popTransaction();
//                }
//                break;
//            case MANDATORY:
//                if (currentTransaction == null) {
//                    throw new TransactionalNotExistsException();
//                }
//                output = doTransactional(callable, currentTransaction, currentTransaction, noRollBackForClass, rollBackForClass, false);
//                break;
//            case NOT_SUPPORTED:
//                contextService.set(TRANSACTION_KEY, null);
//                output = callable.call();
//                break;
//            case NEVER:
//                //TODO
//                if (currentTransaction != null) {
//                    throw new TransactionalExistsException();
//                }
//                output = callable.call();
//                break;
//            case SUPPORTS:
//                if (currentTransaction == null) {
//                    output = callable.call();
//                } else {
//                    output = doTransactional(callable, currentTransaction, currentTransaction, noRollBackForClass, rollBackForClass, false);
//                }
//                break;
//            default:
//        }
//
//        logCurrentTransaction();
//
//        return output;
//    }
//}
