package com.xforceplus.ultraman.adapter.utils;

import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import io.vavr.Tuple;
import io.vavr.Tuple2;

import java.util.*;
import java.util.stream.Collectors;

public class EntityClassGroupEx {

    /**
     * record only one record
     * @param body
     * @param entityClassId
     * @return
     */
    public static Record toRecordNew(EntityClassGroup group, Map<Tuple2<String, Long>, Object> body, long entityClassId) {

        IEntityClass targetClass;
        Collection<IEntityField> fieldsList = Collections.emptyList();
        if(group.getEntityClass().id() == entityClassId || entityClassId == 0){
            targetClass = group.getEntityClass();
            fieldsList = group.getAllFields();
        } else {
            Optional<IEntityClass> targetOp = group.getFatherEntityClass().stream().filter(x -> x.id() == entityClassId).findFirst();
            if (targetOp.isPresent()) {
                targetClass = targetOp.get();
                fieldsList = group.classEngine().describe(targetClass, group.profile()).getAllFields();
            } else {
                targetOp = group.getChildrenEntityClass().stream().filter(x -> x.id() == entityClassId).findFirst();
                if(targetOp.isPresent()){
                    targetClass = targetOp.get();
                    fieldsList = group.classEngine().describe(targetClass, group.profile()).getAllFields();
                }
            }
        }

        //get related fields
        Record record = new GeneralRecord(fieldsList, 0);
        record.setTypeId(entityClassId);

        fieldsList.forEach((x) -> {
            record.set(x, body.get(Tuple.of(x.name(), x.id())));
        });

        return record;
    }

    public static Record toRecord(EntityClassGroup group, EntityUp up) {
        Map<Tuple2<String, Long>, Object> retValue = up.getValuesList().stream()
                .collect(Collectors.toMap(x -> {
                            return Tuple.of(x.getName(), x.getFieldId());
                        }
                        , ValueUp::getValue));

        long id = up.getId();

        String profile = up.getProfile();

        Record record = toRecordNew(group, retValue, id);

        if (id > 0) {
            record.setTypeId(id);
        }



        long objId = up.getObjId();
        //reset record field "id" with objId
        record.set("id", objId);
        record.setId(objId);

        return record;
    }

}
