package com.xforceplus.ultraman.adapter.utils;

import com.xforceplus.tenant.data.auth.dto.SqlFieldConditionDTO;
import com.xforceplus.tenant.data.domain.rule.RuleConditionOperation;
import com.xforceplus.tenant.data.domain.rule.RuleConditionValueType;
import com.xforceplus.ultraman.adapter.auth.tree.ConditionSQLNode;
import com.xforceplus.ultraman.datarule.domain.dto.FieldCondDTO;
import com.xforceplus.ultraman.datarule.domain.dto.RuleNodeDTO;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import com.xforceplus.ultraman.sdk.core.rel.tree.BinaryTreeNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.ConditionNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.OperationNode;
import com.xforceplus.ultraman.sdk.infra.exceptions.OperationNotSupportedException;
import org.apache.commons.lang3.StringUtils;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class ExpFactoryEx {


        /**
     *
     * @param rules
     * @return
     */
    public static ExpCondition createFromRuleNodeDTO(List<RuleNodeDTO> rules, String relation) {

        if(null != rules && !rules.isEmpty()) {
            RuleNodeDTO ruleNodeDTO = rules.get(0);
            String nextRelation = ruleNodeDTO.getNextRelation();
            ExpCondition expCondition;
            if(ruleNodeDTO.getIsLeaf()) {
                expCondition = createFromFieldConDTO(ruleNodeDTO.getConds(), relation);
            } else {
                expCondition = createFromRuleNodeDTO(ruleNodeDTO.getNodes(), relation);
            }
            if(nextRelation != null) {
                ExpOperator nextOp = ExpOperator.valueOf(nextRelation);
                return ExpCondition.call(nextOp
                        , expCondition
                        , createFromRuleNodeDTO(rules.subList(1, rules.size()), relation));
            } else {
                return expCondition;
            }
        } else {
            return ExpCondition.alwaysTrue();
        }
    }

    /**
     * field cond dto
     * @param conds
     * @return
     */
    public static ExpCondition createFromFieldConDTO(List<FieldCondDTO> conds, String relation) {
        if(!conds.isEmpty()) {
            FieldCondDTO fieldCondDTO = conds.get(0);
            String fieldCode = fieldCondDTO.getFieldCode();
            if(!StringUtils.isEmpty(relation)) {
                fieldCode = "_".concat(relation).concat(fieldCode);
            }
            String operator = fieldCondDTO.getOperator();
            ExpOperator expOperator = ExpOperator.from(ConditionOp.valueOf(operator));
            List<Object> valueList = fieldCondDTO.getValue();
            if(valueList.isEmpty() && (expOperator != ExpOperator.IS_NULL && expOperator != ExpOperator.IS_NOT_NULL)) {
                return ExpCondition.alwaysFalse();
            } else {
                ExpCondition condition = ExpCondition.call(expOperator, ExpField.field(fieldCode), ExpValue.from(valueList));
                String nextRelation = fieldCondDTO.getNextRelation();
                if (nextRelation != null) {
                    ExpOperator nextOp = ExpOperator.valueOf(nextRelation);
                    return ExpCondition.call(nextOp, condition, createFromFieldConDTO(conds.subList(1, conds.size()), relation));
                } else {
                    return condition;
                }
            }
        } else {
            return ExpCondition.alwaysTrue();
        }
    }

    private static OperationNode toOperationNode(String relation) {
        if ("and".equalsIgnoreCase(relation)) {
            //and
            return new OperationNode(OperationNode.OP.AND);
        } else if ("or".equals(relation)) {
            return new OperationNode(OperationNode.OP.OR);
        } else {
            return new OperationNode(OperationNode.OP.UNKNOWN);
        }
    }


    /**
     * from binary tree node
     *
     * @return
     */
    public static ExpCondition createFrom(BinaryTreeNode<ConditionNode> binaryTreeNode) {
        TransformerVisitor transformerVisitor = new TransformerVisitor();
        binaryTreeNode.traversePostorder(transformerVisitor);
        return transformerVisitor.getExpCondition();
    }

    /**
     * Transform from sqlfield to expl
     */
    static class TransformerVisitor implements BinaryTreeNode.Visitor<ConditionNode> {

        private ExpCondition expCondition;

        private Stack<ExpCondition> subConditions = new Stack<>();

        @Override
        public void visit(BinaryTreeNode<ConditionNode> node) {

            if (node != null) {
                ConditionNode data = node.getData();
                ConditionNode.NodeType nodeType = data.getNodeType();
                if (nodeType == ConditionNode.NodeType.SQL) {
                    String fieldName = ((ConditionSQLNode) data).getFieldName();
                    SqlFieldConditionDTO value = (SqlFieldConditionDTO) data.value();
                    ExpCondition expCondition = toCondition(fieldName, value);
                    subConditions.push(expCondition);
                } else if (nodeType == ConditionNode.NodeType.OP) {
                    OperationNode.OP op = (OperationNode.OP) data.value();

                    List<ExpNode> expConditions = new LinkedList<>();
                    while (!subConditions.empty()) {
                        expConditions.add(subConditions.pop());
                    }

                    if (op == OperationNode.OP.AND) {
                        subConditions.push(ExpCondition.call(ExpOperator.AND, expConditions));
                    } else if (op == OperationNode.OP.OR) {
                        subConditions.push(ExpCondition.call(ExpOperator.OR, expConditions));
                    }
                }
            }
        }

        public ExpCondition getExpCondition() {
            if (expCondition == null && !subConditions.isEmpty()) {
                expCondition = subConditions.pop();
            }
            return expCondition;
        }
    }

    private static ExpCondition toCondition(String fieldName, SqlFieldConditionDTO sql) {
        //Long fieldId = sql.getSqlFieldId();
        RuleConditionOperation operation = sql.getDataOperation();
        ExpOperator operator = toOperator(operation);

        /**
         * TODO need to convert??
         */
        RuleConditionValueType type = sql.getDataType();
        String value = sql.getTargetValue();


        return ExpCondition.call(operator, ExpField.field(fieldName), ExpValue.literal(value));
    }

    private static ExpOperator toOperator(RuleConditionOperation operation) {

        /**
         * return default is equals
         */
        if (operation == null) {
            return ExpOperator.EQUALS;
        }

        switch (operation) {
            case GREATER:
                return ExpOperator.GREATER_THAN;
            case LESS:
                return ExpOperator.LESS_THAN;
            case EQUAL:
                return ExpOperator.EQUALS;
            case NOT_EQUAL:
                return ExpOperator.NOT_EQUALS;
            case GREATER_EQUAL:
                return ExpOperator.GREATER_EQUALS;
            case LESS_EQUAL:
                return ExpOperator.LESS_EQUALS;
            case AFTER:
            case CONTAINS:
            case BEFORE:
                return ExpOperator.LIKE;
            case LIST:
                return ExpOperator.IN;
            default:
                throw new OperationNotSupportedException(OperationNotSupportedException.getMsg(operation.name()));
        }
    }
}
