/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.core.impl;

import akka.grpc.javadsl.SingleResponseRequestBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.xforceplus.ultraman.adapter.utils.IEntityClassHelper;
import com.xforceplus.ultraman.extension.oqsengine.v1.EntityGrpcExecutor;
import com.xforceplus.ultraman.extension.oqsengine.v1.model.StickySession;
import com.xforceplus.ultraman.extension.oqsengine.v1.model.WrappedValueContext;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.ChangelogCountRequest;
import com.xforceplus.ultraman.oqsengine.sdk.ChangelogCountResponse;
import com.xforceplus.ultraman.oqsengine.sdk.ChangelogRequest;
import com.xforceplus.ultraman.oqsengine.sdk.ChangelogResponseList;
import com.xforceplus.ultraman.oqsengine.sdk.EntityMultiUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.ReplayRequest;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByCondition;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByTree;
import com.xforceplus.ultraman.oqsengine.sdk.TransRequest;
import com.xforceplus.ultraman.oqsengine.sdk.ValueListUp;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.sdk.infra.exceptions.InvalidInputsException;
import io.vavr.Tuple2;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityServiceExecutor
implements EntityGrpcExecutor {
    private Logger logger = LoggerFactory.getLogger(EntityServiceExecutor.class);
    private EntityServiceClient entityServiceClient;
    private static String LOCK_HEADER = "lock-header";
    private static String LOCK_TOKEN = "lock-token";
    private static String SIMPLIFY = "simplify";
    private ObjectMapper mapper;
    private String STICKY_SESSION_HEADER = "sticky-session";

    public EntityServiceExecutor(EntityServiceClient entityServiceClient) {
        this.entityServiceClient = entityServiceClient;
        this.mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(EmptyValue.class, (JsonSerializer)new JsonSerializer<EmptyValue>(){

            public void serialize(EmptyValue emptyValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeNull();
            }
        });
        this.mapper.registerModule((Module)simpleModule);
    }

    private <R, P> SingleResponseRequestBuilder<R, P> appendHeader(SingleResponseRequestBuilder<R, P> builder, String headerName, String value) {
        if (value != null) {
            return builder.addHeader(headerName, value);
        }
        return builder;
    }

    public CompletionStage<OperationResult> prepare(EntityUp in) {
        try {
            return this.entityServiceClient.prepare(in);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> prepare(String appId, String env) {
        try {
            SingleResponseRequestBuilder prepare = this.entityServiceClient.prepare();
            prepare = prepare.addHeader("appid", appId).addHeader("env", env);
            return prepare.invoke((Object)EntityUp.newBuilder().build());
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> selectOne(EntityUp entityUp, StickySession stickySession, String transId, String profile) {
        SingleResponseRequestBuilder queryResultBuilder = this.entityServiceClient.selectOne();
        if (transId != null) {
            this.logger.info("Query with Transaction id:{} ", (Object)transId);
        } else {
            this.logger.debug("Query without Transaction");
        }
        queryResultBuilder = this.appendHeader(queryResultBuilder, "transaction-id", transId);
        queryResultBuilder = this.appendHeader(queryResultBuilder, this.STICKY_SESSION_HEADER, Optional.ofNullable(stickySession).map(StickySession::getSticky).orElse("dummy"));
        queryResultBuilder = this.appendHeader(queryResultBuilder, "profile", profile);
        try {
            return queryResultBuilder.invoke((Object)entityUp);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> removeMulti(List<EntityUp> entityUpList, boolean isForce, StickySession stickySession, String transId, String profile, String userDisplayName, String userName) {
        SingleResponseRequestBuilder removeBuilder = this.entityServiceClient.removeMulti();
        if (transId != null) {
            this.logger.info("Delete with Transaction id:{} ", (Object)transId);
        } else {
            this.logger.debug("Delete without Transaction, but will create auto");
        }
        removeBuilder = this.appendHeader(removeBuilder, "transaction-id", transId);
        removeBuilder = this.appendHeader(removeBuilder, this.STICKY_SESSION_HEADER, Optional.ofNullable(stickySession).map(StickySession::getSticky).orElse("dummy"));
        removeBuilder = this.appendHeader(removeBuilder, "profile", profile);
        removeBuilder = this.appendHeader(removeBuilder, "display-name", userDisplayName);
        removeBuilder = this.appendHeader(removeBuilder, "username", userName);
        removeBuilder = this.appendHeader(removeBuilder, "force", isForce ? "true" : null);
        try {
            return removeBuilder.invoke((Object)this.toMulti(entityUpList));
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> remove(EntityUp entityUp, boolean isForce, StickySession stickySession, String transId, String profile, String userDisplayName, String userName) {
        SingleResponseRequestBuilder removeBuilder = this.entityServiceClient.remove();
        if (transId != null) {
            this.logger.info("Delete with Transaction id:{} ", (Object)transId);
        } else {
            this.logger.debug("Delete without Transaction");
        }
        if (stickySession != null) {
            removeBuilder = this.appendHeader(removeBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        removeBuilder = this.appendHeader(removeBuilder, "transaction-id", transId);
        removeBuilder = this.appendHeader(removeBuilder, "profile", profile);
        removeBuilder = this.appendHeader(removeBuilder, "display-name", userDisplayName);
        removeBuilder = this.appendHeader(removeBuilder, "username", userName);
        removeBuilder = this.appendHeader(removeBuilder, "force", isForce ? "true" : null);
        try {
            return removeBuilder.invoke((Object)entityUp);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    private EntityMultiUp toMulti(List<EntityUp> entityUps) {
        if (entityUps.isEmpty()) {
            throw new InvalidInputsException(InvalidInputsException.getMsg((String[])new String[]{"List Cannot be empty"}));
        }
        EntityUp sample = entityUps.get(0);
        List valueListUp = entityUps.stream().map(x -> {
            ValueListUp valueList = ValueListUp.newBuilder().setObjId(x.getObjId()).addAllValues((Iterable)x.getValuesList()).build();
            return valueList;
        }).collect(Collectors.toList());
        EntityMultiUp multiUp = EntityMultiUp.newBuilder().setCode(sample.getCode()).setId(sample.getId()).addAllEntityClasses((Iterable)sample.getEntityClassesList()).addAllFields((Iterable)sample.getFieldsList()).addAllRelation((Iterable)sample.getRelationList()).addAllValues(valueListUp).build();
        return multiUp;
    }

    public CompletionStage<OperationResult> buildMulti(IEntityClass entityClass, List<WrappedValueContext> valueContext, StickySession stickySession, String transId, String profile) {
        SingleResponseRequestBuilder buildBuilder = this.entityServiceClient.buildMulti();
        if (transId != null) {
            this.logger.info("Create with Transaction id:{} ", (Object)transId);
        } else {
            this.logger.debug("Create without Transaction");
        }
        if (stickySession != null) {
            buildBuilder = this.appendHeader(buildBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        buildBuilder = this.appendHeader(buildBuilder, "transaction-id", transId);
        buildBuilder = this.appendHeader(buildBuilder, "profile", profile);
        List<EntityUp> entityUps = valueContext.stream().map(x -> {
            Long id = x.getId();
            List valueTuple = x.getValueTuple();
            EntityUp entityUp = IEntityClassHelper.toEntityUp(entityClass, id, valueTuple);
            List contextValueList = x.getContextField().stream().map(cf -> {
                String context = "";
                try {
                    context = this.mapper.writeValueAsString(cf._2());
                }
                catch (JsonProcessingException e) {
                    this.logger.warn("cannot transform context to value");
                }
                IEntityField field = (IEntityField)cf._1();
                return ValueUp.newBuilder().setFieldType(field.type().getType()).setFieldId(field.id()).setContextStr(context).setName(field.name()).build();
            }).collect(Collectors.toList());
            entityUp = entityUp.toBuilder().addAllValues(contextValueList).build();
            return entityUp;
        }).collect(Collectors.toList());
        try {
            return buildBuilder.invoke((Object)this.toMulti(entityUps));
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> build(IEntityClass entityClass, List<Tuple2<IEntityField, Object>> valueTuple, StickySession stickySession, String transId, String profile, Long id, List<Tuple2<IEntityField, Map<String, Object>>> contextField) {
        SingleResponseRequestBuilder buildBuilder = this.entityServiceClient.build();
        if (transId != null) {
            this.logger.info("Create with Transaction id:{} ", (Object)transId);
        } else {
            this.logger.debug("Create without Transaction");
        }
        if (stickySession != null) {
            this.logger.info("Create with stick session id:{} ", (Object)stickySession.getSticky());
            buildBuilder = this.appendHeader(buildBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        buildBuilder = this.appendHeader(buildBuilder, "transaction-id", transId);
        buildBuilder = this.appendHeader(buildBuilder, "profile", profile);
        EntityUp entityUp = IEntityClassHelper.toEntityUp(entityClass, id, valueTuple);
        List contextValueList = contextField.stream().map(x -> {
            String context = "";
            try {
                context = this.mapper.writeValueAsString(x._2());
            }
            catch (JsonProcessingException e) {
                this.logger.warn("cannot transform context to value");
            }
            IEntityField field = (IEntityField)x._1();
            return ValueUp.newBuilder().setFieldType(field.type().getType()).setFieldId(field.id()).setContextStr(context).setName(field.name()).build();
        }).collect(Collectors.toList());
        entityUp = entityUp.toBuilder().addAllValues(contextValueList).build();
        try {
            return buildBuilder.invoke((Object)entityUp);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> updateMulti(IEntityClass entityClass, List<WrappedValueContext> valueContext, StickySession stickySession, String transId, boolean isReplace, String profile) {
        SingleResponseRequestBuilder updateBuilder = this.entityServiceClient.replaceMulti();
        if (transId != null) {
            this.logger.info("{} with Transaction id:{} ", (Object)(isReplace ? "ReplaceById" : "UpdateById"), (Object)transId);
        } else {
            this.logger.debug("{} without Transaction", (Object)(isReplace ? "ReplaceById" : "UpdateById"));
        }
        if (stickySession != null) {
            this.logger.info("{} with Transaction id:{} ", (Object)(isReplace ? "ReplaceById" : "UpdateById"), (Object)transId);
            updateBuilder = this.appendHeader(updateBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        updateBuilder = this.appendHeader(updateBuilder, "transaction-id", transId);
        updateBuilder = this.appendHeader(updateBuilder, "profile", profile);
        updateBuilder = this.appendHeader(updateBuilder, "mode", isReplace ? "replace" : null);
        List<EntityUp> entityUps = valueContext.stream().map(x -> {
            Long id = x.getId();
            List valueTuple = x.getValueTuple();
            EntityUp entityUp = IEntityClassHelper.toEntityUp(entityClass, id, valueTuple);
            List contextValueList = x.getContextField().stream().map(cf -> {
                String context = "";
                try {
                    context = this.mapper.writeValueAsString(cf._2());
                }
                catch (JsonProcessingException e) {
                    this.logger.warn("cannot transform context to value");
                }
                IEntityField field = (IEntityField)cf._1();
                return ValueUp.newBuilder().setFieldType(field.type().getType()).setFieldId(field.id()).setContextStr(context).setName(field.name()).build();
            }).collect(Collectors.toList());
            entityUp = entityUp.toBuilder().addAllValues(contextValueList).build();
            return entityUp;
        }).collect(Collectors.toList());
        try {
            return updateBuilder.invoke((Object)this.toMulti(entityUps));
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> updateById(IEntityClass entityClass, Long id, List<Tuple2<IEntityField, Object>> valueTuple, List<Tuple2<IEntityField, Map<String, Object>>> contextField, StickySession stickySession, String transId, String profile, boolean isReplace, Integer version) {
        SingleResponseRequestBuilder updateBuilder = this.entityServiceClient.replace();
        if (transId != null) {
            this.logger.info("{} with Transaction id:{} ", (Object)(isReplace ? "ReplaceById" : "UpdateById"), (Object)transId);
        } else {
            this.logger.debug("{} without Transaction", (Object)(isReplace ? "ReplaceById" : "UpdateById"));
        }
        if (stickySession != null) {
            this.logger.info("{} with sticky-session id:{} ", (Object)(isReplace ? "ReplaceById" : "UpdateById"), (Object)stickySession.getSticky());
            updateBuilder = this.appendHeader(updateBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        updateBuilder = this.appendHeader(updateBuilder, "transaction-id", transId);
        updateBuilder = this.appendHeader(updateBuilder, "profile", profile);
        updateBuilder = this.appendHeader(updateBuilder, "mode", isReplace ? "replace" : null);
        EntityUp entityUp = IEntityClassHelper.toEntityUp(entityClass, id, valueTuple);
        if (version != null) {
            entityUp.toBuilder().setVersion((long)version.intValue());
        }
        List contextValueList = contextField.stream().map(x -> {
            String context = "";
            try {
                context = this.mapper.writeValueAsString(x._2());
            }
            catch (JsonProcessingException e) {
                this.logger.warn("cannot transform context to value");
            }
            IEntityField field = (IEntityField)x._1();
            return ValueUp.newBuilder().setFieldType(field.type().getType()).setFieldId(field.id()).setContextStr(context).setName(field.name()).build();
        }).collect(Collectors.toList());
        entityUp = entityUp.toBuilder().addAllValues(contextValueList).build();
        try {
            return updateBuilder.invoke((Object)entityUp);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> updateByCondition(IEntityClass entityClass, SelectByCondition selectByCondition, List<Tuple2<IEntityField, Object>> valueTuple, StickySession stickySession, String transId, String profile, boolean isReplace) {
        SingleResponseRequestBuilder updateBuilder = this.entityServiceClient.replaceByCondition();
        if (transId != null) {
            this.logger.info("{} with Transaction id:{} ", (Object)(isReplace ? "ReplaceById" : "UpdateById"), (Object)transId);
        } else {
            this.logger.debug("{} without Transaction", (Object)(isReplace ? "ReplaceById" : "UpdateById"));
        }
        if (stickySession != null) {
            this.logger.info("{} with sticky-session id:{} ", (Object)(isReplace ? "ReplaceById" : "UpdateById"), (Object)stickySession);
            updateBuilder = this.appendHeader(updateBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        updateBuilder = this.appendHeader(updateBuilder, "transaction-id", transId);
        updateBuilder = this.appendHeader(updateBuilder, "profile", profile);
        updateBuilder = this.appendHeader(updateBuilder, "mode", isReplace ? "replace" : null);
        EntityUp entityUp = IEntityClassHelper.toEntityUp(entityClass, 0L, valueTuple);
        selectByCondition = selectByCondition.toBuilder().setEntity(entityUp).build();
        try {
            return updateBuilder.invoke((Object)selectByCondition);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<OperationResult> selectByConditions(SelectByCondition selectByCondition, SelectByTree tree, StickySession stickySession, String transId, String profile, boolean isSimplify) {
        SingleResponseRequestBuilder searchBuilder = this.entityServiceClient.selectByConditions();
        if (transId != null) {
            this.logger.info("SelectByConditions with Transaction id:{} ", (Object)transId);
        } else {
            this.logger.debug("SelectByConditions without Transaction");
        }
        if (stickySession != null) {
            this.logger.info("SelectByConditions with sticky session id:{} ", (Object)stickySession);
            searchBuilder = this.appendHeader(searchBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        searchBuilder = this.appendHeader(searchBuilder, "transaction-id", transId);
        searchBuilder = this.appendHeader(searchBuilder, "profile", profile);
        searchBuilder = this.appendHeader(searchBuilder, SIMPLIFY, Boolean.toString(isSimplify));
        if (tree != null) {
            selectByCondition = selectByCondition.toBuilder().setTree(tree).build();
        }
        try {
            return searchBuilder.invoke((Object)selectByCondition);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    private CompletableFuture<OperationResult> exception(Throwable throwable) {
        return CompletableFuture.completedFuture(OperationResult.newBuilder().setCode(OperationResult.Code.EXCEPTION).setMessage(throwable.getMessage()).build());
    }

    public CompletionStage<OperationResult> selectByTree(SelectByTree selectByTree, StickySession stickySession, String transId, String profile, boolean isSimplify) {
        SingleResponseRequestBuilder requestBuilder = this.entityServiceClient.selectByTreeFilter();
        if (transId != null) {
            this.logger.info("findRecordsByCondition with Transaction id:{} ", (Object)transId);
        } else {
            this.logger.debug("SelectByConditions without Transaction");
        }
        if (stickySession != null) {
            this.logger.info("findRecordsByCondition with sticky session id:{} ", (Object)stickySession);
            requestBuilder = this.appendHeader(requestBuilder, this.STICKY_SESSION_HEADER, stickySession.getSticky());
        }
        requestBuilder = this.appendHeader(requestBuilder, "transaction-id", transId);
        requestBuilder = this.appendHeader(requestBuilder, "profile", profile);
        requestBuilder = this.appendHeader(requestBuilder, SIMPLIFY, Boolean.toString(isSimplify));
        try {
            return requestBuilder.invoke((Object)selectByTree);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<ChangelogResponseList> getChangelogList(ChangelogRequest changelogRequest) {
        SingleResponseRequestBuilder builder = this.entityServiceClient.changelogList();
        try {
            return builder.invoke((Object)changelogRequest);
        }
        catch (Throwable throwable) {
            CompletableFuture<ChangelogResponseList> completableFuture = new CompletableFuture<ChangelogResponseList>();
            completableFuture.completeExceptionally(throwable);
            return completableFuture;
        }
    }

    public CompletionStage<OperationResult> replay(ReplayRequest replayRequest) {
        SingleResponseRequestBuilder builder = this.entityServiceClient.replay();
        try {
            return builder.invoke((Object)replayRequest);
        }
        catch (Throwable throwable) {
            return this.exception(throwable);
        }
    }

    public CompletionStage<ChangelogCountResponse> getChangelogCount(ChangelogCountRequest request) {
        SingleResponseRequestBuilder builder = this.entityServiceClient.changelogCount();
        try {
            return builder.invoke((Object)request);
        }
        catch (Throwable throwable) {
            CompletableFuture<ChangelogCountResponse> completableFuture = new CompletableFuture<ChangelogCountResponse>();
            completableFuture.completeExceptionally(throwable);
            return completableFuture;
        }
    }

    public CompletionStage<OperationResult> expand(TransRequest trans) {
        try {
            return this.entityServiceClient.expand(trans);
        }
        catch (Throwable throwable) {
            CompletableFuture<OperationResult> completableFuture = new CompletableFuture<OperationResult>();
            completableFuture.completeExceptionally(throwable);
            return completableFuture;
        }
    }
}

