/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.remote.service.impl;

import com.xforceplus.ultraman.adapter.constant.ERROR;
import com.xforceplus.ultraman.adapter.remote.service.CurrentUpdateService;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModulePreparedEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.utils.VersionUtils;
import com.xforceplus.ultraman.oqsengine.sdk.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class CurrentUpdateServiceImpl
implements CurrentUpdateService {
    private static final Logger log = LoggerFactory.getLogger(CurrentUpdateServiceImpl.class);
    private EntityService entityService;
    private ApplicationEventPublisher applicationPublisher;
    private AuthConfig config;
    private Logger logger = LoggerFactory.getLogger(CurrentUpdateService.class);
    Map<Tuple2<String, Integer>, ModuleUpResult> mapping = new ConcurrentHashMap<Tuple2<String, Integer>, ModuleUpResult>();
    Map<Tuple2<String, Integer>, Tuple2<ModuleUpResult, Integer>> fatalList = new ConcurrentHashMap<Tuple2<String, Integer>, Tuple2<ModuleUpResult, Integer>>();
    Map<Tuple2<String, Integer>, List<Tuple2<EntityUp, OperationResult>>> lists = new ConcurrentHashMap<Tuple2<String, Integer>, List<Tuple2<EntityUp, OperationResult>>>();
    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public CurrentUpdateServiceImpl(EntityService entityService, AuthConfig config, ApplicationEventPublisher applicationPublisher) {
        this.entityService = entityService;
        this.applicationPublisher = applicationPublisher;
        this.config = config;
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.schedule(), 2L, 5L, TimeUnit.SECONDS);
    }

    synchronized void schedule() {
        Set<Map.Entry<Tuple2<String, Integer>, ModuleUpResult>> entries = this.mapping.entrySet();
        entries.stream().forEach(x -> this.retry((ModuleUpResult)x.getValue()));
    }

    @Override
    public void saveUpdateModule(ModuleUpResult result) {
        this.mapping.put(this.getTuple(result), result);
    }

    @Override
    public void recordResults(ModuleUpResult result, List<Tuple2<EntityUp, OperationResult>> reps) {
        Tuple2<String, Integer> key = this.getTuple(result);
        this.lists.put(key, reps);
        this.mapping.put(key, result);
    }

    private synchronized void clean(ModuleUpResult result, Tuple2<EntityUp, OperationResult> retryTarget) {
        Tuple2<String, Integer> key = this.getTuple(result);
        List<Tuple2<EntityUp, OperationResult>> tuple2s = this.lists.get(key);
        ArrayList<Tuple2<EntityUp, OperationResult>> mutableList = new ArrayList<Tuple2<EntityUp, OperationResult>>(tuple2s);
        mutableList.remove(retryTarget);
        if (mutableList.size() == 0 && this.mapping.containsKey(key)) {
            this.logger.info("module {} {} is clean", (Object)result.getCode(), (Object)result.getVersion());
            this.mapping.remove(key);
            this.applicationPublisher.publishEvent((Object)new MetadataModulePreparedEvent(result, this.config.getTenant(), this.config.getAppId()));
        } else {
            this.logger.warn("module {} {} Left bo {}", new Object[]{result.getCode(), result.getVersion(), mutableList.size()});
            this.lists.put(key, mutableList);
        }
    }

    private synchronized void fatal(ModuleUpResult result, int errorCode) {
        Tuple2<String, Integer> key = this.getTuple(result);
        if (this.mapping.containsKey(key)) {
            this.mapping.remove(key);
            this.lists.remove(key);
            this.fatalList.put(key, (Tuple2<ModuleUpResult, Integer>)Tuple.of((Object)result, (Object)errorCode));
        }
    }

    @Override
    public void retry(ModuleUpResult result) {
        Tuple2<String, Integer> key = this.getTuple(result);
        List<Tuple2<EntityUp, OperationResult>> tuple2s = this.lists.get(key);
        tuple2s.forEach(x -> {
            CompletionStage prepare = this.entityService.prepare((EntityUp)x._1);
            ((CompletableFuture)prepare.toCompletableFuture().thenAcceptAsync(newResult -> {
                if (newResult.getCode() == OperationResult.Code.OK) {
                    this.clean(result, (Tuple2<EntityUp, OperationResult>)x);
                } else if (newResult.getAffectedRow() == ERROR.REACH_MAX_SLOT.ordinal() || newResult.getAffectedRow() == ERROR.VALIDATION_ERROR.ordinal()) {
                    this.fatal(result, newResult.getAffectedRow());
                }
            })).exceptionally(throwable -> {
                LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, (Throwable)throwable);
                return null;
            });
        });
    }

    @Override
    public Map<String, String> showFatalModule() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.fatalList.entrySet().stream().forEach(entry -> {
            ModuleUpResult moduleUpResult = (ModuleUpResult)((Tuple2)entry.getValue())._1;
            map.put(moduleUpResult.getCode(), moduleUpResult.getVersion() + ":" + ((Tuple2)entry.getValue())._2());
        });
        return map;
    }

    @Override
    public Map<String, Object> showCurrentModule() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.mapping.entrySet().stream().forEach(entry -> {
            Tuple2 key = (Tuple2)entry.getKey();
            ModuleUpResult value = (ModuleUpResult)entry.getValue();
            List<Tuple2<EntityUp, OperationResult>> tuple2s = this.lists.get(key);
            map.put(value.getCode(), tuple2s.stream().map(x -> ((OperationResult)x._2()).getCode()));
        });
        return map;
    }

    private Tuple2<String, Integer> getTuple(ModuleUpResult result) {
        String code = result.getCode();
        Integer versionNum = VersionUtils.toVersionInt((String)result.getVersion());
        return Tuple.of((Object)code, (Object)versionNum);
    }
}

