/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.utils;

import com.xforceplus.ultraman.adapter.utils.FieldScope;
import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.AliasField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.helper.PropertyHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEntityClassReader {
    private Logger logger = LoggerFactory.getLogger(IEntityClassReader.class);
    private IEntityClass entityClass;
    private Map<Long, AliasField> idMappingFieldsAll;
    private Map<String, List<ColumnField>> codedFields_self;
    private Map<String, List<ColumnField>> codedFields_related;
    private List<ColumnField> allColumn_self;
    private List<ColumnField> allColumn_related;
    private Map<Long, List<IEntityClass>> relatedEntities;
    private Map<String, IEntityClass> relatedCodeEntity;
    private static final String FIELD_CODE_AMBIGUOUS = "field [{}] code is ambiguous, return first id [{}]";
    private static final String FIELD_MISSING = "[{}] is not available in EntityClass [{}]";
    private List<AliasField> allFields;
    private Map<Long, IEntityClass> childrenMap = new HashMap<Long, IEntityClass>();

    private IEntityClassReader() {
    }

    public IEntityClassReader(IEntityClass entityClass, IEntityClass ... children) {
        this.entityClass = entityClass;
        Stream entityFields = entityClass.fields().stream();
        Stream entityParentFields = ((Collection)Optional.ofNullable(entityClass.extendEntityClass()).map(IEntityClass::fields).orElse(Collections.emptyList())).stream();
        if (entityClass.childEntityClasses() != null) {
            entityClass.childEntityClasses().forEach(x -> this.childrenMap.put(x.id(), (IEntityClass)x));
        }
        Map<Boolean, List<IRelation>> fieldLikeRelation = entityClass.relations().stream().filter(x -> x.getEntityField() != null).filter(x -> FieldLikeRelationType.from((String)x.getRelationType()).isPresent()).collect(Collectors.groupingBy(x -> ((FieldLikeRelationType)FieldLikeRelationType.from((String)x.getRelationType()).get()).isOwnerSide()));
        this.relatedEntities = entityClass.entityClasses().stream().collect(Collectors.groupingBy(IEntityClass::id));
        this.relatedCodeEntity = entityClass.relations().stream().map(x -> {
            List<IEntityClass> entityClassList = this.relatedEntities.get(x.getEntityClassId());
            if (entityClassList != null) {
                return Tuple.of((Object)x.getName(), (Object)entityClassList.get(0));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(x -> (String)x._1, x -> (IEntityClass)x._2, (a, b) -> a));
        AtomicInteger index = new AtomicInteger(0);
        Stream fieldsInRelated = entityClass.relations().stream().flatMap(rel -> {
            IEntityClass relatedEntityClass = this.relatedEntities.get(rel.getEntityClassId()).get(0);
            Stream<ColumnField> selfStream = relatedEntityClass.fields().stream().map(field -> new ColumnField(PropertyHelper.generateRelatedFieldName((String)rel.getName(), (String)field.name()), field, relatedEntityClass));
            Stream<ColumnField> parentStream = Optional.ofNullable(relatedEntityClass.extendEntityClass()).map(IEntityClass::fields).orElseGet(Collections::emptyList).stream().map(field -> new ColumnField(PropertyHelper.generateRelatedFieldName((String)rel.getName(), (String)field.name()), field, relatedEntityClass.extendEntityClass()));
            return Stream.concat(selfStream, parentStream);
        });
        this.allColumn_self = Stream.concat(Stream.concat(entityFields, entityParentFields), Optional.ofNullable(fieldLikeRelation.get(true)).orElseGet(Collections::emptyList).stream().map(IRelation::getEntityField)).map(x -> new ColumnField(x.name(), x, entityClass)).distinct().peek(x -> x.setIndex(index.getAndIncrement())).collect(Collectors.toList());
        this.allColumn_related = Stream.concat(fieldsInRelated, Optional.ofNullable(fieldLikeRelation.get(false)).orElseGet(Collections::emptyList).stream().map(relation -> {
            IEntityField field = relation.getEntityField();
            return new ColumnField(field.name(), field, this.relatedEntities.get(relation.getEntityClassId()).get(0));
        })).distinct().peek(x -> x.setIndex(index.getAndIncrement())).collect(Collectors.toList());
        this.codedFields_self = this.allColumn_self.stream().collect(Collectors.groupingBy(IEntityField::name));
        this.codedFields_related = this.allColumn_related.stream().collect(Collectors.groupingBy(IEntityField::name));
        Stream allStream = Stream.concat(this.allColumn_self.stream(), this.allColumn_related.stream());
        Map<Long, List<IEntityField>> collect = allStream.collect(Collectors.groupingBy(IEntityField::id));
        this.allFields = collect.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getKey)).map(x -> {
            AliasField field = new AliasField((IEntityField)((List)x.getValue()).get(0));
            ((List)x.getValue()).stream().map(IEntityField::name).forEach(arg_0 -> ((AliasField)field).addName(arg_0));
            return field;
        }).collect(Collectors.toList());
        this.idMappingFieldsAll = this.allFields.stream().collect(Collectors.toMap(AliasField::id, y -> y));
    }

    public IEntityClass getEntityClass() {
        return this.entityClass;
    }

    public Optional<AliasField> field(long id) {
        return this.field(id, FieldScope.ALL);
    }

    public Optional<AliasField> field(long id, FieldScope scope) {
        return Optional.ofNullable(this.idMappingFieldsAll.get(id));
    }

    private boolean checkAmbiguous(List<ColumnField> candidates) {
        return candidates.stream().map(ColumnField::originField).distinct().count() > 1L;
    }

    public List<ColumnField> columns(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Collections.unmodifiableList(this.allColumn_self);
        }
        IEntityClass relatedEntityClass = this.getRelatedEntityClass(code);
        if (relatedEntityClass != null) {
            return this.allColumn_related.stream().filter(x -> x.originEntityClass().id() == relatedEntityClass.id() && x.name().startsWith("_".concat(code).concat("."))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Optional<ColumnField> column(String code, FieldScope scope) {
        if (scope == null) {
            scope = FieldScope.ALL;
        }
        List codeSelectedField = Collections.emptyList();
        switch (scope) {
            case SELF_ONLY: {
                codeSelectedField = Optional.ofNullable(this.codedFields_self.get(code)).orElseGet(Collections::emptyList);
                break;
            }
            case RELATED_ONLY: {
                codeSelectedField = Optional.ofNullable(this.codedFields_related.get(code)).orElseGet(Collections::emptyList);
                break;
            }
            case ALL: {
                codeSelectedField = new LinkedList();
                codeSelectedField.addAll(Optional.ofNullable(this.codedFields_self.get(code)).orElseGet(Collections::emptyList));
                codeSelectedField.addAll(Optional.ofNullable(this.codedFields_related.get(code)).orElseGet(Collections::emptyList));
                break;
            }
        }
        if (!codeSelectedField.isEmpty() && this.checkAmbiguous(codeSelectedField)) {
            this.logger.warn(FIELD_CODE_AMBIGUOUS, (Object)code, codeSelectedField.get(0));
        }
        return codeSelectedField.isEmpty() ? Optional.empty() : Optional.ofNullable(codeSelectedField.get(0));
    }

    public Optional<ColumnField> column(String code) {
        return this.column(code, FieldScope.ALL);
    }

    public List<ColumnField> columns() {
        ArrayList<ColumnField> list = new ArrayList<ColumnField>();
        list.addAll(this.allColumn_self);
        list.addAll(this.allColumn_related);
        return list;
    }

    public IEntityClass getRelatedEntityClass(String code) {
        return this.relatedCodeEntity.get(code);
    }

    public List<IEntityField> fields() {
        return this.fields(FieldScope.ALL);
    }

    public List<IEntityField> fields(FieldScope fieldScope) {
        return Collections.unmodifiableList(this.allFields);
    }

    public Set<String> testBody(Map<String, Object> map) {
        Set<String> inputKeys = map.keySet();
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(this.codedFields_self.keySet());
        allKeys.addAll(this.codedFields_related.keySet());
        return inputKeys.stream().filter(x -> !allKeys.contains(x)).collect(Collectors.toSet());
    }

    public Stream<Tuple2<IEntityField, Object>> zipValue(Map<String, Object> body) {
        this.testBody(body).forEach(x -> this.logger.warn(FIELD_MISSING, x, (Object)this.entityClass.code()));
        Record record = this.toRecord(body);
        return record.stream();
    }

    @Deprecated
    public Record toRecord(Map<String, Object> body) {
        HashSet<ColumnField> columns = new HashSet<ColumnField>();
        List<ColumnField> valueColumn = body.keySet().stream().map(this::column).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        columns.addAll(valueColumn);
        columns.addAll(this.allColumn_self);
        GeneralRecord record = new GeneralRecord(columns);
        valueColumn.forEach(arg_0 -> IEntityClassReader.lambda$toRecord$20((Record)record, body, arg_0));
        return record;
    }

    public Record toRecordNew(Map<Tuple2<String, Long>, Object> body, Long id) {
        IEntityClass entityClass = this.childrenMap.get(id);
        HashSet<Object> columns = new HashSet<Object>();
        Set valueColumns = body.entrySet().stream().map(x -> {
            Optional field1;
            Long fieldId = (Long)((Tuple2)x.getKey())._2();
            Optional<AliasField> field = this.field(fieldId);
            if (field.isPresent()) {
                AliasField aliasField = field.get();
                IEntityField originObject = aliasField.getOriginObject();
                if (originObject instanceof ColumnField) {
                    return new ColumnField((String)((Tuple2)x.getKey())._1(), ((ColumnField)originObject).getOriginObject(), ((ColumnField)originObject).originEntityClass());
                }
            } else if (entityClass != null && (field1 = entityClass.field(fieldId.longValue())).isPresent()) {
                return new ColumnField((String)((Tuple2)x.getKey())._1(), (IEntityField)field1.get(), entityClass);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        columns.addAll(valueColumns);
        columns.addAll(this.allColumn_self);
        GeneralRecord record = new GeneralRecord(columns);
        columns.forEach(arg_0 -> IEntityClassReader.lambda$toRecordNew$22((Record)record, body, arg_0));
        return record;
    }

    public Optional<IEntityClass> getSearchableRelatedEntity(String key) {
        return this.entityClass.relations().stream().filter(x -> FieldLikeRelationType.from((String)x.getRelationType()).map(FieldLikeRelationType::isOwnerSide).orElse(false)).filter(x -> key.equals(x.getName())).map(x -> this.relatedEntities.get(x.getEntityClassId()).get(0)).findFirst();
    }

    public Optional<IEntityField> getRelatedOriginalField(IEntityField entityField) {
        String fieldName = entityField.name();
        String[] fields = fieldName.split("\\.");
        if (fields.length > 1) {
            String relName = fields[0];
            if (relName.startsWith("_")) {
                relName = relName.substring(1);
            }
            return this.column(relName + ".id").map(ColumnField::originField);
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$toRecordNew$22(Record record, Map body, ColumnField x) {
        record.set((IEntityField)x, body.get(Tuple.of((Object)x.name(), (Object)x.id())));
    }

    private static /* synthetic */ void lambda$toRecord$20(Record record, Map body, ColumnField x) {
        record.set((IEntityField)x, body.get(x.name()));
    }
}

