/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.utils;

import com.xforceplus.ultraman.adapter.utils.IEntityClassHelper;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.helper.PropertyHelper;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldConditionUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldSortUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldUp;
import com.xforceplus.ultraman.oqsengine.sdk.FilterNode;
import com.xforceplus.ultraman.oqsengine.sdk.Filters;
import com.xforceplus.ultraman.oqsengine.sdk.Projects;
import com.xforceplus.ultraman.oqsengine.sdk.QueryFieldsUp;
import com.xforceplus.ultraman.oqsengine.sdk.Range;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByCondition;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByTree;
import com.xforceplus.ultraman.oqsengine.sdk.SortNode;
import com.xforceplus.ultraman.oqsengine.sdk.Sorts;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpBi;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRange;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpSort;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpVisitor;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelTreeHelper {
    private static final Logger log = LoggerFactory.getLogger(RelTreeHelper.class);

    private static Void convertTree(ExpCondition rel, ExpVisitor vistor, EntityClassGroup group, Boolean isOldJoinField, Boolean removeIdentifier, Consumer<Map<String, Object>> consumer) {
        ExpField field;
        String name;
        Tuple2 nameCode;
        String fieldCode;
        Optional column;
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        if (rel.isAlwaysTrue()) {
            return null;
        }
        if (rel.isAlwaysFalse()) {
            ctx.put("returnEmpty", true);
            consumer.accept(ctx);
            return null;
        }
        if (rel.getOperator() == ExpOperator.AND) {
            rel.getExpNodes().forEach(x -> x.accept(vistor));
            return null;
        }
        if (rel.getOperator() == ExpOperator.OR) {
            throw new RuntimeException("Legacy mode not support OR in ConditionRequest");
        }
        List expNodes = rel.getExpNodes();
        Optional<ExpNode> firstField = expNodes.stream().filter(x -> x instanceof ExpField).findFirst();
        if (firstField.isPresent() && (column = group.column(fieldCode = (nameCode = PropertyHelper.extractRelated((String)(name = (field = (ExpField)firstField.get()).getName()))) != null ? PropertyHelper.generateRelatedFieldName((String)((String)nameCode._1()), (String)((String)nameCode._2())) : name)).isPresent()) {
            List values = expNodes.stream().filter(x -> x instanceof ExpValue).map(x -> ((ExpValue)x).getStrValue()).filter(Objects::nonNull).collect(Collectors.toList());
            String code = fieldCode;
            if (isOldJoinField.booleanValue()) {
                code = fieldCode.startsWith("_") ? name.substring(1) : name;
            }
            IEntityField targetField = ((ColumnField)column.get()).originField();
            if (removeIdentifier.booleanValue() && ((ColumnField)column.get()).originEntityClass().id() != group.getEntityClass().id() && targetField.config() != null && targetField.config().isIdentifie()) {
                Optional alternativeColumn;
                if (((ColumnField)column.get()).name().startsWith("_") && (alternativeColumn = group.column(((ColumnField)column.get()).name().substring(1))).isPresent()) {
                    targetField = (IEntityField)alternativeColumn.get();
                }
                IEntityField cloneField = targetField.clone();
                cloneField.config().identifie(false);
                targetField = cloneField;
            }
            Long relationId = RelTreeHelper.findRelationId(name, (ColumnField)column.get(), group);
            ctx.put("code", code);
            ctx.put("rel", rel);
            ctx.put("values", values);
            ctx.put("column", column.get());
            ctx.put("relation", relationId);
            consumer.accept(ctx);
        }
        return null;
    }

    static Long findRelationId(String rawName, ColumnField columnField, EntityClassGroup group) {
        if (rawName.contains(".") && rawName.startsWith("_")) {
            String relName = rawName.split("\\.")[0].substring(1);
            Stream<Long> id = Stream.of(Long.valueOf(group.getEntityClass().id()));
            Stream<Long> idStream = group.getFatherEntityClass().stream().map(f -> f.id());
            Set idsSet = Stream.concat(id, idStream).collect(Collectors.toSet());
            Optional<IRelation> relOp = group.getAllRelations().stream().filter(x -> {
                long relOwnerClassId = x.getRelOwnerClassId();
                return idsSet.contains(relOwnerClassId) && x.getName().equalsIgnoreCase(relName);
            }).findAny();
            return relOp.map(x -> x.getId()).orElse(null);
        }
        return null;
    }

    public static String generateOldRelatedFieldName(String code, String fieldName) {
        StringBuffer sb = new StringBuffer();
        sb.append(code);
        sb.append(".");
        sb.append(fieldName);
        return sb.toString();
    }

    public static boolean containsExternal(EntityClassGroup group, ExpRel tree) {
        IEntityClass entityClass = group.getEntityClass();
        if (entityClass.getType() == 1) {
            return true;
        }
        Set<String> externalCodes = group.getAllRelations().stream().filter(x -> {
            Optional relatedEntityClass = group.relatedEntityClass(x.getName());
            if (relatedEntityClass.isPresent()) {
                return ((IEntityClass)relatedEntityClass.get()).getType() == 1;
            }
            return false;
        }).map(x -> x.getName()).collect(Collectors.toSet());
        ExternalVisitor externalVisitor = new ExternalVisitor(externalCodes);
        tree.accept((ExpVisitor)externalVisitor);
        return externalVisitor.isContainsExternal();
    }

    public static Map<String, Object> flatTree(ExpRel tree, ExpContext expContext, String profile) {
        HashMap<String, Object> flatValue = new HashMap<String, Object>();
        EntityClassGroup group = expContext.getSchema();
        FlattenVisitor visitor = new FlattenVisitor(group, profile, flatValue);
        tree.accept((ExpVisitor)visitor);
        return flatValue;
    }

    public static SelectByCondition relToCondition(ExpRel tree, ExpContext expContext, String profile) {
        SelectByCondition.Builder builder = SelectByCondition.newBuilder();
        EntityClassGroup group = expContext.getSchema();
        builder.setEntity(IEntityClassHelper.toEntityUp(group.getEntityClass()));
        ConditionVisitor visitor = new ConditionVisitor(group, false, false, profile);
        tree.accept((ExpVisitor)visitor);
        List<FieldConditionUp> fieldConditions = visitor.getFieldConditions();
        Boolean isEmpty = visitor.getReturnEmpty();
        if (isEmpty.booleanValue()) {
            return null;
        }
        builder.setConditions(ConditionsUp.newBuilder().addAllFields(fieldConditions).build());
        if (tree.getSorts() != null) {
            ExpSort sorts = tree.getSorts();
            List fieldSorts = sorts.getSorts().stream().map(x -> {
                Optional sortField = group.column(x.getCode());
                if (sortField.isPresent()) {
                    return FieldSortUp.newBuilder().setCode(x.getCode()).setField(IEntityClassHelper.toFieldUp((IEntityField)sortField.get())).setOrder(FieldSortUp.Order.valueOf((String)x.getSort().getShort())).build();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            builder.addAllSort(fieldSorts);
        }
        if (tree.getRange() != null && !tree.getRange().isAll()) {
            builder.setPageNo(tree.getRange().getIndex().intValue());
            builder.setPageSize(tree.getRange().getSize().intValue());
        }
        if (tree.getProjects() != null) {
            LinkedList queryFields = new LinkedList();
            for (ExpNode project : tree.getProjects()) {
                String fieldCode;
                ExpField projectField = (ExpField)project;
                Tuple2 relatedFieldNameTuple = PropertyHelper.extractRelated((String)projectField.getName());
                if (relatedFieldNameTuple != null) {
                    String code = (String)relatedFieldNameTuple._1();
                    fieldCode = PropertyHelper.generateRelatedFieldName((String)code, (String)((String)relatedFieldNameTuple._2()));
                } else {
                    fieldCode = projectField.getName();
                }
                LinkedList columns = new LinkedList();
                if (fieldCode.endsWith(".*")) {
                    String code = null;
                    if (relatedFieldNameTuple != null) {
                        code = (String)relatedFieldNameTuple._1();
                    }
                    columns.addAll(group.columns(code));
                } else {
                    Optional column = group.column(fieldCode);
                    column.ifPresent(columns::add);
                    if (!column.isPresent()) {
                        log.warn("Query Field {} is not in current schema {}", (Object)fieldCode, (Object)group.getEntityClass().code());
                    }
                }
                columns.forEach(columnField -> {
                    String name = columnField.name();
                    String code = name.startsWith("_") ? name.substring(1) : name;
                    QueryFieldsUp queryField = QueryFieldsUp.newBuilder().setCode(code).setId(columnField.id()).build();
                    queryFields.add(queryField);
                });
            }
            builder.addAllQueryFields(queryFields);
        }
        return builder.build();
    }

    public static SelectByTree relToTree(ExpRel tree, ExpContext context, EntityClassEngine engine, String profile) {
        List projects = tree.getProjects();
        List filters = tree.getFilters();
        ExpSort sorts = tree.getSorts();
        ExpRange range = tree.getRange();
        IEntityClass schema = context.getSchema().getEntityClass();
        return SelectByTree.newBuilder().setProjects(RelTreeHelper.toProjects(projects, context, profile)).setFilters(RelTreeHelper.toFilters(filters, context, engine, profile)).setSorts(RelTreeHelper.toSorts(sorts, context, profile)).setRange(RelTreeHelper.toRange(range)).setEntity(IEntityClassHelper.toEntityUp(schema)).build();
    }

    private static Filters toFilters(List<ExpNode> nodes, ExpContext context, EntityClassEngine engine, String profile) {
        EntityClassGroup group = context.getSchema();
        List filterNode = nodes.stream().peek(x -> x.setExpContext(context)).map(x -> RelTreeHelper.toFilterNode(x, group, engine)).filter(Objects::nonNull).collect(Collectors.toList());
        return Filters.newBuilder().addAllNodes(filterNode).build();
    }

    private static FilterNode toFilterNode(ExpNode node, EntityClassGroup group, EntityClassEngine engine) {
        if (node instanceof ExpCondition) {
            if (((ExpCondition)node).isAlwaysTrue()) {
                return null;
            }
            return FilterNode.newBuilder().setNodeType(0).setOperator(FilterNode.Operator.valueOf((String)((ExpCondition)node).getOperator().getShortName())).addAllNodes((Iterable)((ExpCondition)node).getExpNodes().stream().map(x -> RelTreeHelper.toFilterNode(x, group, engine)).filter(Objects::nonNull).collect(Collectors.toList())).build();
        }
        if (node instanceof ExpValue) {
            return FilterNode.newBuilder().setNodeType(2).setPayload(((ExpValue)node).getStrValue()).build();
        }
        if (node instanceof ExpField) {
            ExpField expField = (ExpField)node;
            if (StringUtils.isEmpty((CharSequence)expField.getName()) && expField.getId() != null) {
                return FilterNode.newBuilder().setNodeType(1).setPayload(expField.getId().toString()).build();
            }
            Optional column = group.column(expField.getName());
            if (column.isPresent()) {
                Long relationId = RelTreeHelper.findRelationId(expField.getName(), (ColumnField)column.get(), group);
                return FilterNode.newBuilder().setNodeType(1).setFieldUp(IEntityClassHelper.toFieldUp((IEntityField)column.get())).setRelationId(relationId == null ? 0L : relationId).build();
            }
            throw new RuntimeException("Error fieldName " + expField.getName());
        }
        return null;
    }

    private static Projects toProjects(List<ExpNode> projects, ExpContext context, String profile) {
        return Projects.newBuilder().addAllQueryFields((Iterable)projects.stream().peek(x -> x.setExpContext(context)).map(x -> RelTreeHelper.toQueryFieldUp(x, profile)).filter(Objects::nonNull).collect(Collectors.toList())).build();
    }

    private static Optional<ColumnField> getColumnField(ExpContext context, String code) {
        if (context != null && context.getSchema() != null) {
            EntityClassGroup schema = context.getSchema();
            return schema.column(code);
        }
        return Optional.empty();
    }

    private static QueryFieldsUp toQueryFieldUp(ExpNode expNode, String profile) {
        ExpContext context;
        Optional<ColumnField> column;
        if (expNode instanceof ExpField && (column = RelTreeHelper.getColumnField(context = expNode.getExpContext(), ((ExpField)expNode).getName())).isPresent()) {
            return QueryFieldsUp.newBuilder().setId(column.get().id()).setEntityId(column.get().originEntityClass().id()).setCode(((ExpField)expNode).getName()).build();
        }
        return null;
    }

    private static Sorts toSorts(ExpSort sorts, ExpContext context, String profile) {
        if (sorts == null) {
            return Sorts.newBuilder().build();
        }
        return Sorts.newBuilder().addAllSort((Iterable)sorts.getSorts().stream().map(x -> RelTreeHelper.toSortNode(x, context, profile)).filter(Objects::nonNull).collect(Collectors.toList())).build();
    }

    private static SortNode toSortNode(ExpSort.FieldSort sort, ExpContext context, String profile) {
        Optional<ColumnField> column = RelTreeHelper.getColumnField(context, sort.getCode());
        return column.map(columnField -> SortNode.newBuilder().setCode(sort.getCode()).setFieldId(columnField.id()).setOrder(sort.getSort() == ExpSort.Sort.ASCEND ? SortNode.Order.asc : SortNode.Order.desc).build()).orElse(null);
    }

    private static Range toRange(ExpRange range) {
        Range.Builder builder = Range.newBuilder();
        if (range != null && range.getIndex() != null) {
            builder.setPageIndex(range.getIndex().intValue());
        }
        if (range != null && range.getSize() != null) {
            builder.setPageSize(range.getSize().intValue());
        }
        return builder.buildPartial();
    }

    static class ExternalVisitor
    implements ExpVisitor<Void> {
        private boolean containsExternal = false;
        private Set<String> externalCode;

        public ExternalVisitor(Set<String> externalCode) {
            this.externalCode = externalCode;
        }

        public Void visit(ExpField field) {
            return null;
        }

        public Void visit(ExpCondition rel) {
            String code;
            String[] split;
            ExpField field;
            List expNodes;
            Optional<ExpNode> conditionKey;
            if (rel.isAlwaysTrue() || rel.isAlwaysFalse()) {
                return null;
            }
            if ((rel.getOperator() != ExpOperator.AND || rel.getOperator() != ExpOperator.OR) && (conditionKey = (expNodes = rel.getExpNodes()).stream().filter(x -> x instanceof ExpField).findFirst()).isPresent() && (field = (ExpField)conditionKey.get()).getName().startsWith("_") && field.getName().contains(".") && (split = field.getName().split("\\.")).length > 1 && this.externalCode.contains(code = split[0].substring(1))) {
                this.containsExternal = true;
                return null;
            }
            return null;
        }

        public Void visit(ExpValue value) {
            return null;
        }

        public Void visit(ExpBi bi) {
            return null;
        }

        public Void visit(ExpSort expSort) {
            return null;
        }

        public Void visit(ExpRange range) {
            return null;
        }

        public boolean isContainsExternal() {
            return this.containsExternal;
        }

        public void setContainsExternal(boolean containsExternal) {
            this.containsExternal = containsExternal;
        }
    }

    static class ConditionVisitor
    implements ExpVisitor<Void> {
        List<FieldConditionUp> fieldConditions = new LinkedList<FieldConditionUp>();
        private EntityClassGroup group;
        private Boolean isOldJoinField;
        private Boolean removeIdentifier;
        private boolean returnEmpty = false;
        private String profile;

        public List<FieldConditionUp> getFieldConditions() {
            return this.fieldConditions;
        }

        public Boolean getReturnEmpty() {
            return this.returnEmpty;
        }

        public ConditionVisitor(EntityClassGroup group, Boolean isOldJoinField, Boolean removeIdentifier, String profile) {
            this.group = group;
            this.isOldJoinField = isOldJoinField;
            this.removeIdentifier = removeIdentifier;
            this.profile = profile;
        }

        public Void visit(ExpField field) {
            return null;
        }

        public Void visit(ExpCondition rel) {
            RelTreeHelper.convertTree(rel, this, this.group, this.isOldJoinField, this.removeIdentifier, ctx -> {
                if (Boolean.TRUE.equals(ctx.get("returnEmpty"))) {
                    this.returnEmpty = true;
                } else {
                    String code = (String)ctx.get("code");
                    ColumnField column = (ColumnField)ctx.get("column");
                    List values = (List)ctx.get("values");
                    Object relationId = ctx.get("relation");
                    FieldConditionUp.Builder fieldBuilder = FieldConditionUp.newBuilder();
                    FieldConditionUp fieldCondition = fieldBuilder.setCode(code).setOperation(FieldConditionUp.Op.valueOf((String)rel.getOperator().getShortName())).addAllValues((Iterable)values).setField(this.toFieldUp(column)).setRelationId(relationId == null ? 0L : (Long)relationId).build();
                    this.fieldConditions.add(fieldCondition);
                }
            });
            return null;
        }

        FieldUp toFieldUp(ColumnField columnField) {
            IEntityField originField = columnField.getOriginObject();
            FieldUp fieldUp = IEntityClassHelper.toFieldUp(originField);
            long originClassId = columnField.originEntityClass().id();
            return fieldUp.toBuilder().setOwnerClassId(originClassId).build();
        }

        public Void visit(ExpValue value) {
            return null;
        }

        public Void visit(ExpBi bi) {
            return null;
        }

        public Void visit(ExpSort expSort) {
            return null;
        }

        public Void visit(ExpRange range) {
            return null;
        }
    }

    static class FlattenVisitor
    implements ExpVisitor<Void> {
        private EntityClassGroup group;
        private String profile;
        private Map<String, Object> flatValue;

        public FlattenVisitor(EntityClassGroup group, String profile, Map<String, Object> flatValue) {
            this.group = group;
            this.profile = profile;
            this.flatValue = flatValue;
        }

        public Void visit(ExpField field) {
            return null;
        }

        public Void visit(ExpCondition rel) {
            RelTreeHelper.convertTree(rel, this, this.group, false, false, ctx -> {
                if (!Boolean.TRUE.equals(ctx.get("returnEmpty"))) {
                    String code = (String)ctx.get("code");
                    ColumnField column = (ColumnField)ctx.get("column");
                    List values = (List)ctx.get("values");
                    Object relationId = ctx.get("relationId");
                    if (rel.getOperator().equals((Object)ExpOperator.EQUALS)) {
                        this.flatValue.put(relationId == null ? code : relationId.toString().concat(".").concat(code), values);
                    }
                    String rawCode = code.concat("$$").concat(rel.getOperator().getShortName());
                    this.flatValue.put(relationId == null ? rawCode : relationId.toString().concat(".").concat(rawCode), values);
                }
            });
            return null;
        }

        public Void visit(ExpValue value) {
            return null;
        }

        public Void visit(ExpBi bi) {
            return null;
        }

        public Void visit(ExpSort expSort) {
            return null;
        }

        public Void visit(ExpRange range) {
            return null;
        }
    }
}

