package com.xforceplus.ultraman.app.aliqianniu.controller;


/**
 * 用户授权feign客户端
 *
 * @author ultraman
 * @date 2025-10-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.UserAuth;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ali-qianniu")
public interface UserAuthFeignApi {

  /**
   * 通过id查询用户授权
   * @param  id
   * @return R
   */
  @GetMapping("/userAuth/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增用户授权
   * @param userAuth 用户授权
   * @return R
   */
  @PostMapping("/userAuth/add")
  public R save(@RequestBody UserAuth userAuth);

  /**
   * 修改用户授权
   * @param userAuth 用户授权
   * @return R
   */
  @PostMapping("/userAuth/update")
  public R updateById(@RequestBody UserAuth userAuth);

  /**
   * 通过id删除用户授权
   * @param  id
   * @return R
   */
  @DeleteMapping("/userAuth/del/{id}" )
  public R removeById(@PathVariable Long id);

}