package com.xforceplus.ultraman.app.aliqianniu.controller;


/**
 * 阿里千牛入驻信息feign客户端
 *
 * @author ultraman
 * @date 2025-10-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.UserTenant;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ali-qianniu")
public interface UserTenantFeignApi {

  /**
   * 通过id查询阿里千牛入驻信息
   * @param  id
   * @return R
   */
  @GetMapping("/userTenant/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增阿里千牛入驻信息
   * @param userTenant 阿里千牛入驻信息
   * @return R
   */
  @PostMapping("/userTenant/add")
  public R save(@RequestBody UserTenant userTenant);

  /**
   * 修改阿里千牛入驻信息
   * @param userTenant 阿里千牛入驻信息
   * @return R
   */
  @PostMapping("/userTenant/update")
  public R updateById(@RequestBody UserTenant userTenant);

  /**
   * 通过id删除阿里千牛入驻信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/userTenant/del/{id}" )
  public R removeById(@PathVariable Long id);

}