package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 颜色类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-17
 */
public enum ColorType {

    BLUE("blue", "蓝票"),
    RED("red", "红票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ColorType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ColorType fromCode(String code){
        switch(code) {
            case "blue":
                return BLUE;
            case "red":
                return RED;
            default:
                return null;
        }
    }
}
