package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 上传状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-17
 */
public enum UploadStatus {

    _0("0", "未上传"),
    _1("1", "上传成功"),
    _2("2", "上传失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    UploadStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UploadStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
