package com.xforceplus.ultraman.app.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * erp渠道
 * </p>
 *
 * @author ultraman
 * @since 2023-10-10
 */
public enum EcErpChannel {

    SLPDD("SLPDD", "采集-拼多多"),
    QNSELLER001("qnseller001", "isv-阿里千牛"),
    YUXIAOER("yuxiaoer", "寓小二"),
    PDDRPA("PDDRPA", "RPA-拼多多"),
    YOUZAN("YOUZAN", "isv-有赞");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EcErpChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcErpChannel fromCode(String code){
        switch(code) {
            case "SLPDD":
                return SLPDD;
            case "qnseller001":
                return QNSELLER001;
            case "yuxiaoer":
                return YUXIAOER;
            case "PDDRPA":
                return PDDRPA;
            case "YOUZAN":
                return YOUZAN;
            default:
                return null;
        }
    }
}
